/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputConfiguration.Builder, InputConfiguration> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(InputConfiguration::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final SdkField<AssetProcessingConfiguration> ASSET_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<AssetProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("assetProcessingConfiguration")
            .getter(getter(InputConfiguration::assetProcessingConfiguration))
            .setter(setter(Builder::assetProcessingConfiguration))
            .constructor(AssetProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetProcessingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            ASSET_PROCESSING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final AssetProcessingConfiguration assetProcessingConfiguration;

    private InputConfiguration(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.assetProcessingConfiguration = builder.assetProcessingConfiguration;
    }

    /**
     * <p>
     * S3 uri.
     * </p>
     * 
     * @return S3 uri.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Asset processing configuration
     * </p>
     * 
     * @return Asset processing configuration
     */
    public final AssetProcessingConfiguration assetProcessingConfiguration() {
        return assetProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(assetProcessingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputConfiguration)) {
            return false;
        }
        InputConfiguration other = (InputConfiguration) obj;
        return Objects.equals(s3Uri(), other.s3Uri())
                && Objects.equals(assetProcessingConfiguration(), other.assetProcessingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputConfiguration").add("S3Uri", s3Uri())
                .add("AssetProcessingConfiguration", assetProcessingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "assetProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(assetProcessingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Uri", S3_URI_FIELD);
        map.put("assetProcessingConfiguration", ASSET_PROCESSING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputConfiguration, T> g) {
        return obj -> g.apply((InputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputConfiguration> {
        /**
         * <p>
         * S3 uri.
         * </p>
         * 
         * @param s3Uri
         *        S3 uri.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Asset processing configuration
         * </p>
         * 
         * @param assetProcessingConfiguration
         *        Asset processing configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetProcessingConfiguration(AssetProcessingConfiguration assetProcessingConfiguration);

        /**
         * <p>
         * Asset processing configuration
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link AssetProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #assetProcessingConfiguration(AssetProcessingConfiguration)}.
         * 
         * @param assetProcessingConfiguration
         *        a consumer that will call methods on {@link AssetProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetProcessingConfiguration(AssetProcessingConfiguration)
         */
        default Builder assetProcessingConfiguration(Consumer<AssetProcessingConfiguration.Builder> assetProcessingConfiguration) {
            return assetProcessingConfiguration(AssetProcessingConfiguration.builder()
                    .applyMutation(assetProcessingConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private AssetProcessingConfiguration assetProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputConfiguration model) {
            s3Uri(model.s3Uri);
            assetProcessingConfiguration(model.assetProcessingConfiguration);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final AssetProcessingConfiguration.Builder getAssetProcessingConfiguration() {
            return assetProcessingConfiguration != null ? assetProcessingConfiguration.toBuilder() : null;
        }

        public final void setAssetProcessingConfiguration(AssetProcessingConfiguration.BuilderImpl assetProcessingConfiguration) {
            this.assetProcessingConfiguration = assetProcessingConfiguration != null ? assetProcessingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder assetProcessingConfiguration(AssetProcessingConfiguration assetProcessingConfiguration) {
            this.assetProcessingConfiguration = assetProcessingConfiguration;
            return this;
        }

        @Override
        public InputConfiguration build() {
            return new InputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
