/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Video asset processing configuration
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoAssetProcessingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoAssetProcessingConfiguration.Builder, VideoAssetProcessingConfiguration> {
    private static final SdkField<VideoSegmentConfiguration> SEGMENT_CONFIGURATION_FIELD = SdkField
            .<VideoSegmentConfiguration> builder(MarshallingType.SDK_POJO).memberName("segmentConfiguration")
            .getter(getter(VideoAssetProcessingConfiguration::segmentConfiguration))
            .setter(setter(Builder::segmentConfiguration)).constructor(VideoSegmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VideoSegmentConfiguration segmentConfiguration;

    private VideoAssetProcessingConfiguration(BuilderImpl builder) {
        this.segmentConfiguration = builder.segmentConfiguration;
    }

    /**
     * <p>
     * Delimits the segment of the input that will be processed
     * </p>
     * 
     * @return Delimits the segment of the input that will be processed
     */
    public final VideoSegmentConfiguration segmentConfiguration() {
        return segmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoAssetProcessingConfiguration)) {
            return false;
        }
        VideoAssetProcessingConfiguration other = (VideoAssetProcessingConfiguration) obj;
        return Objects.equals(segmentConfiguration(), other.segmentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoAssetProcessingConfiguration").add("SegmentConfiguration", segmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "segmentConfiguration":
            return Optional.ofNullable(clazz.cast(segmentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("segmentConfiguration", SEGMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoAssetProcessingConfiguration, T> g) {
        return obj -> g.apply((VideoAssetProcessingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoAssetProcessingConfiguration> {
        /**
         * <p>
         * Delimits the segment of the input that will be processed
         * </p>
         * 
         * @param segmentConfiguration
         *        Delimits the segment of the input that will be processed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentConfiguration(VideoSegmentConfiguration segmentConfiguration);

        /**
         * <p>
         * Delimits the segment of the input that will be processed
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoSegmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoSegmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSegmentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #segmentConfiguration(VideoSegmentConfiguration)}.
         * 
         * @param segmentConfiguration
         *        a consumer that will call methods on {@link VideoSegmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentConfiguration(VideoSegmentConfiguration)
         */
        default Builder segmentConfiguration(Consumer<VideoSegmentConfiguration.Builder> segmentConfiguration) {
            return segmentConfiguration(VideoSegmentConfiguration.builder().applyMutation(segmentConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VideoSegmentConfiguration segmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoAssetProcessingConfiguration model) {
            segmentConfiguration(model.segmentConfiguration);
        }

        public final VideoSegmentConfiguration.Builder getSegmentConfiguration() {
            return segmentConfiguration != null ? segmentConfiguration.toBuilder() : null;
        }

        public final void setSegmentConfiguration(VideoSegmentConfiguration.BuilderImpl segmentConfiguration) {
            this.segmentConfiguration = segmentConfiguration != null ? segmentConfiguration.build() : null;
        }

        @Override
        public final Builder segmentConfiguration(VideoSegmentConfiguration segmentConfiguration) {
            this.segmentConfiguration = segmentConfiguration;
            return this;
        }

        @Override
        public VideoAssetProcessingConfiguration build() {
            return new VideoAssetProcessingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
