/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Delimits the segment of the input that will be processed
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSegmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoSegmentConfiguration.Builder, VideoSegmentConfiguration> {
    private static final SdkField<TimestampSegment> TIMESTAMP_SEGMENT_FIELD = SdkField
            .<TimestampSegment> builder(MarshallingType.SDK_POJO).memberName("timestampSegment")
            .getter(getter(VideoSegmentConfiguration::timestampSegment)).setter(setter(Builder::timestampSegment))
            .constructor(TimestampSegment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampSegment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_SEGMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimestampSegment timestampSegment;

    private final Type type;

    private VideoSegmentConfiguration(BuilderImpl builder) {
        this.timestampSegment = builder.timestampSegment;
        this.type = builder.type;
    }

    /**
     * <p>
     * Timestamp segment
     * </p>
     * 
     * @return Timestamp segment
     */
    public final TimestampSegment timestampSegment() {
        return timestampSegment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestampSegment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSegmentConfiguration)) {
            return false;
        }
        VideoSegmentConfiguration other = (VideoSegmentConfiguration) obj;
        return Objects.equals(timestampSegment(), other.timestampSegment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSegmentConfiguration").add("TimestampSegment", timestampSegment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestampSegment":
            return Optional.ofNullable(clazz.cast(timestampSegment()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #timestampSegment()} initialized to the given value.
     *
     * <p>
     * Timestamp segment
     * </p>
     * 
     * @param timestampSegment
     *        Timestamp segment
     */
    public static VideoSegmentConfiguration fromTimestampSegment(TimestampSegment timestampSegment) {
        return builder().timestampSegment(timestampSegment).build();
    }

    /**
     * Create an instance of this class with {@link #timestampSegment()} initialized to the given value.
     *
     * <p>
     * Timestamp segment
     * </p>
     * 
     * @param timestampSegment
     *        Timestamp segment
     */
    public static VideoSegmentConfiguration fromTimestampSegment(Consumer<TimestampSegment.Builder> timestampSegment) {
        TimestampSegment.Builder builder = TimestampSegment.builder();
        timestampSegment.accept(builder);
        return fromTimestampSegment(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timestampSegment", TIMESTAMP_SEGMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSegmentConfiguration, T> g) {
        return obj -> g.apply((VideoSegmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSegmentConfiguration> {
        /**
         * <p>
         * Timestamp segment
         * </p>
         * 
         * @param timestampSegment
         *        Timestamp segment
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampSegment(TimestampSegment timestampSegment);

        /**
         * <p>
         * Timestamp segment
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestampSegment.Builder} avoiding the
         * need to create one manually via {@link TimestampSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestampSegment.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampSegment(TimestampSegment)}.
         * 
         * @param timestampSegment
         *        a consumer that will call methods on {@link TimestampSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampSegment(TimestampSegment)
         */
        default Builder timestampSegment(Consumer<TimestampSegment.Builder> timestampSegment) {
            return timestampSegment(TimestampSegment.builder().applyMutation(timestampSegment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimestampSegment timestampSegment;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSegmentConfiguration model) {
            timestampSegment(model.timestampSegment);
        }

        public final TimestampSegment.Builder getTimestampSegment() {
            return timestampSegment != null ? timestampSegment.toBuilder() : null;
        }

        public final void setTimestampSegment(TimestampSegment.BuilderImpl timestampSegment) {
            Object oldValue = this.timestampSegment;
            this.timestampSegment = timestampSegment != null ? timestampSegment.build() : null;
            handleUnionValueChange(Type.TIMESTAMP_SEGMENT, oldValue, this.timestampSegment);
        }

        @Override
        public final Builder timestampSegment(TimestampSegment timestampSegment) {
            Object oldValue = this.timestampSegment;
            this.timestampSegment = timestampSegment;
            handleUnionValueChange(Type.TIMESTAMP_SEGMENT, oldValue, this.timestampSegment);
            return this;
        }

        @Override
        public VideoSegmentConfiguration build() {
            return new VideoSegmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VideoSegmentConfiguration#type()
     */
    public enum Type {
        TIMESTAMP_SEGMENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
