/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DocumentFormat {
    PDF("pdf"),
    CSV("csv"),
    DOC("doc"),
    DOCX("docx"),
    XLS("xls"),
    XLSX("xlsx"),
    HTML("html"),
    TXT("txt"),
    MD("md"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DocumentFormat> VALUE_MAP;
    private final String value;

    private DocumentFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DocumentFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DocumentFormat> knownValues() {
        EnumSet<DocumentFormat> knownValues = EnumSet.allOf(DocumentFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DocumentFormat.class, DocumentFormat::toString);
    }
}

