/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyGuardrailRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<ApplyGuardrailRequest.Builder, ApplyGuardrailRequest> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailIdentifier").getter(getter(ApplyGuardrailRequest::guardrailIdentifier))
            .setter(setter(Builder::guardrailIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailIdentifier").build()).build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion").getter(getter(ApplyGuardrailRequest::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailVersion").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ApplyGuardrailRequest::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<List<GuardrailContentBlock>> CONTENT_FIELD = SdkField
            .<List<GuardrailContentBlock>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(ApplyGuardrailRequest::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailContentBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailContentBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD,
            GUARDRAIL_VERSION_FIELD, SOURCE_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
                    put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
                    put("source", SOURCE_FIELD);
                    put("content", CONTENT_FIELD);
                }
            });

    private final String guardrailIdentifier;

    private final String guardrailVersion;

    private final String source;

    private final List<GuardrailContentBlock> content;

    private ApplyGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.source = builder.source;
        this.content = builder.content;
    }

    /**
     * <p>
     * The guardrail identifier used in the request to apply the guardrail.
     * </p>
     * 
     * @return The guardrail identifier used in the request to apply the guardrail.
     */
    public final String guardrailIdentifier() {
        return guardrailIdentifier;
    }

    /**
     * <p>
     * The guardrail version used in the request to apply the guardrail.
     * </p>
     * 
     * @return The guardrail version used in the request to apply the guardrail.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    /**
     * <p>
     * The source of data used in the request to apply the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link GuardrailContentSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of data used in the request to apply the guardrail.
     * @see GuardrailContentSource
     */
    public final GuardrailContentSource source() {
        return GuardrailContentSource.fromValue(source);
    }

    /**
     * <p>
     * The source of data used in the request to apply the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link GuardrailContentSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of data used in the request to apply the guardrail.
     * @see GuardrailContentSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The content details used in the request to apply the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The content details used in the request to apply the guardrail.
     */
    public final List<GuardrailContentBlock> content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailRequest)) {
            return false;
        }
        ApplyGuardrailRequest other = (ApplyGuardrailRequest) obj;
        return Objects.equals(guardrailIdentifier(), other.guardrailIdentifier())
                && Objects.equals(guardrailVersion(), other.guardrailVersion())
                && Objects.equals(sourceAsString(), other.sourceAsString()) && hasContent() == other.hasContent()
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyGuardrailRequest").add("GuardrailIdentifier", guardrailIdentifier())
                .add("GuardrailVersion", guardrailVersion()).add("Source", sourceAsString())
                .add("Content", hasContent() ? content() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailIdentifier()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplyGuardrailRequest, T> g) {
        return obj -> g.apply((ApplyGuardrailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ApplyGuardrailRequest> {
        /**
         * <p>
         * The guardrail identifier used in the request to apply the guardrail.
         * </p>
         * 
         * @param guardrailIdentifier
         *        The guardrail identifier used in the request to apply the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailIdentifier(String guardrailIdentifier);

        /**
         * <p>
         * The guardrail version used in the request to apply the guardrail.
         * </p>
         * 
         * @param guardrailVersion
         *        The guardrail version used in the request to apply the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        /**
         * <p>
         * The source of data used in the request to apply the guardrail.
         * </p>
         * 
         * @param source
         *        The source of data used in the request to apply the guardrail.
         * @see GuardrailContentSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentSource
         */
        Builder source(String source);

        /**
         * <p>
         * The source of data used in the request to apply the guardrail.
         * </p>
         * 
         * @param source
         *        The source of data used in the request to apply the guardrail.
         * @see GuardrailContentSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentSource
         */
        Builder source(GuardrailContentSource source);

        /**
         * <p>
         * The content details used in the request to apply the guardrail.
         * </p>
         * 
         * @param content
         *        The content details used in the request to apply the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<GuardrailContentBlock> content);

        /**
         * <p>
         * The content details used in the request to apply the guardrail.
         * </p>
         * 
         * @param content
         *        The content details used in the request to apply the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(GuardrailContentBlock... content);

        /**
         * <p>
         * The content details used in the request to apply the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlock.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #content(List<GuardrailContentBlock>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<GuardrailContentBlock>)
         */
        Builder content(Consumer<GuardrailContentBlock.Builder>... content);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private String guardrailIdentifier;

        private String guardrailVersion;

        private String source;

        private List<GuardrailContentBlock> content = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyGuardrailRequest model) {
            super(model);
            guardrailIdentifier(model.guardrailIdentifier);
            guardrailVersion(model.guardrailVersion);
            source(model.source);
            content(model.content);
        }

        public final String getGuardrailIdentifier() {
            return guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(GuardrailContentSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final List<GuardrailContentBlock.Builder> getContent() {
            List<GuardrailContentBlock.Builder> result = GuardrailContentBlockListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<GuardrailContentBlock.BuilderImpl> content) {
            this.content = GuardrailContentBlockListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<GuardrailContentBlock> content) {
            this.content = GuardrailContentBlockListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(GuardrailContentBlock... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<GuardrailContentBlock.Builder>... content) {
            content(Stream.of(content).map(c -> GuardrailContentBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplyGuardrailRequest build() {
            return new ApplyGuardrailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
