/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from a call to <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConverseOutput implements SdkPojo, Serializable, ToCopyableBuilder<ConverseOutput.Builder, ConverseOutput> {
    private static final SdkField<Message> MESSAGE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("message").getter(getter(ConverseOutput::message)).setter(setter(Builder::message))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("message", MESSAGE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Message message;

    private final Type type;

    private ConverseOutput(BuilderImpl builder) {
        this.message = builder.message;
        this.type = builder.type;
    }

    /**
     * <p>
     * The message that the model generates.
     * </p>
     * 
     * @return The message that the model generates.
     */
    public final Message message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseOutput)) {
            return false;
        }
        ConverseOutput other = (ConverseOutput) obj;
        return Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConverseOutput").add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #message()} initialized to the given value.
     *
     * <p>
     * The message that the model generates.
     * </p>
     * 
     * @param message
     *        The message that the model generates.
     */
    public static ConverseOutput fromMessage(Message message) {
        return builder().message(message).build();
    }

    /**
     * Create an instance of this class with {@link #message()} initialized to the given value.
     *
     * <p>
     * The message that the model generates.
     * </p>
     * 
     * @param message
     *        The message that the model generates.
     */
    public static ConverseOutput fromMessage(Consumer<Message.Builder> message) {
        Message.Builder builder = Message.builder();
        message.accept(builder);
        return fromMessage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConverseOutput, T> g) {
        return obj -> g.apply((ConverseOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConverseOutput> {
        /**
         * <p>
         * The message that the model generates.
         * </p>
         * 
         * @param message
         *        The message that the model generates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(Message message);

        /**
         * <p>
         * The message that the model generates.
         * </p>
         * This is a convenience method that creates an instance of the {@link Message.Builder} avoiding the need to
         * create one manually via {@link Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #message(Message)}.
         * 
         * @param message
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #message(Message)
         */
        default Builder message(Consumer<Message.Builder> message) {
            return message(Message.builder().applyMutation(message).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Message message;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseOutput model) {
            message(model.message);
        }

        public final Message.Builder getMessage() {
            return message != null ? message.toBuilder() : null;
        }

        public final void setMessage(Message.BuilderImpl message) {
            Object oldValue = this.message;
            this.message = message != null ? message.build() : null;
            handleUnionValueChange(Type.MESSAGE, oldValue, this.message);
        }

        @Override
        public final Builder message(Message message) {
            Object oldValue = this.message;
            this.message = message;
            handleUnionValueChange(Type.MESSAGE, oldValue, this.message);
            return this;
        }

        @Override
        public ConverseOutput build() {
            return new ConverseOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConverseOutput#type()
     */
    public enum Type {
        MESSAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
