/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConverseResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<ConverseResponse.Builder, ConverseResponse> {
    private static final SdkField<ConverseOutput> OUTPUT_FIELD = SdkField.<ConverseOutput> builder(MarshallingType.SDK_POJO)
            .memberName("output").getter(getter(ConverseResponse::output)).setter(setter(Builder::output))
            .constructor(ConverseOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<String> STOP_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stopReason").getter(getter(ConverseResponse::stopReasonAsString)).setter(setter(Builder::stopReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopReason").build()).build();

    private static final SdkField<TokenUsage> USAGE_FIELD = SdkField.<TokenUsage> builder(MarshallingType.SDK_POJO)
            .memberName("usage").getter(getter(ConverseResponse::usage)).setter(setter(Builder::usage))
            .constructor(TokenUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final SdkField<ConverseMetrics> METRICS_FIELD = SdkField.<ConverseMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("metrics").getter(getter(ConverseResponse::metrics)).setter(setter(Builder::metrics))
            .constructor(ConverseMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()).build();

    private static final SdkField<Document> ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("additionalModelResponseFields")
            .getter(getter(ConverseResponse::additionalModelResponseFields))
            .setter(setter(Builder::additionalModelResponseFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFields")
                    .build()).build();

    private static final SdkField<ConverseTrace> TRACE_FIELD = SdkField.<ConverseTrace> builder(MarshallingType.SDK_POJO)
            .memberName("trace").getter(getter(ConverseResponse::trace)).setter(setter(Builder::trace))
            .constructor(ConverseTrace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD,
            STOP_REASON_FIELD, USAGE_FIELD, METRICS_FIELD, ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD, TRACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("output", OUTPUT_FIELD);
                    put("stopReason", STOP_REASON_FIELD);
                    put("usage", USAGE_FIELD);
                    put("metrics", METRICS_FIELD);
                    put("additionalModelResponseFields", ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD);
                    put("trace", TRACE_FIELD);
                }
            });

    private final ConverseOutput output;

    private final String stopReason;

    private final TokenUsage usage;

    private final ConverseMetrics metrics;

    private final Document additionalModelResponseFields;

    private final ConverseTrace trace;

    private ConverseResponse(BuilderImpl builder) {
        super(builder);
        this.output = builder.output;
        this.stopReason = builder.stopReason;
        this.usage = builder.usage;
        this.metrics = builder.metrics;
        this.additionalModelResponseFields = builder.additionalModelResponseFields;
        this.trace = builder.trace;
    }

    /**
     * <p>
     * The result from the call to <code>Converse</code>.
     * </p>
     * 
     * @return The result from the call to <code>Converse</code>.
     */
    public final ConverseOutput output() {
        return output;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopReason} will
     * return {@link StopReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopReasonAsString}.
     * </p>
     * 
     * @return The reason why the model stopped generating output.
     * @see StopReason
     */
    public final StopReason stopReason() {
        return StopReason.fromValue(stopReason);
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopReason} will
     * return {@link StopReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopReasonAsString}.
     * </p>
     * 
     * @return The reason why the model stopped generating output.
     * @see StopReason
     */
    public final String stopReasonAsString() {
        return stopReason;
    }

    /**
     * <p>
     * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to the
     * model and the tokens generated by the model.
     * </p>
     * 
     * @return The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input
     *         to the model and the tokens generated by the model.
     */
    public final TokenUsage usage() {
        return usage;
    }

    /**
     * <p>
     * Metrics for the call to <code>Converse</code>.
     * </p>
     * 
     * @return Metrics for the call to <code>Converse</code>.
     */
    public final ConverseMetrics metrics() {
        return metrics;
    }

    /**
     * <p>
     * Additional fields in the response that are unique to the model.
     * </p>
     * 
     * @return Additional fields in the response that are unique to the model.
     */
    public final Document additionalModelResponseFields() {
        return additionalModelResponseFields;
    }

    /**
     * <p>
     * A trace object that contains information about the Guardrail behavior.
     * </p>
     * 
     * @return A trace object that contains information about the Guardrail behavior.
     */
    public final ConverseTrace trace() {
        return trace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(stopReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(additionalModelResponseFields());
        hashCode = 31 * hashCode + Objects.hashCode(trace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseResponse)) {
            return false;
        }
        ConverseResponse other = (ConverseResponse) obj;
        return Objects.equals(output(), other.output()) && Objects.equals(stopReasonAsString(), other.stopReasonAsString())
                && Objects.equals(usage(), other.usage()) && Objects.equals(metrics(), other.metrics())
                && Objects.equals(additionalModelResponseFields(), other.additionalModelResponseFields())
                && Objects.equals(trace(), other.trace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConverseResponse").add("Output", output()).add("StopReason", stopReasonAsString())
                .add("Usage", usage()).add("Metrics", metrics())
                .add("AdditionalModelResponseFields", additionalModelResponseFields()).add("Trace", trace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "stopReason":
            return Optional.ofNullable(clazz.cast(stopReasonAsString()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "additionalModelResponseFields":
            return Optional.ofNullable(clazz.cast(additionalModelResponseFields()));
        case "trace":
            return Optional.ofNullable(clazz.cast(trace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConverseResponse, T> g) {
        return obj -> g.apply((ConverseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ConverseResponse> {
        /**
         * <p>
         * The result from the call to <code>Converse</code>.
         * </p>
         * 
         * @param output
         *        The result from the call to <code>Converse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(ConverseOutput output);

        /**
         * <p>
         * The result from the call to <code>Converse</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseOutput.Builder} avoiding the need
         * to create one manually via {@link ConverseOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #output(ConverseOutput)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link ConverseOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(ConverseOutput)
         */
        default Builder output(Consumer<ConverseOutput.Builder> output) {
            return output(ConverseOutput.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * The reason why the model stopped generating output.
         * </p>
         * 
         * @param stopReason
         *        The reason why the model stopped generating output.
         * @see StopReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopReason
         */
        Builder stopReason(String stopReason);

        /**
         * <p>
         * The reason why the model stopped generating output.
         * </p>
         * 
         * @param stopReason
         *        The reason why the model stopped generating output.
         * @see StopReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopReason
         */
        Builder stopReason(StopReason stopReason);

        /**
         * <p>
         * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to
         * the model and the tokens generated by the model.
         * </p>
         * 
         * @param usage
         *        The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens
         *        input to the model and the tokens generated by the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(TokenUsage usage);

        /**
         * <p>
         * The total number of tokens used in the call to <code>Converse</code>. The total includes the tokens input to
         * the model and the tokens generated by the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenUsage.Builder} avoiding the need to
         * create one manually via {@link TokenUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenUsage.Builder#build()} is called immediately and its result
         * is passed to {@link #usage(TokenUsage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link TokenUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(TokenUsage)
         */
        default Builder usage(Consumer<TokenUsage.Builder> usage) {
            return usage(TokenUsage.builder().applyMutation(usage).build());
        }

        /**
         * <p>
         * Metrics for the call to <code>Converse</code>.
         * </p>
         * 
         * @param metrics
         *        Metrics for the call to <code>Converse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(ConverseMetrics metrics);

        /**
         * <p>
         * Metrics for the call to <code>Converse</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseMetrics.Builder} avoiding the
         * need to create one manually via {@link ConverseMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #metrics(ConverseMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link ConverseMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(ConverseMetrics)
         */
        default Builder metrics(Consumer<ConverseMetrics.Builder> metrics) {
            return metrics(ConverseMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * <p>
         * Additional fields in the response that are unique to the model.
         * </p>
         * 
         * @param additionalModelResponseFields
         *        Additional fields in the response that are unique to the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelResponseFields(Document additionalModelResponseFields);

        /**
         * <p>
         * A trace object that contains information about the Guardrail behavior.
         * </p>
         * 
         * @param trace
         *        A trace object that contains information about the Guardrail behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trace(ConverseTrace trace);

        /**
         * <p>
         * A trace object that contains information about the Guardrail behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConverseTrace.Builder} avoiding the need
         * to create one manually via {@link ConverseTrace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConverseTrace.Builder#build()} is called immediately and its
         * result is passed to {@link #trace(ConverseTrace)}.
         * 
         * @param trace
         *        a consumer that will call methods on {@link ConverseTrace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trace(ConverseTrace)
         */
        default Builder trace(Consumer<ConverseTrace.Builder> trace) {
            return trace(ConverseTrace.builder().applyMutation(trace).build());
        }
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private ConverseOutput output;

        private String stopReason;

        private TokenUsage usage;

        private ConverseMetrics metrics;

        private Document additionalModelResponseFields;

        private ConverseTrace trace;

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseResponse model) {
            super(model);
            output(model.output);
            stopReason(model.stopReason);
            usage(model.usage);
            metrics(model.metrics);
            additionalModelResponseFields(model.additionalModelResponseFields);
            trace(model.trace);
        }

        public final ConverseOutput.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(ConverseOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(ConverseOutput output) {
            this.output = output;
            return this;
        }

        public final String getStopReason() {
            return stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        @Override
        public final Builder stopReason(StopReason stopReason) {
            this.stopReason(stopReason == null ? null : stopReason.toString());
            return this;
        }

        public final TokenUsage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(TokenUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(TokenUsage usage) {
            this.usage = usage;
            return this;
        }

        public final ConverseMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(ConverseMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(ConverseMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final Document getAdditionalModelResponseFields() {
            return additionalModelResponseFields;
        }

        public final void setAdditionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
        }

        @Override
        public final Builder additionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
            return this;
        }

        public final ConverseTrace.Builder getTrace() {
            return trace != null ? trace.toBuilder() : null;
        }

        public final void setTrace(ConverseTrace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(ConverseTrace trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public ConverseResponse build() {
            return new ConverseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
