/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details on the use of the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailUsage implements SdkPojo, Serializable, ToCopyableBuilder<GuardrailUsage.Builder, GuardrailUsage> {
    private static final SdkField<Integer> TOPIC_POLICY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("topicPolicyUnits").getter(getter(GuardrailUsage::topicPolicyUnits))
            .setter(setter(Builder::topicPolicyUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyUnits").build()).build();

    private static final SdkField<Integer> CONTENT_POLICY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("contentPolicyUnits").getter(getter(GuardrailUsage::contentPolicyUnits))
            .setter(setter(Builder::contentPolicyUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyUnits").build())
            .build();

    private static final SdkField<Integer> WORD_POLICY_UNITS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("wordPolicyUnits").getter(getter(GuardrailUsage::wordPolicyUnits))
            .setter(setter(Builder::wordPolicyUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyUnits").build()).build();

    private static final SdkField<Integer> SENSITIVE_INFORMATION_POLICY_UNITS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("sensitiveInformationPolicyUnits")
            .getter(getter(GuardrailUsage::sensitiveInformationPolicyUnits))
            .setter(setter(Builder::sensitiveInformationPolicyUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyUnits")
                    .build()).build();

    private static final SdkField<Integer> SENSITIVE_INFORMATION_POLICY_FREE_UNITS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("sensitiveInformationPolicyFreeUnits")
            .getter(getter(GuardrailUsage::sensitiveInformationPolicyFreeUnits))
            .setter(setter(Builder::sensitiveInformationPolicyFreeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("sensitiveInformationPolicyFreeUnits").build()).build();

    private static final SdkField<Integer> CONTEXTUAL_GROUNDING_POLICY_UNITS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("contextualGroundingPolicyUnits")
            .getter(getter(GuardrailUsage::contextualGroundingPolicyUnits))
            .setter(setter(Builder::contextualGroundingPolicyUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyUnits")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_POLICY_UNITS_FIELD,
            CONTENT_POLICY_UNITS_FIELD, WORD_POLICY_UNITS_FIELD, SENSITIVE_INFORMATION_POLICY_UNITS_FIELD,
            SENSITIVE_INFORMATION_POLICY_FREE_UNITS_FIELD, CONTEXTUAL_GROUNDING_POLICY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("topicPolicyUnits", TOPIC_POLICY_UNITS_FIELD);
                    put("contentPolicyUnits", CONTENT_POLICY_UNITS_FIELD);
                    put("wordPolicyUnits", WORD_POLICY_UNITS_FIELD);
                    put("sensitiveInformationPolicyUnits", SENSITIVE_INFORMATION_POLICY_UNITS_FIELD);
                    put("sensitiveInformationPolicyFreeUnits", SENSITIVE_INFORMATION_POLICY_FREE_UNITS_FIELD);
                    put("contextualGroundingPolicyUnits", CONTEXTUAL_GROUNDING_POLICY_UNITS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer topicPolicyUnits;

    private final Integer contentPolicyUnits;

    private final Integer wordPolicyUnits;

    private final Integer sensitiveInformationPolicyUnits;

    private final Integer sensitiveInformationPolicyFreeUnits;

    private final Integer contextualGroundingPolicyUnits;

    private GuardrailUsage(BuilderImpl builder) {
        this.topicPolicyUnits = builder.topicPolicyUnits;
        this.contentPolicyUnits = builder.contentPolicyUnits;
        this.wordPolicyUnits = builder.wordPolicyUnits;
        this.sensitiveInformationPolicyUnits = builder.sensitiveInformationPolicyUnits;
        this.sensitiveInformationPolicyFreeUnits = builder.sensitiveInformationPolicyFreeUnits;
        this.contextualGroundingPolicyUnits = builder.contextualGroundingPolicyUnits;
    }

    /**
     * <p>
     * The topic policy units processed by the guardrail.
     * </p>
     * 
     * @return The topic policy units processed by the guardrail.
     */
    public final Integer topicPolicyUnits() {
        return topicPolicyUnits;
    }

    /**
     * <p>
     * The content policy units processed by the guardrail.
     * </p>
     * 
     * @return The content policy units processed by the guardrail.
     */
    public final Integer contentPolicyUnits() {
        return contentPolicyUnits;
    }

    /**
     * <p>
     * The word policy units processed by the guardrail.
     * </p>
     * 
     * @return The word policy units processed by the guardrail.
     */
    public final Integer wordPolicyUnits() {
        return wordPolicyUnits;
    }

    /**
     * <p>
     * The sensitive information policy units processed by the guardrail.
     * </p>
     * 
     * @return The sensitive information policy units processed by the guardrail.
     */
    public final Integer sensitiveInformationPolicyUnits() {
        return sensitiveInformationPolicyUnits;
    }

    /**
     * <p>
     * The sensitive information policy free units processed by the guardrail.
     * </p>
     * 
     * @return The sensitive information policy free units processed by the guardrail.
     */
    public final Integer sensitiveInformationPolicyFreeUnits() {
        return sensitiveInformationPolicyFreeUnits;
    }

    /**
     * <p>
     * The contextual grounding policy units processed by the guardrail.
     * </p>
     * 
     * @return The contextual grounding policy units processed by the guardrail.
     */
    public final Integer contextualGroundingPolicyUnits() {
        return contextualGroundingPolicyUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicyUnits());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicyUnits());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicyUnits());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicyUnits());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicyFreeUnits());
        hashCode = 31 * hashCode + Objects.hashCode(contextualGroundingPolicyUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailUsage)) {
            return false;
        }
        GuardrailUsage other = (GuardrailUsage) obj;
        return Objects.equals(topicPolicyUnits(), other.topicPolicyUnits())
                && Objects.equals(contentPolicyUnits(), other.contentPolicyUnits())
                && Objects.equals(wordPolicyUnits(), other.wordPolicyUnits())
                && Objects.equals(sensitiveInformationPolicyUnits(), other.sensitiveInformationPolicyUnits())
                && Objects.equals(sensitiveInformationPolicyFreeUnits(), other.sensitiveInformationPolicyFreeUnits())
                && Objects.equals(contextualGroundingPolicyUnits(), other.contextualGroundingPolicyUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailUsage").add("TopicPolicyUnits", topicPolicyUnits())
                .add("ContentPolicyUnits", contentPolicyUnits()).add("WordPolicyUnits", wordPolicyUnits())
                .add("SensitiveInformationPolicyUnits", sensitiveInformationPolicyUnits())
                .add("SensitiveInformationPolicyFreeUnits", sensitiveInformationPolicyFreeUnits())
                .add("ContextualGroundingPolicyUnits", contextualGroundingPolicyUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicPolicyUnits":
            return Optional.ofNullable(clazz.cast(topicPolicyUnits()));
        case "contentPolicyUnits":
            return Optional.ofNullable(clazz.cast(contentPolicyUnits()));
        case "wordPolicyUnits":
            return Optional.ofNullable(clazz.cast(wordPolicyUnits()));
        case "sensitiveInformationPolicyUnits":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicyUnits()));
        case "sensitiveInformationPolicyFreeUnits":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicyFreeUnits()));
        case "contextualGroundingPolicyUnits":
            return Optional.ofNullable(clazz.cast(contextualGroundingPolicyUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailUsage, T> g) {
        return obj -> g.apply((GuardrailUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailUsage> {
        /**
         * <p>
         * The topic policy units processed by the guardrail.
         * </p>
         * 
         * @param topicPolicyUnits
         *        The topic policy units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicyUnits(Integer topicPolicyUnits);

        /**
         * <p>
         * The content policy units processed by the guardrail.
         * </p>
         * 
         * @param contentPolicyUnits
         *        The content policy units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicyUnits(Integer contentPolicyUnits);

        /**
         * <p>
         * The word policy units processed by the guardrail.
         * </p>
         * 
         * @param wordPolicyUnits
         *        The word policy units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicyUnits(Integer wordPolicyUnits);

        /**
         * <p>
         * The sensitive information policy units processed by the guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicyUnits
         *        The sensitive information policy units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicyUnits(Integer sensitiveInformationPolicyUnits);

        /**
         * <p>
         * The sensitive information policy free units processed by the guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicyFreeUnits
         *        The sensitive information policy free units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicyFreeUnits(Integer sensitiveInformationPolicyFreeUnits);

        /**
         * <p>
         * The contextual grounding policy units processed by the guardrail.
         * </p>
         * 
         * @param contextualGroundingPolicyUnits
         *        The contextual grounding policy units processed by the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualGroundingPolicyUnits(Integer contextualGroundingPolicyUnits);
    }

    static final class BuilderImpl implements Builder {
        private Integer topicPolicyUnits;

        private Integer contentPolicyUnits;

        private Integer wordPolicyUnits;

        private Integer sensitiveInformationPolicyUnits;

        private Integer sensitiveInformationPolicyFreeUnits;

        private Integer contextualGroundingPolicyUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailUsage model) {
            topicPolicyUnits(model.topicPolicyUnits);
            contentPolicyUnits(model.contentPolicyUnits);
            wordPolicyUnits(model.wordPolicyUnits);
            sensitiveInformationPolicyUnits(model.sensitiveInformationPolicyUnits);
            sensitiveInformationPolicyFreeUnits(model.sensitiveInformationPolicyFreeUnits);
            contextualGroundingPolicyUnits(model.contextualGroundingPolicyUnits);
        }

        public final Integer getTopicPolicyUnits() {
            return topicPolicyUnits;
        }

        public final void setTopicPolicyUnits(Integer topicPolicyUnits) {
            this.topicPolicyUnits = topicPolicyUnits;
        }

        @Override
        public final Builder topicPolicyUnits(Integer topicPolicyUnits) {
            this.topicPolicyUnits = topicPolicyUnits;
            return this;
        }

        public final Integer getContentPolicyUnits() {
            return contentPolicyUnits;
        }

        public final void setContentPolicyUnits(Integer contentPolicyUnits) {
            this.contentPolicyUnits = contentPolicyUnits;
        }

        @Override
        public final Builder contentPolicyUnits(Integer contentPolicyUnits) {
            this.contentPolicyUnits = contentPolicyUnits;
            return this;
        }

        public final Integer getWordPolicyUnits() {
            return wordPolicyUnits;
        }

        public final void setWordPolicyUnits(Integer wordPolicyUnits) {
            this.wordPolicyUnits = wordPolicyUnits;
        }

        @Override
        public final Builder wordPolicyUnits(Integer wordPolicyUnits) {
            this.wordPolicyUnits = wordPolicyUnits;
            return this;
        }

        public final Integer getSensitiveInformationPolicyUnits() {
            return sensitiveInformationPolicyUnits;
        }

        public final void setSensitiveInformationPolicyUnits(Integer sensitiveInformationPolicyUnits) {
            this.sensitiveInformationPolicyUnits = sensitiveInformationPolicyUnits;
        }

        @Override
        public final Builder sensitiveInformationPolicyUnits(Integer sensitiveInformationPolicyUnits) {
            this.sensitiveInformationPolicyUnits = sensitiveInformationPolicyUnits;
            return this;
        }

        public final Integer getSensitiveInformationPolicyFreeUnits() {
            return sensitiveInformationPolicyFreeUnits;
        }

        public final void setSensitiveInformationPolicyFreeUnits(Integer sensitiveInformationPolicyFreeUnits) {
            this.sensitiveInformationPolicyFreeUnits = sensitiveInformationPolicyFreeUnits;
        }

        @Override
        public final Builder sensitiveInformationPolicyFreeUnits(Integer sensitiveInformationPolicyFreeUnits) {
            this.sensitiveInformationPolicyFreeUnits = sensitiveInformationPolicyFreeUnits;
            return this;
        }

        public final Integer getContextualGroundingPolicyUnits() {
            return contextualGroundingPolicyUnits;
        }

        public final void setContextualGroundingPolicyUnits(Integer contextualGroundingPolicyUnits) {
            this.contextualGroundingPolicyUnits = contextualGroundingPolicyUnits;
        }

        @Override
        public final Builder contextualGroundingPolicyUnits(Integer contextualGroundingPolicyUnits) {
            this.contextualGroundingPolicyUnits = contextualGroundingPolicyUnits;
            return this;
        }

        @Override
        public GuardrailUsage build() {
            return new GuardrailUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
