/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The word policy assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailWordPolicyAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailWordPolicyAssessment.Builder, GuardrailWordPolicyAssessment> {
    private static final SdkField<List<GuardrailCustomWord>> CUSTOM_WORDS_FIELD = SdkField
            .<List<GuardrailCustomWord>> builder(MarshallingType.LIST)
            .memberName("customWords")
            .getter(getter(GuardrailWordPolicyAssessment::customWords))
            .setter(setter(Builder::customWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailCustomWord> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailCustomWord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailManagedWord>> MANAGED_WORD_LISTS_FIELD = SdkField
            .<List<GuardrailManagedWord>> builder(MarshallingType.LIST)
            .memberName("managedWordLists")
            .getter(getter(GuardrailWordPolicyAssessment::managedWordLists))
            .setter(setter(Builder::managedWordLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWordLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailManagedWord> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailManagedWord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_WORDS_FIELD,
            MANAGED_WORD_LISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("customWords", CUSTOM_WORDS_FIELD);
                    put("managedWordLists", MANAGED_WORD_LISTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<GuardrailCustomWord> customWords;

    private final List<GuardrailManagedWord> managedWordLists;

    private GuardrailWordPolicyAssessment(BuilderImpl builder) {
        this.customWords = builder.customWords;
        this.managedWordLists = builder.managedWordLists;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomWords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomWords() {
        return customWords != null && !(customWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom words in the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomWords} method.
     * </p>
     * 
     * @return Custom words in the assessment.
     */
    public final List<GuardrailCustomWord> customWords() {
        return customWords;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedWordLists property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedWordLists() {
        return managedWordLists != null && !(managedWordLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Managed word lists in the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedWordLists} method.
     * </p>
     * 
     * @return Managed word lists in the assessment.
     */
    public final List<GuardrailManagedWord> managedWordLists() {
        return managedWordLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomWords() ? customWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedWordLists() ? managedWordLists() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordPolicyAssessment)) {
            return false;
        }
        GuardrailWordPolicyAssessment other = (GuardrailWordPolicyAssessment) obj;
        return hasCustomWords() == other.hasCustomWords() && Objects.equals(customWords(), other.customWords())
                && hasManagedWordLists() == other.hasManagedWordLists()
                && Objects.equals(managedWordLists(), other.managedWordLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailWordPolicyAssessment").add("CustomWords", hasCustomWords() ? customWords() : null)
                .add("ManagedWordLists", hasManagedWordLists() ? managedWordLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customWords":
            return Optional.ofNullable(clazz.cast(customWords()));
        case "managedWordLists":
            return Optional.ofNullable(clazz.cast(managedWordLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailWordPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailWordPolicyAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailWordPolicyAssessment> {
        /**
         * <p>
         * Custom words in the assessment.
         * </p>
         * 
         * @param customWords
         *        Custom words in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customWords(Collection<GuardrailCustomWord> customWords);

        /**
         * <p>
         * Custom words in the assessment.
         * </p>
         * 
         * @param customWords
         *        Custom words in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customWords(GuardrailCustomWord... customWords);

        /**
         * <p>
         * Custom words in the assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWord.Builder#build()} is called
         * immediately and its result is passed to {@link #customWords(List<GuardrailCustomWord>)}.
         * 
         * @param customWords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customWords(java.util.Collection<GuardrailCustomWord>)
         */
        Builder customWords(Consumer<GuardrailCustomWord.Builder>... customWords);

        /**
         * <p>
         * Managed word lists in the assessment.
         * </p>
         * 
         * @param managedWordLists
         *        Managed word lists in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordLists(Collection<GuardrailManagedWord> managedWordLists);

        /**
         * <p>
         * Managed word lists in the assessment.
         * </p>
         * 
         * @param managedWordLists
         *        Managed word lists in the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordLists(GuardrailManagedWord... managedWordLists);

        /**
         * <p>
         * Managed word lists in the assessment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWord.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWord.Builder#build()} is called
         * immediately and its result is passed to {@link #managedWordLists(List<GuardrailManagedWord>)}.
         * 
         * @param managedWordLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedWordLists(java.util.Collection<GuardrailManagedWord>)
         */
        Builder managedWordLists(Consumer<GuardrailManagedWord.Builder>... managedWordLists);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailCustomWord> customWords = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailManagedWord> managedWordLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailWordPolicyAssessment model) {
            customWords(model.customWords);
            managedWordLists(model.managedWordLists);
        }

        public final List<GuardrailCustomWord.Builder> getCustomWords() {
            List<GuardrailCustomWord.Builder> result = GuardrailCustomWordListCopier.copyToBuilder(this.customWords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomWords(Collection<GuardrailCustomWord.BuilderImpl> customWords) {
            this.customWords = GuardrailCustomWordListCopier.copyFromBuilder(customWords);
        }

        @Override
        public final Builder customWords(Collection<GuardrailCustomWord> customWords) {
            this.customWords = GuardrailCustomWordListCopier.copy(customWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customWords(GuardrailCustomWord... customWords) {
            customWords(Arrays.asList(customWords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customWords(Consumer<GuardrailCustomWord.Builder>... customWords) {
            customWords(Stream.of(customWords).map(c -> GuardrailCustomWord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailManagedWord.Builder> getManagedWordLists() {
            List<GuardrailManagedWord.Builder> result = GuardrailManagedWordListCopier.copyToBuilder(this.managedWordLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedWordLists(Collection<GuardrailManagedWord.BuilderImpl> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListCopier.copyFromBuilder(managedWordLists);
        }

        @Override
        public final Builder managedWordLists(Collection<GuardrailManagedWord> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListCopier.copy(managedWordLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(GuardrailManagedWord... managedWordLists) {
            managedWordLists(Arrays.asList(managedWordLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(Consumer<GuardrailManagedWord.Builder>... managedWordLists) {
            managedWordLists(Stream.of(managedWordLists).map(c -> GuardrailManagedWord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailWordPolicyAssessment build() {
            return new GuardrailWordPolicyAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
