/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeModelWithResponseStreamRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<InvokeModelWithResponseStreamRequest.Builder, InvokeModelWithResponseStreamRequest> {
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body")
            .getter(getter(InvokeModelWithResponseStreamRequest::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(InvokeModelWithResponseStreamRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(InvokeModelWithResponseStreamRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Accept").build())
            .build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(InvokeModelWithResponseStreamRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()).build();

    private static final SdkField<String> TRACE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("trace")
            .getter(getter(InvokeModelWithResponseStreamRequest::traceAsString)).setter(setter(Builder::trace))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Trace").build())
            .build();

    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("guardrailIdentifier")
            .getter(getter(InvokeModelWithResponseStreamRequest::guardrailIdentifier))
            .setter(setter(Builder::guardrailIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-GuardrailIdentifier")
                    .build()).build();

    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("guardrailVersion")
            .getter(getter(InvokeModelWithResponseStreamRequest::guardrailVersion))
            .setter(setter(Builder::guardrailVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-GuardrailVersion")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD,
            CONTENT_TYPE_FIELD, ACCEPT_FIELD, MODEL_ID_FIELD, TRACE_FIELD, GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("body", BODY_FIELD);
                    put("Content-Type", CONTENT_TYPE_FIELD);
                    put("X-Amzn-Bedrock-Accept", ACCEPT_FIELD);
                    put("modelId", MODEL_ID_FIELD);
                    put("X-Amzn-Bedrock-Trace", TRACE_FIELD);
                    put("X-Amzn-Bedrock-GuardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
                    put("X-Amzn-Bedrock-GuardrailVersion", GUARDRAIL_VERSION_FIELD);
                }
            });

    private final SdkBytes body;

    private final String contentType;

    private final String accept;

    private final String modelId;

    private final String trace;

    private final String guardrailIdentifier;

    private final String guardrailVersion;

    private InvokeModelWithResponseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.modelId = builder.modelId;
        this.trace = builder.trace;
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
    }

    /**
     * <p>
     * The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You
     * must provide the body in JSON format. To see the format and content of the request and response bodies for
     * different models, refer to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For
     * more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run
     * inference</a> in the Bedrock User Guide.
     * </p>
     * 
     * @return The prompt and inference parameters in the format specified in the <code>contentType</code> in the
     *         header. You must provide the body in JSON format. To see the format and content of the request and
     *         response bodies for different models, refer to <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference
     *         parameters</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the
     *         Bedrock User Guide.
     */
    public final SdkBytes body() {
        return body;
    }

    /**
     * <p>
     * The MIME type of the input data in the request. You must specify <code>application/json</code>.
     * </p>
     * 
     * @return The MIME type of the input data in the request. You must specify <code>application/json</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.
     * </p>
     * 
     * @return The desired MIME type of the inference body in the response. The default value is
     *         <code>application/json</code>.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * The unique identifier of the model to invoke to run inference.
     * </p>
     * <p>
     * The <code>modelId</code> to provide depends on the type of model that you use:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
     * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned
     * Throughput</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the resulting
     * provisioned model. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in
     * Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you use an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
     * model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html"
     * >CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier of the model to invoke to run inference.</p>
     *         <p>
     *         The <code>modelId</code> to provide depends on the type of model that you use:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock
     *         base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
     *         Provisioned Throughput</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
     *         resulting provisioned model. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
     *         model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you use an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
     *         >imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful
     *         call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">
     *         CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
     *         </p>
     *         </li>
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link Trace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
     * @see Trace
     */
    public final Trace trace() {
        return Trace.fromValue(trace);
    }

    /**
     * <p>
     * Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trace} will return
     * {@link Trace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceAsString}.
     * </p>
     * 
     * @return Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
     * @see Trace
     */
    public final String traceAsString() {
        return trace;
    }

    /**
     * <p>
     * The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is
     * applied to the invocation.
     * </p>
     * <p>
     * An error is thrown in the following situations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in
     * the request body.
     * </p>
     * </li>
     * <li>
     * <p>
     * You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail
     *         is applied to the invocation.</p>
     *         <p>
     *         An error is thrown in the following situations.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code>
     *         field in the request body.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.
     *         </p>
     *         </li>
     */
    public final String guardrailIdentifier() {
        return guardrailIdentifier;
    }

    /**
     * <p>
     * The version number for the guardrail. The value can also be <code>DRAFT</code>.
     * </p>
     * 
     * @return The version number for the guardrail. The value can also be <code>DRAFT</code>.
     */
    public final String guardrailVersion() {
        return guardrailVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(traceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamRequest)) {
            return false;
        }
        InvokeModelWithResponseStreamRequest other = (InvokeModelWithResponseStreamRequest) obj;
        return Objects.equals(body(), other.body()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(accept(), other.accept()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(traceAsString(), other.traceAsString())
                && Objects.equals(guardrailIdentifier(), other.guardrailIdentifier())
                && Objects.equals(guardrailVersion(), other.guardrailVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeModelWithResponseStreamRequest")
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("ContentType", contentType())
                .add("Accept", accept()).add("ModelId", modelId()).add("Trace", traceAsString())
                .add("GuardrailIdentifier", guardrailIdentifier()).add("GuardrailVersion", guardrailVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "trace":
            return Optional.ofNullable(clazz.cast(traceAsString()));
        case "guardrailIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailIdentifier()));
        case "guardrailVersion":
            return Optional.ofNullable(clazz.cast(guardrailVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamRequest, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeModelWithResponseStreamRequest> {
        /**
         * <p>
         * The prompt and inference parameters in the format specified in the <code>contentType</code> in the header.
         * You must provide the body in JSON format. To see the format and content of the request and response bodies
         * for different models, refer to <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the
         * Bedrock User Guide.
         * </p>
         * 
         * @param body
         *        The prompt and inference parameters in the format specified in the <code>contentType</code> in the
         *        header. You must provide the body in JSON format. To see the format and content of the request and
         *        response bodies for different models, refer to <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference
         *        parameters</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in
         *        the Bedrock User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        /**
         * <p>
         * The MIME type of the input data in the request. You must specify <code>application/json</code>.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the input data in the request. You must specify <code>application/json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The desired MIME type of the inference body in the response. The default value is
         * <code>application/json</code>.
         * </p>
         * 
         * @param accept
         *        The desired MIME type of the inference body in the response. The default value is
         *        <code>application/json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * The unique identifier of the model to invoke to run inference.
         * </p>
         * <p>
         * The <code>modelId</code> to provide depends on the type of model that you use:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base
         * model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a
         * Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         * resulting provisioned model. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model
         * in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you use an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported
         * model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a
         * href=
         * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob
         * </a> or from the Imported models page in the Amazon Bedrock console.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelId
         *        The unique identifier of the model to invoke to run inference.</p>
         *        <p>
         *        The <code>modelId</code> to provide depends on the type of model that you use:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon
         *        Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information,
         *        see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference
         *        using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use a custom model, first purchase Provisioned Throughput for it. Then specify the ARN of the
         *        resulting provisioned model. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom
         *        model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you use an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html"
         *        >imported model</a>, specify the ARN of the imported model. You can get the model ARN from a
         *        successful call to <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html"
         *        >CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
         * </p>
         * 
         * @param trace
         *        Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock
         *        trace.
         * @see Trace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Trace
         */
        Builder trace(String trace);

        /**
         * <p>
         * Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.
         * </p>
         * 
         * @param trace
         *        Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock
         *        trace.
         * @see Trace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Trace
         */
        Builder trace(Trace trace);

        /**
         * <p>
         * The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is
         * applied to the invocation.
         * </p>
         * <p>
         * An error is thrown in the following situations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code>
         * field in the request body.
         * </p>
         * </li>
         * <li>
         * <p>
         * You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.
         * </p>
         * </li>
         * </ul>
         * 
         * @param guardrailIdentifier
         *        The unique identifier of the guardrail that you want to use. If you don't provide a value, no
         *        guardrail is applied to the invocation.</p>
         *        <p>
         *        An error is thrown in the following situations.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You don't provide a guardrail identifier but you specify the
         *        <code>amazon-bedrock-guardrailConfig</code> field in the request body.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailIdentifier(String guardrailIdentifier);

        /**
         * <p>
         * The version number for the guardrail. The value can also be <code>DRAFT</code>.
         * </p>
         * 
         * @param guardrailVersion
         *        The version number for the guardrail. The value can also be <code>DRAFT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailVersion(String guardrailVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private SdkBytes body;

        private String contentType;

        private String accept;

        private String modelId;

        private String trace;

        private String guardrailIdentifier;

        private String guardrailVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamRequest model) {
            super(model);
            body(model.body);
            contentType(model.contentType);
            accept(model.accept);
            modelId(model.modelId);
            trace(model.trace);
            guardrailIdentifier(model.guardrailIdentifier);
            guardrailVersion(model.guardrailVersion);
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getTrace() {
            return trace;
        }

        public final void setTrace(String trace) {
            this.trace = trace;
        }

        @Override
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public final Builder trace(Trace trace) {
            this.trace(trace == null ? null : trace.toString());
            return this;
        }

        public final String getGuardrailIdentifier() {
            return guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamRequest build() {
            return new InvokeModelWithResponseStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
