/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailTrace;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailConfiguration> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(GuardrailConfiguration.getter(GuardrailConfiguration::guardrailIdentifier)).setter(GuardrailConfiguration.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailIdentifier").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(GuardrailConfiguration.getter(GuardrailConfiguration::guardrailVersion)).setter(GuardrailConfiguration.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()}).build();
    private static final SdkField<String> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trace").getter(GuardrailConfiguration.getter(GuardrailConfiguration::traceAsString)).setter(GuardrailConfiguration.setter(Builder::trace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD, TRACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
            this.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
            this.put("trace", TRACE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String guardrailIdentifier;
    private final String guardrailVersion;
    private final String trace;

    private GuardrailConfiguration(BuilderImpl builder) {
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
        this.trace = builder.trace;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final GuardrailTrace trace() {
        return GuardrailTrace.fromValue(this.trace);
    }

    public final String traceAsString() {
        return this.trace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConfiguration)) {
            return false;
        }
        GuardrailConfiguration other = (GuardrailConfiguration)obj;
        return Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.traceAsString(), other.traceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailConfiguration").add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("Trace", (Object)this.traceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.traceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConfiguration, T> g) {
        return obj -> g.apply((GuardrailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String guardrailIdentifier;
        private String guardrailVersion;
        private String trace;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConfiguration model) {
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.guardrailVersion(model.guardrailVersion);
            this.trace(model.trace);
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getTrace() {
            return this.trace;
        }

        public final void setTrace(String trace) {
            this.trace = trace;
        }

        @Override
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @Override
        public final Builder trace(GuardrailTrace trace) {
            this.trace(trace == null ? null : trace.toString());
            return this;
        }

        public GuardrailConfiguration build() {
            return new GuardrailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailConfiguration> {
        public Builder guardrailIdentifier(String var1);

        public Builder guardrailVersion(String var1);

        public Builder trace(String var1);

        public Builder trace(GuardrailTrace var1);
    }
}

