/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A text block that contains text that you want to assess with a guardrail. For more information, see
 * <a>GuardrailConverseContentBlock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailConverseTextBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailConverseTextBlock.Builder, GuardrailConverseTextBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(GuardrailConverseTextBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<List<String>> QUALIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("qualifiers")
            .getter(getter(GuardrailConverseTextBlock::qualifiersAsStrings))
            .setter(setter(Builder::qualifiersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, QUALIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final List<String> qualifiers;

    private GuardrailConverseTextBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.qualifiers = builder.qualifiers;
    }

    /**
     * <p>
     * The text that you want to guard.
     * </p>
     * 
     * @return The text that you want to guard.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The qualifier details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQualifiers} method.
     * </p>
     * 
     * @return The qualifier details for the guardrails contextual grounding filter.
     */
    public final List<GuardrailConverseContentQualifier> qualifiers() {
        return GuardrailConverseContentQualifierListCopier.copyStringToEnum(qualifiers);
    }

    /**
     * For responses, this returns true if the service returned a value for the Qualifiers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQualifiers() {
        return qualifiers != null && !(qualifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The qualifier details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQualifiers} method.
     * </p>
     * 
     * @return The qualifier details for the guardrails contextual grounding filter.
     */
    public final List<String> qualifiersAsStrings() {
        return qualifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(hasQualifiers() ? qualifiersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConverseTextBlock)) {
            return false;
        }
        GuardrailConverseTextBlock other = (GuardrailConverseTextBlock) obj;
        return Objects.equals(text(), other.text()) && hasQualifiers() == other.hasQualifiers()
                && Objects.equals(qualifiersAsStrings(), other.qualifiersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailConverseTextBlock").add("Text", text())
                .add("Qualifiers", hasQualifiers() ? qualifiersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "qualifiers":
            return Optional.ofNullable(clazz.cast(qualifiersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("qualifiers", QUALIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConverseTextBlock, T> g) {
        return obj -> g.apply((GuardrailConverseTextBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailConverseTextBlock> {
        /**
         * <p>
         * The text that you want to guard.
         * </p>
         * 
         * @param text
         *        The text that you want to guard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The qualifier details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param qualifiers
         *        The qualifier details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifiersWithStrings(Collection<String> qualifiers);

        /**
         * <p>
         * The qualifier details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param qualifiers
         *        The qualifier details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifiersWithStrings(String... qualifiers);

        /**
         * <p>
         * The qualifier details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param qualifiers
         *        The qualifier details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifiers(Collection<GuardrailConverseContentQualifier> qualifiers);

        /**
         * <p>
         * The qualifier details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param qualifiers
         *        The qualifier details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifiers(GuardrailConverseContentQualifier... qualifiers);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private List<String> qualifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConverseTextBlock model) {
            text(model.text);
            qualifiersWithStrings(model.qualifiers);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Collection<String> getQualifiers() {
            if (qualifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return qualifiers;
        }

        public final void setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = GuardrailConverseContentQualifierListCopier.copy(qualifiers);
        }

        @Override
        public final Builder qualifiersWithStrings(Collection<String> qualifiers) {
            this.qualifiers = GuardrailConverseContentQualifierListCopier.copy(qualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifiersWithStrings(String... qualifiers) {
            qualifiersWithStrings(Arrays.asList(qualifiers));
            return this;
        }

        @Override
        public final Builder qualifiers(Collection<GuardrailConverseContentQualifier> qualifiers) {
            this.qualifiers = GuardrailConverseContentQualifierListCopier.copyEnumToString(qualifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualifiers(GuardrailConverseContentQualifier... qualifiers) {
            qualifiers(Arrays.asList(qualifiers));
            return this;
        }

        @Override
        public GuardrailConverseTextBlock build() {
            return new GuardrailConverseTextBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
