/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A prompt router trace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptRouterTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptRouterTrace.Builder, PromptRouterTrace> {
    private static final SdkField<String> INVOKED_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invokedModelId").getter(getter(PromptRouterTrace::invokedModelId))
            .setter(setter(Builder::invokedModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokedModelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKED_MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invokedModelId;

    private PromptRouterTrace(BuilderImpl builder) {
        this.invokedModelId = builder.invokedModelId;
    }

    /**
     * <p>
     * The ID of the invoked model.
     * </p>
     * 
     * @return The ID of the invoked model.
     */
    public final String invokedModelId() {
        return invokedModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invokedModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptRouterTrace)) {
            return false;
        }
        PromptRouterTrace other = (PromptRouterTrace) obj;
        return Objects.equals(invokedModelId(), other.invokedModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptRouterTrace").add("InvokedModelId", invokedModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invokedModelId":
            return Optional.ofNullable(clazz.cast(invokedModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invokedModelId", INVOKED_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptRouterTrace, T> g) {
        return obj -> g.apply((PromptRouterTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptRouterTrace> {
        /**
         * <p>
         * The ID of the invoked model.
         * </p>
         * 
         * @param invokedModelId
         *        The ID of the invoked model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedModelId(String invokedModelId);
    }

    static final class BuilderImpl implements Builder {
        private String invokedModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptRouterTrace model) {
            invokedModelId(model.invokedModelId);
        }

        public final String getInvokedModelId() {
            return invokedModelId;
        }

        public final void setInvokedModelId(String invokedModelId) {
            this.invokedModelId = invokedModelId;
        }

        @Override
        public final Builder invokedModelId(String invokedModelId) {
            this.invokedModelId = invokedModelId;
            return this;
        }

        @Override
        public PromptRouterTrace build() {
            return new PromptRouterTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
