/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The stop event for a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MessageStopEvent implements SdkPojo, Serializable, ToCopyableBuilder<MessageStopEvent.Builder, MessageStopEvent>,
        ConverseStreamOutput {
    private static final SdkField<String> STOP_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stopReason").getter(getter(MessageStopEvent::stopReasonAsString)).setter(setter(Builder::stopReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopReason").build()).build();

    private static final SdkField<Document> ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD = SdkField
            .<Document> builder(MarshallingType.DOCUMENT)
            .memberName("additionalModelResponseFields")
            .getter(getter(MessageStopEvent::additionalModelResponseFields))
            .setter(setter(Builder::additionalModelResponseFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFields")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOP_REASON_FIELD,
            ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stopReason;

    private final Document additionalModelResponseFields;

    protected MessageStopEvent(BuilderImpl builder) {
        this.stopReason = builder.stopReason;
        this.additionalModelResponseFields = builder.additionalModelResponseFields;
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopReason} will
     * return {@link StopReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopReasonAsString}.
     * </p>
     * 
     * @return The reason why the model stopped generating output.
     * @see StopReason
     */
    public final StopReason stopReason() {
        return StopReason.fromValue(stopReason);
    }

    /**
     * <p>
     * The reason why the model stopped generating output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stopReason} will
     * return {@link StopReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stopReasonAsString}.
     * </p>
     * 
     * @return The reason why the model stopped generating output.
     * @see StopReason
     */
    public final String stopReasonAsString() {
        return stopReason;
    }

    /**
     * <p>
     * The additional model response fields.
     * </p>
     * 
     * @return The additional model response fields.
     */
    public final Document additionalModelResponseFields() {
        return additionalModelResponseFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stopReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(additionalModelResponseFields());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageStopEvent)) {
            return false;
        }
        MessageStopEvent other = (MessageStopEvent) obj;
        return Objects.equals(stopReasonAsString(), other.stopReasonAsString())
                && Objects.equals(additionalModelResponseFields(), other.additionalModelResponseFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageStopEvent").add("StopReason", stopReasonAsString())
                .add("AdditionalModelResponseFields", additionalModelResponseFields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stopReason":
            return Optional.ofNullable(clazz.cast(stopReasonAsString()));
        case "additionalModelResponseFields":
            return Optional.ofNullable(clazz.cast(additionalModelResponseFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final MessageStopEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stopReason", STOP_REASON_FIELD);
        map.put("additionalModelResponseFields", ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageStopEvent, T> g) {
        return obj -> g.apply((MessageStopEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link MessageStopEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageStopEvent> {
        /**
         * <p>
         * The reason why the model stopped generating output.
         * </p>
         * 
         * @param stopReason
         *        The reason why the model stopped generating output.
         * @see StopReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopReason
         */
        Builder stopReason(String stopReason);

        /**
         * <p>
         * The reason why the model stopped generating output.
         * </p>
         * 
         * @param stopReason
         *        The reason why the model stopped generating output.
         * @see StopReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StopReason
         */
        Builder stopReason(StopReason stopReason);

        /**
         * <p>
         * The additional model response fields.
         * </p>
         * 
         * @param additionalModelResponseFields
         *        The additional model response fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelResponseFields(Document additionalModelResponseFields);
    }

    protected static class BuilderImpl implements Builder {
        private String stopReason;

        private Document additionalModelResponseFields;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MessageStopEvent model) {
            stopReason(model.stopReason);
            additionalModelResponseFields(model.additionalModelResponseFields);
        }

        public final String getStopReason() {
            return stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        @Override
        public final Builder stopReason(StopReason stopReason) {
            this.stopReason(stopReason == null ? null : stopReason.toString());
            return this;
        }

        public final Document getAdditionalModelResponseFields() {
            return additionalModelResponseFields;
        }

        public final void setAdditionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
        }

        @Override
        public final Builder additionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
            return this;
        }

        @Override
        public MessageStopEvent build() {
            return new MessageStopEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
