/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model.invokemodelwithbidirectionalstreamoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.BidirectionalOutputPayloadPart;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockruntime.model.BidirectionalOutputPayloadPart} that
 * represents the {@code InvokeModelWithBidirectionalStreamOutput$chunk} event. Do not use this class directly. Instead,
 * use the static builder methods on
 * {@link software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithBidirectionalStreamOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultChunk extends BidirectionalOutputPayloadPart {
    private static final long serialVersionUID = 1L;

    DefaultChunk(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeModelWithBidirectionalStreamResponseHandler.Visitor visitor) {
        visitor.visitChunk(this);
    }

    @Override
    public InvokeModelWithBidirectionalStreamOutput.EventType sdkEventType() {
        return InvokeModelWithBidirectionalStreamOutput.EventType.CHUNK;
    }

    public interface Builder extends BidirectionalOutputPayloadPart.Builder {
        @Override
        DefaultChunk build();
    }

    private static final class BuilderImpl extends BidirectionalOutputPayloadPart.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultChunk event) {
            super(event);
        }

        @Override
        public DefaultChunk build() {
            return new DefaultChunk(this);
        }
    }
}
