/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billing.model.BillingResponse;
import software.amazon.awssdk.services.billing.model.BillingViewListCopier;
import software.amazon.awssdk.services.billing.model.BillingViewListElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingViewsResponse
extends BillingResponse
implements ToCopyableBuilder<Builder, ListBillingViewsResponse> {
    private static final SdkField<List<BillingViewListElement>> BILLING_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("billingViews").getter(ListBillingViewsResponse.getter(ListBillingViewsResponse::billingViews)).setter(ListBillingViewsResponse.setter(Builder::billingViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BillingViewListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBillingViewsResponse.getter(ListBillingViewsResponse::nextToken)).setter(ListBillingViewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_VIEWS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("billingViews", BILLING_VIEWS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<BillingViewListElement> billingViews;
    private final String nextToken;

    private ListBillingViewsResponse(BuilderImpl builder) {
        super(builder);
        this.billingViews = builder.billingViews;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBillingViews() {
        return this.billingViews != null && !(this.billingViews instanceof SdkAutoConstructList);
    }

    public final List<BillingViewListElement> billingViews() {
        return this.billingViews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBillingViews() ? this.billingViews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingViewsResponse)) {
            return false;
        }
        ListBillingViewsResponse other = (ListBillingViewsResponse)((Object)obj);
        return this.hasBillingViews() == other.hasBillingViews() && Objects.equals(this.billingViews(), other.billingViews()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingViewsResponse").add("BillingViews", this.hasBillingViews() ? this.billingViews() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingViews": {
                return Optional.ofNullable(clazz.cast(this.billingViews()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingViewsResponse, T> g) {
        return obj -> g.apply((ListBillingViewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingResponse.BuilderImpl
    implements Builder {
        private List<BillingViewListElement> billingViews = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingViewsResponse model) {
            super(model);
            this.billingViews(model.billingViews);
            this.nextToken(model.nextToken);
        }

        public final List<BillingViewListElement.Builder> getBillingViews() {
            List<BillingViewListElement.Builder> result = BillingViewListCopier.copyToBuilder(this.billingViews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBillingViews(Collection<BillingViewListElement.BuilderImpl> billingViews) {
            this.billingViews = BillingViewListCopier.copyFromBuilder(billingViews);
        }

        @Override
        public final Builder billingViews(Collection<BillingViewListElement> billingViews) {
            this.billingViews = BillingViewListCopier.copy(billingViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingViews(BillingViewListElement ... billingViews) {
            this.billingViews(Arrays.asList(billingViews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingViews(Consumer<BillingViewListElement.Builder> ... billingViews) {
            this.billingViews(Stream.of(billingViews).map(c -> (BillingViewListElement)((BillingViewListElement.Builder)BillingViewListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBillingViewsResponse build() {
            return new ListBillingViewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBillingViewsResponse> {
        public Builder billingViews(Collection<BillingViewListElement> var1);

        public Builder billingViews(BillingViewListElement ... var1);

        public Builder billingViews(Consumer<BillingViewListElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

