/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A time range with a start and end time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveTimeRange implements SdkPojo, Serializable, ToCopyableBuilder<ActiveTimeRange.Builder, ActiveTimeRange> {
    private static final SdkField<Instant> ACTIVE_AFTER_INCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("activeAfterInclusive").getter(getter(ActiveTimeRange::activeAfterInclusive))
            .setter(setter(Builder::activeAfterInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeAfterInclusive").build())
            .build();

    private static final SdkField<Instant> ACTIVE_BEFORE_INCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("activeBeforeInclusive").getter(getter(ActiveTimeRange::activeBeforeInclusive))
            .setter(setter(Builder::activeBeforeInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeBeforeInclusive").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_AFTER_INCLUSIVE_FIELD,
            ACTIVE_BEFORE_INCLUSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant activeAfterInclusive;

    private final Instant activeBeforeInclusive;

    private ActiveTimeRange(BuilderImpl builder) {
        this.activeAfterInclusive = builder.activeAfterInclusive;
        this.activeBeforeInclusive = builder.activeBeforeInclusive;
    }

    /**
     * <p>
     * The inclusive time range start date.
     * </p>
     * 
     * @return The inclusive time range start date.
     */
    public final Instant activeAfterInclusive() {
        return activeAfterInclusive;
    }

    /**
     * <p>
     * The inclusive time range end date.
     * </p>
     * 
     * @return The inclusive time range end date.
     */
    public final Instant activeBeforeInclusive() {
        return activeBeforeInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeAfterInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(activeBeforeInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveTimeRange)) {
            return false;
        }
        ActiveTimeRange other = (ActiveTimeRange) obj;
        return Objects.equals(activeAfterInclusive(), other.activeAfterInclusive())
                && Objects.equals(activeBeforeInclusive(), other.activeBeforeInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveTimeRange").add("ActiveAfterInclusive", activeAfterInclusive())
                .add("ActiveBeforeInclusive", activeBeforeInclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeAfterInclusive":
            return Optional.ofNullable(clazz.cast(activeAfterInclusive()));
        case "activeBeforeInclusive":
            return Optional.ofNullable(clazz.cast(activeBeforeInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeAfterInclusive", ACTIVE_AFTER_INCLUSIVE_FIELD);
        map.put("activeBeforeInclusive", ACTIVE_BEFORE_INCLUSIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveTimeRange, T> g) {
        return obj -> g.apply((ActiveTimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveTimeRange> {
        /**
         * <p>
         * The inclusive time range start date.
         * </p>
         * 
         * @param activeAfterInclusive
         *        The inclusive time range start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAfterInclusive(Instant activeAfterInclusive);

        /**
         * <p>
         * The inclusive time range end date.
         * </p>
         * 
         * @param activeBeforeInclusive
         *        The inclusive time range end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeBeforeInclusive(Instant activeBeforeInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Instant activeAfterInclusive;

        private Instant activeBeforeInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveTimeRange model) {
            activeAfterInclusive(model.activeAfterInclusive);
            activeBeforeInclusive(model.activeBeforeInclusive);
        }

        public final Instant getActiveAfterInclusive() {
            return activeAfterInclusive;
        }

        public final void setActiveAfterInclusive(Instant activeAfterInclusive) {
            this.activeAfterInclusive = activeAfterInclusive;
        }

        @Override
        public final Builder activeAfterInclusive(Instant activeAfterInclusive) {
            this.activeAfterInclusive = activeAfterInclusive;
            return this;
        }

        public final Instant getActiveBeforeInclusive() {
            return activeBeforeInclusive;
        }

        public final void setActiveBeforeInclusive(Instant activeBeforeInclusive) {
            this.activeBeforeInclusive = activeBeforeInclusive;
        }

        @Override
        public final Builder activeBeforeInclusive(Instant activeBeforeInclusive) {
            this.activeBeforeInclusive = activeBeforeInclusive;
            return this;
        }

        @Override
        public ActiveTimeRange build() {
            return new ActiveTimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
