/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.billing.model.AssociateSourceViewsRequest;
import software.amazon.awssdk.services.billing.model.AssociateSourceViewsResponse;
import software.amazon.awssdk.services.billing.model.CreateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.CreateBillingViewResponse;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewRequest;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewResponse;
import software.amazon.awssdk.services.billing.model.DisassociateSourceViewsRequest;
import software.amazon.awssdk.services.billing.model.DisassociateSourceViewsResponse;
import software.amazon.awssdk.services.billing.model.GetBillingViewRequest;
import software.amazon.awssdk.services.billing.model.GetBillingViewResponse;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billing.model.TagResourceRequest;
import software.amazon.awssdk.services.billing.model.TagResourceResponse;
import software.amazon.awssdk.services.billing.model.UntagResourceRequest;
import software.amazon.awssdk.services.billing.model.UntagResourceResponse;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewResponse;
import software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher;
import software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher;

/**
 * Service client for accessing AWS Billing asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * You can use the Billing API to programatically list the billing views available to you for a given time period. A
 * billing view represents a set of billing data.
 * </p>
 * <p>
 * The Billing API provides the following endpoint:
 * </p>
 * <p>
 * <code>https://billing.us-east-1.api.aws</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BillingAsyncClient extends AwsClient {
    String SERVICE_NAME = "billing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "billing";

    /**
     * <p>
     * Associates one or more source billing views with an existing billing view. This allows creating aggregate billing
     * views that combine data from multiple sources.
     * </p>
     *
     * @param associateSourceViewsRequest
     * @return A Java Future containing the result of the AssociateSourceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.AssociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/AssociateSourceViews" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSourceViewsResponse> associateSourceViews(
            AssociateSourceViewsRequest associateSourceViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more source billing views with an existing billing view. This allows creating aggregate billing
     * views that combine data from multiple sources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSourceViewsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSourceViewsRequest#builder()}
     * </p>
     *
     * @param associateSourceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.AssociateSourceViewsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSourceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.AssociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/AssociateSourceViews" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSourceViewsResponse> associateSourceViews(
            Consumer<AssociateSourceViewsRequest.Builder> associateSourceViewsRequest) {
        return associateSourceViews(AssociateSourceViewsRequest.builder().applyMutation(associateSourceViewsRequest).build());
    }

    /**
     * <p>
     * Creates a billing view with the specified billing view attributes.
     * </p>
     *
     * @param createBillingViewRequest
     * @return A Java Future containing the result of the CreateBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.CreateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/CreateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBillingViewResponse> createBillingView(CreateBillingViewRequest createBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing view with the specified billing view attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBillingViewRequest#builder()}
     * </p>
     *
     * @param createBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.CreateBillingViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.CreateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/CreateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBillingViewResponse> createBillingView(
            Consumer<CreateBillingViewRequest.Builder> createBillingViewRequest) {
        return createBillingView(CreateBillingViewRequest.builder().applyMutation(createBillingViewRequest).build());
    }

    /**
     * <p>
     * Deletes the specified billing view.
     * </p>
     *
     * @param deleteBillingViewRequest
     * @return A Java Future containing the result of the DeleteBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.DeleteBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DeleteBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBillingViewResponse> deleteBillingView(DeleteBillingViewRequest deleteBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBillingViewRequest#builder()}
     * </p>
     *
     * @param deleteBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.DeleteBillingViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.DeleteBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DeleteBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBillingViewResponse> deleteBillingView(
            Consumer<DeleteBillingViewRequest.Builder> deleteBillingViewRequest) {
        return deleteBillingView(DeleteBillingViewRequest.builder().applyMutation(deleteBillingViewRequest).build());
    }

    /**
     * <p>
     * Removes the association between one or more source billing views and an existing billing view. This allows
     * modifying the composition of aggregate billing views.
     * </p>
     *
     * @param disassociateSourceViewsRequest
     * @return A Java Future containing the result of the DisassociateSourceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.DisassociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DisassociateSourceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSourceViewsResponse> disassociateSourceViews(
            DisassociateSourceViewsRequest disassociateSourceViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between one or more source billing views and an existing billing view. This allows
     * modifying the composition of aggregate billing views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSourceViewsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSourceViewsRequest#builder()}
     * </p>
     *
     * @param disassociateSourceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.DisassociateSourceViewsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateSourceViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.DisassociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DisassociateSourceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateSourceViewsResponse> disassociateSourceViews(
            Consumer<DisassociateSourceViewsRequest.Builder> disassociateSourceViewsRequest) {
        return disassociateSourceViews(DisassociateSourceViewsRequest.builder().applyMutation(disassociateSourceViewsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the metadata associated to the specified billing view ARN.
     * </p>
     *
     * @param getBillingViewRequest
     * @return A Java Future containing the result of the GetBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.GetBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBillingViewResponse> getBillingView(GetBillingViewRequest getBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata associated to the specified billing view ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillingViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetBillingViewRequest#builder()}
     * </p>
     *
     * @param getBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.GetBillingViewRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.GetBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBillingViewResponse> getBillingView(Consumer<GetBillingViewRequest.Builder> getBillingViewRequest) {
        return getBillingView(GetBillingViewRequest.builder().applyMutation(getBillingViewRequest).build());
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource in <code>JSON</code> format.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource in <code>JSON</code> format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Lists the billing views available for a given time period.
     * </p>
     * <p>
     * Every Amazon Web Services account has a unique <code>PRIMARY</code> billing view that represents the billing data
     * available by default. Accounts that use Billing Conductor also have <code>BILLING_GROUP</code> billing views
     * representing pro forma costs associated with each created billing group.
     * </p>
     *
     * @param listBillingViewsRequest
     * @return A Java Future containing the result of the ListBillingViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBillingViewsResponse> listBillingViews(ListBillingViewsRequest listBillingViewsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the billing views available for a given time period.
     * </p>
     * <p>
     * Every Amazon Web Services account has a unique <code>PRIMARY</code> billing view that represents the billing data
     * available by default. Accounts that use Billing Conductor also have <code>BILLING_GROUP</code> billing views
     * representing pro forma costs associated with each created billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingViewsRequest#builder()}
     * </p>
     *
     * @param listBillingViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListBillingViewsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBillingViews operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBillingViewsResponse> listBillingViews(
            Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) {
        return listBillingViews(ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher publisher = client.listBillingViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher publisher = client.listBillingViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billing.model.ListBillingViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billing.model.ListBillingViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation.</b>
     * </p>
     *
     * @param listBillingViewsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsPublisher listBillingViewsPaginator(ListBillingViewsRequest listBillingViewsRequest) {
        return new ListBillingViewsPublisher(this, listBillingViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher publisher = client.listBillingViewsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsPublisher publisher = client.listBillingViewsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billing.model.ListBillingViewsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billing.model.ListBillingViewsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingViewsRequest#builder()}
     * </p>
     *
     * @param listBillingViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListBillingViewsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsPublisher listBillingViewsPaginator(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest) {
        return listBillingViewsPaginator(ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest).build());
    }

    /**
     * <p>
     * Lists the source views (managed Amazon Web Services billing views) associated with the billing view.
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     * @return A Java Future containing the result of the ListSourceViewsForBillingView operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSourceViewsForBillingViewResponse> listSourceViewsForBillingView(
            ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the source views (managed Amazon Web Services billing views) associated with the billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceViewsForBillingViewRequest.Builder}
     * avoiding the need to create one manually via {@link ListSourceViewsForBillingViewRequest#builder()}
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSourceViewsForBillingView operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSourceViewsForBillingViewResponse> listSourceViewsForBillingView(
            Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest) {
        return listSourceViewsForBillingView(ListSourceViewsForBillingViewRequest.builder()
                .applyMutation(listSourceViewsForBillingViewRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher publisher = client.listSourceViewsForBillingViewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher publisher = client.listSourceViewsForBillingViewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewPublisher listSourceViewsForBillingViewPaginator(
            ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) {
        return new ListSourceViewsForBillingViewPublisher(this, listSourceViewsForBillingViewRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher publisher = client.listSourceViewsForBillingViewPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewPublisher publisher = client.listSourceViewsForBillingViewPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceViewsForBillingViewRequest.Builder}
     * avoiding the need to create one manually via {@link ListSourceViewsForBillingViewRequest#builder()}
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewPublisher listSourceViewsForBillingViewPaginator(
            Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest) {
        return listSourceViewsForBillingViewPaginator(ListSourceViewsForBillingViewRequest.builder()
                .applyMutation(listSourceViewsForBillingViewRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with the billing view resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with the billing view resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * An API to update the attributes of the billing view.
     * </p>
     *
     * @param updateBillingViewRequest
     * @return A Java Future containing the result of the UpdateBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.UpdateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UpdateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBillingViewResponse> updateBillingView(UpdateBillingViewRequest updateBillingViewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API to update the attributes of the billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBillingViewRequest#builder()}
     * </p>
     *
     * @param updateBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.UpdateBillingViewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBillingView operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BillingViewHealthStatusException Exception thrown when a billing view's health status prevents an
     *         operation from being performed. This may occur if the billing view is in a state other than
     *         <code>HEALTHY</code>.</li>
     *         <li>ServiceQuotaExceededException You've reached the limit of resources you can create, or exceeded the
     *         size of an individual resource.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException The specified ARN in the request doesn't exist.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>InternalServerException The request processing failed because of an unknown error, exception, or
     *         failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>BillingException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample BillingAsyncClient.UpdateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UpdateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateBillingViewResponse> updateBillingView(
            Consumer<UpdateBillingViewRequest.Builder> updateBillingViewRequest) {
        return updateBillingView(UpdateBillingViewRequest.builder().applyMutation(updateBillingViewRequest).build());
    }

    @Override
    default BillingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link BillingAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BillingAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BillingAsyncClient}.
     */
    static BillingAsyncClientBuilder builder() {
        return new DefaultBillingAsyncClientBuilder();
    }
}
