/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.billing.model.AccessDeniedException;
import software.amazon.awssdk.services.billing.model.AssociateSourceViewsRequest;
import software.amazon.awssdk.services.billing.model.AssociateSourceViewsResponse;
import software.amazon.awssdk.services.billing.model.BillingException;
import software.amazon.awssdk.services.billing.model.BillingViewHealthStatusException;
import software.amazon.awssdk.services.billing.model.ConflictException;
import software.amazon.awssdk.services.billing.model.CreateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.CreateBillingViewResponse;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewRequest;
import software.amazon.awssdk.services.billing.model.DeleteBillingViewResponse;
import software.amazon.awssdk.services.billing.model.DisassociateSourceViewsRequest;
import software.amazon.awssdk.services.billing.model.DisassociateSourceViewsResponse;
import software.amazon.awssdk.services.billing.model.GetBillingViewRequest;
import software.amazon.awssdk.services.billing.model.GetBillingViewResponse;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.billing.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.billing.model.InternalServerException;
import software.amazon.awssdk.services.billing.model.ListBillingViewsRequest;
import software.amazon.awssdk.services.billing.model.ListBillingViewsResponse;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billing.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billing.model.ResourceNotFoundException;
import software.amazon.awssdk.services.billing.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.billing.model.TagResourceRequest;
import software.amazon.awssdk.services.billing.model.TagResourceResponse;
import software.amazon.awssdk.services.billing.model.ThrottlingException;
import software.amazon.awssdk.services.billing.model.UntagResourceRequest;
import software.amazon.awssdk.services.billing.model.UntagResourceResponse;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewRequest;
import software.amazon.awssdk.services.billing.model.UpdateBillingViewResponse;
import software.amazon.awssdk.services.billing.model.ValidationException;
import software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable;
import software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable;

/**
 * Service client for accessing AWS Billing. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * You can use the Billing API to programatically list the billing views available to you for a given time period. A
 * billing view represents a set of billing data.
 * </p>
 * <p>
 * The Billing API provides the following endpoint:
 * </p>
 * <p>
 * <code>https://billing.us-east-1.api.aws</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BillingClient extends AwsClient {
    String SERVICE_NAME = "billing";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "billing";

    /**
     * <p>
     * Associates one or more source billing views with an existing billing view. This allows creating aggregate billing
     * views that combine data from multiple sources.
     * </p>
     *
     * @param associateSourceViewsRequest
     * @return Result of the AssociateSourceViews operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.AssociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/AssociateSourceViews" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSourceViewsResponse associateSourceViews(AssociateSourceViewsRequest associateSourceViewsRequest)
            throws BillingViewHealthStatusException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates one or more source billing views with an existing billing view. This allows creating aggregate billing
     * views that combine data from multiple sources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSourceViewsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSourceViewsRequest#builder()}
     * </p>
     *
     * @param associateSourceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.AssociateSourceViewsRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSourceViews operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.AssociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/AssociateSourceViews" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSourceViewsResponse associateSourceViews(
            Consumer<AssociateSourceViewsRequest.Builder> associateSourceViewsRequest) throws BillingViewHealthStatusException,
            ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingException {
        return associateSourceViews(AssociateSourceViewsRequest.builder().applyMutation(associateSourceViewsRequest).build());
    }

    /**
     * <p>
     * Creates a billing view with the specified billing view attributes.
     * </p>
     *
     * @param createBillingViewRequest
     * @return Result of the CreateBillingView operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.CreateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/CreateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBillingViewResponse createBillingView(CreateBillingViewRequest createBillingViewRequest)
            throws BillingViewHealthStatusException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing view with the specified billing view attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBillingViewRequest#builder()}
     * </p>
     *
     * @param createBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.CreateBillingViewRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBillingView operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.CreateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/CreateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateBillingViewResponse createBillingView(Consumer<CreateBillingViewRequest.Builder> createBillingViewRequest)
            throws BillingViewHealthStatusException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        return createBillingView(CreateBillingViewRequest.builder().applyMutation(createBillingViewRequest).build());
    }

    /**
     * <p>
     * Deletes the specified billing view.
     * </p>
     *
     * @param deleteBillingViewRequest
     * @return Result of the DeleteBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.DeleteBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DeleteBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBillingViewResponse deleteBillingView(DeleteBillingViewRequest deleteBillingViewRequest)
            throws ThrottlingException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBillingViewRequest#builder()}
     * </p>
     *
     * @param deleteBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.DeleteBillingViewRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.DeleteBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DeleteBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteBillingViewResponse deleteBillingView(Consumer<DeleteBillingViewRequest.Builder> deleteBillingViewRequest)
            throws ThrottlingException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        return deleteBillingView(DeleteBillingViewRequest.builder().applyMutation(deleteBillingViewRequest).build());
    }

    /**
     * <p>
     * Removes the association between one or more source billing views and an existing billing view. This allows
     * modifying the composition of aggregate billing views.
     * </p>
     *
     * @param disassociateSourceViewsRequest
     * @return Result of the DisassociateSourceViews operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.DisassociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DisassociateSourceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSourceViewsResponse disassociateSourceViews(DisassociateSourceViewsRequest disassociateSourceViewsRequest)
            throws BillingViewHealthStatusException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the association between one or more source billing views and an existing billing view. This allows
     * modifying the composition of aggregate billing views.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSourceViewsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSourceViewsRequest#builder()}
     * </p>
     *
     * @param disassociateSourceViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.DisassociateSourceViewsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSourceViews operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.DisassociateSourceViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/DisassociateSourceViews"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSourceViewsResponse disassociateSourceViews(
            Consumer<DisassociateSourceViewsRequest.Builder> disassociateSourceViewsRequest)
            throws BillingViewHealthStatusException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingException {
        return disassociateSourceViews(DisassociateSourceViewsRequest.builder().applyMutation(disassociateSourceViewsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the metadata associated to the specified billing view ARN.
     * </p>
     *
     * @param getBillingViewRequest
     * @return Result of the GetBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.GetBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBillingViewResponse getBillingView(GetBillingViewRequest getBillingViewRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the metadata associated to the specified billing view ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBillingViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetBillingViewRequest#builder()}
     * </p>
     *
     * @param getBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.GetBillingViewRequest.Builder} to create a request.
     * @return Result of the GetBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.GetBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default GetBillingViewResponse getBillingView(Consumer<GetBillingViewRequest.Builder> getBillingViewRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return getBillingView(GetBillingViewRequest.builder().applyMutation(getBillingViewRequest).build());
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource in <code>JSON</code> format.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource-based policy document attached to the resource in <code>JSON</code> format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Lists the billing views available for a given time period.
     * </p>
     * <p>
     * Every Amazon Web Services account has a unique <code>PRIMARY</code> billing view that represents the billing data
     * available by default. Accounts that use Billing Conductor also have <code>BILLING_GROUP</code> billing views
     * representing pro forma costs associated with each created billing group.
     * </p>
     *
     * @param listBillingViewsRequest
     * @return Result of the ListBillingViews operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsResponse listBillingViews(ListBillingViewsRequest listBillingViewsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the billing views available for a given time period.
     * </p>
     * <p>
     * Every Amazon Web Services account has a unique <code>PRIMARY</code> billing view that represents the billing data
     * available by default. Accounts that use Billing Conductor also have <code>BILLING_GROUP</code> billing views
     * representing pro forma costs associated with each created billing group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingViewsRequest#builder()}
     * </p>
     *
     * @param listBillingViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListBillingViewsRequest.Builder} to create a request.
     * @return Result of the ListBillingViews operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsResponse listBillingViews(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return listBillingViews(ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client.listBillingViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client
     *             .listBillingViewsPaginator(request);
     *     for (software.amazon.awssdk.services.billing.model.ListBillingViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client.listBillingViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation.</b>
     * </p>
     *
     * @param listBillingViewsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsIterable listBillingViewsPaginator(ListBillingViewsRequest listBillingViewsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return new ListBillingViewsIterable(this, listBillingViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client.listBillingViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client
     *             .listBillingViewsPaginator(request);
     *     for (software.amazon.awssdk.services.billing.model.ListBillingViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListBillingViewsIterable responses = client.listBillingViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingViews(software.amazon.awssdk.services.billing.model.ListBillingViewsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingViewsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingViewsRequest#builder()}
     * </p>
     *
     * @param listBillingViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListBillingViewsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListBillingViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListBillingViews" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBillingViewsIterable listBillingViewsPaginator(Consumer<ListBillingViewsRequest.Builder> listBillingViewsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return listBillingViewsPaginator(ListBillingViewsRequest.builder().applyMutation(listBillingViewsRequest).build());
    }

    /**
     * <p>
     * Lists the source views (managed Amazon Web Services billing views) associated with the billing view.
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     * @return Result of the ListSourceViewsForBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewResponse listSourceViewsForBillingView(
            ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the source views (managed Amazon Web Services billing views) associated with the billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceViewsForBillingViewRequest.Builder}
     * avoiding the need to create one manually via {@link ListSourceViewsForBillingViewRequest#builder()}
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest.Builder} to
     *        create a request.
     * @return Result of the ListSourceViewsForBillingView operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewResponse listSourceViewsForBillingView(
            Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return listSourceViewsForBillingView(ListSourceViewsForBillingViewRequest.builder()
                .applyMutation(listSourceViewsForBillingViewRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client.listSourceViewsForBillingViewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client
     *             .listSourceViewsForBillingViewPaginator(request);
     *     for (software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client.listSourceViewsForBillingViewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewIterable listSourceViewsForBillingViewPaginator(
            ListSourceViewsForBillingViewRequest listSourceViewsForBillingViewRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return new ListSourceViewsForBillingViewIterable(this, listSourceViewsForBillingViewRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client.listSourceViewsForBillingViewPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client
     *             .listSourceViewsForBillingViewPaginator(request);
     *     for (software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billing.paginators.ListSourceViewsForBillingViewIterable responses = client.listSourceViewsForBillingViewPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceViewsForBillingView(software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceViewsForBillingViewRequest.Builder}
     * avoiding the need to create one manually via {@link ListSourceViewsForBillingViewRequest#builder()}
     * </p>
     *
     * @param listSourceViewsForBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListSourceViewsForBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListSourceViewsForBillingView"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceViewsForBillingViewIterable listSourceViewsForBillingViewPaginator(
            Consumer<ListSourceViewsForBillingViewRequest.Builder> listSourceViewsForBillingViewRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return listSourceViewsForBillingViewPaginator(ListSourceViewsForBillingViewRequest.builder()
                .applyMutation(listSourceViewsForBillingViewRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with the billing view resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with the billing view resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API operation for adding one or more tags (key-value pairs) to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource. Specify only tag keys in your request. Don't specify the value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, BillingException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * An API to update the attributes of the billing view.
     * </p>
     *
     * @param updateBillingViewRequest
     * @return Result of the UpdateBillingView operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.UpdateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UpdateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBillingViewResponse updateBillingView(UpdateBillingViewRequest updateBillingViewRequest)
            throws BillingViewHealthStatusException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An API to update the attributes of the billing view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBillingViewRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBillingViewRequest#builder()}
     * </p>
     *
     * @param updateBillingViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.billing.model.UpdateBillingViewRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateBillingView operation returned by the service.
     * @throws BillingViewHealthStatusException
     *         Exception thrown when a billing view's health status prevents an operation from being performed. This may
     *         occur if the billing view is in a state other than <code>HEALTHY</code>.
     * @throws ServiceQuotaExceededException
     *         You've reached the limit of resources you can create, or exceeded the size of an individual resource.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         The specified ARN in the request doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action.
     * @throws ConflictException
     *         The requested operation would cause a conflict with the current state of a service resource associated
     *         with the request. Resolve the conflict before retrying this request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing failed because of an unknown error, exception, or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingClient.UpdateBillingView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billing-2023-09-07/UpdateBillingView" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateBillingViewResponse updateBillingView(Consumer<UpdateBillingViewRequest.Builder> updateBillingViewRequest)
            throws BillingViewHealthStatusException, ServiceQuotaExceededException, ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingException {
        return updateBillingView(UpdateBillingViewRequest.builder().applyMutation(updateBillingViewRequest).build());
    }

    /**
     * Create a {@link BillingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BillingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BillingClient}.
     */
    static BillingClientBuilder builder() {
        return new DefaultBillingClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BillingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
