/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata associated to the billing view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingViewElement implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingViewElement.Builder, BillingViewElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(BillingViewElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BillingViewElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BillingViewElement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BILLING_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingViewType").getter(getter(BillingViewElement::billingViewTypeAsString))
            .setter(setter(Builder::billingViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViewType").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(BillingViewElement::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountId").getter(getter(BillingViewElement::sourceAccountId))
            .setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()).build();

    private static final SdkField<Expression> DATA_FILTER_EXPRESSION_FIELD = SdkField
            .<Expression> builder(MarshallingType.SDK_POJO).memberName("dataFilterExpression")
            .getter(getter(BillingViewElement::dataFilterExpression)).setter(setter(Builder::dataFilterExpression))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFilterExpression").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(BillingViewElement::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(BillingViewElement::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<Integer> DERIVED_VIEW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("derivedViewCount").getter(getter(BillingViewElement::derivedViewCount))
            .setter(setter(Builder::derivedViewCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("derivedViewCount").build()).build();

    private static final SdkField<Integer> SOURCE_VIEW_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sourceViewCount").getter(getter(BillingViewElement::sourceViewCount))
            .setter(setter(Builder::sourceViewCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceViewCount").build()).build();

    private static final SdkField<Instant> VIEW_DEFINITION_LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("viewDefinitionLastUpdatedAt")
            .getter(getter(BillingViewElement::viewDefinitionLastUpdatedAt))
            .setter(setter(Builder::viewDefinitionLastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewDefinitionLastUpdatedAt")
                    .build()).build();

    private static final SdkField<BillingViewHealthStatus> HEALTH_STATUS_FIELD = SdkField
            .<BillingViewHealthStatus> builder(MarshallingType.SDK_POJO).memberName("healthStatus")
            .getter(getter(BillingViewElement::healthStatus)).setter(setter(Builder::healthStatus))
            .constructor(BillingViewHealthStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, BILLING_VIEW_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, SOURCE_ACCOUNT_ID_FIELD,
            DATA_FILTER_EXPRESSION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DERIVED_VIEW_COUNT_FIELD, SOURCE_VIEW_COUNT_FIELD,
            VIEW_DEFINITION_LAST_UPDATED_AT_FIELD, HEALTH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String billingViewType;

    private final String ownerAccountId;

    private final String sourceAccountId;

    private final Expression dataFilterExpression;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final Integer derivedViewCount;

    private final Integer sourceViewCount;

    private final Instant viewDefinitionLastUpdatedAt;

    private final BillingViewHealthStatus healthStatus;

    private BillingViewElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.billingViewType = builder.billingViewType;
        this.ownerAccountId = builder.ownerAccountId;
        this.sourceAccountId = builder.sourceAccountId;
        this.dataFilterExpression = builder.dataFilterExpression;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.derivedViewCount = builder.derivedViewCount;
        this.sourceViewCount = builder.sourceViewCount;
        this.viewDefinitionLastUpdatedAt = builder.viewDefinitionLastUpdatedAt;
        this.healthStatus = builder.healthStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The account name of the billing view.
     * </p>
     * 
     * @return The account name of the billing view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the billing view.
     * </p>
     * 
     * @return The description of the billing view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of billing group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingViewType}
     * will return {@link BillingViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingViewTypeAsString}.
     * </p>
     * 
     * @return The type of billing group.
     * @see BillingViewType
     */
    public final BillingViewType billingViewType() {
        return BillingViewType.fromValue(billingViewType);
    }

    /**
     * <p>
     * The type of billing group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingViewType}
     * will return {@link BillingViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingViewTypeAsString}.
     * </p>
     * 
     * @return The type of billing group.
     * @see BillingViewType
     */
    public final String billingViewTypeAsString() {
        return billingViewType;
    }

    /**
     * <p>
     * The account owner of the billing view.
     * </p>
     * 
     * @return The account owner of the billing view.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * See <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
     * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
     * </p>
     * 
     * @return See <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html"
     *         >Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
     */
    public final Expression dataFilterExpression() {
        return dataFilterExpression;
    }

    /**
     * <p>
     * The time when the billing view was created.
     * </p>
     * 
     * @return The time when the billing view was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the billing view was last updated.
     * </p>
     * 
     * @return The time when the billing view was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The number of billing views that use this billing view as a source.
     * </p>
     * 
     * @return The number of billing views that use this billing view as a source.
     */
    public final Integer derivedViewCount() {
        return derivedViewCount;
    }

    /**
     * <p>
     * The number of source views associated with this billing view.
     * </p>
     * 
     * @return The number of source views associated with this billing view.
     */
    public final Integer sourceViewCount() {
        return sourceViewCount;
    }

    /**
     * <p>
     * The timestamp of when the billing view definition was last updated.
     * </p>
     * 
     * @return The timestamp of when the billing view definition was last updated.
     */
    public final Instant viewDefinitionLastUpdatedAt() {
        return viewDefinitionLastUpdatedAt;
    }

    /**
     * <p>
     * The current health status of the billing view.
     * </p>
     * 
     * @return The current health status of the billing view.
     */
    public final BillingViewHealthStatus healthStatus() {
        return healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(billingViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataFilterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(derivedViewCount());
        hashCode = 31 * hashCode + Objects.hashCode(sourceViewCount());
        hashCode = 31 * hashCode + Objects.hashCode(viewDefinitionLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingViewElement)) {
            return false;
        }
        BillingViewElement other = (BillingViewElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(billingViewTypeAsString(), other.billingViewTypeAsString())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(sourceAccountId(), other.sourceAccountId())
                && Objects.equals(dataFilterExpression(), other.dataFilterExpression())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(derivedViewCount(), other.derivedViewCount())
                && Objects.equals(sourceViewCount(), other.sourceViewCount())
                && Objects.equals(viewDefinitionLastUpdatedAt(), other.viewDefinitionLastUpdatedAt())
                && Objects.equals(healthStatus(), other.healthStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingViewElement").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingViewType", billingViewTypeAsString()).add("OwnerAccountId", ownerAccountId())
                .add("SourceAccountId", sourceAccountId()).add("DataFilterExpression", dataFilterExpression())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("DerivedViewCount", derivedViewCount())
                .add("SourceViewCount", sourceViewCount()).add("ViewDefinitionLastUpdatedAt", viewDefinitionLastUpdatedAt())
                .add("HealthStatus", healthStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "billingViewType":
            return Optional.ofNullable(clazz.cast(billingViewTypeAsString()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "sourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "dataFilterExpression":
            return Optional.ofNullable(clazz.cast(dataFilterExpression()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "derivedViewCount":
            return Optional.ofNullable(clazz.cast(derivedViewCount()));
        case "sourceViewCount":
            return Optional.ofNullable(clazz.cast(sourceViewCount()));
        case "viewDefinitionLastUpdatedAt":
            return Optional.ofNullable(clazz.cast(viewDefinitionLastUpdatedAt()));
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("billingViewType", BILLING_VIEW_TYPE_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("sourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("dataFilterExpression", DATA_FILTER_EXPRESSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("derivedViewCount", DERIVED_VIEW_COUNT_FIELD);
        map.put("sourceViewCount", SOURCE_VIEW_COUNT_FIELD);
        map.put("viewDefinitionLastUpdatedAt", VIEW_DEFINITION_LAST_UPDATED_AT_FIELD);
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingViewElement, T> g) {
        return obj -> g.apply((BillingViewElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingViewElement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The account name of the billing view.
         * </p>
         * 
         * @param name
         *        The account name of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the billing view.
         * </p>
         * 
         * @param description
         *        The description of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of billing group.
         * </p>
         * 
         * @param billingViewType
         *        The type of billing group.
         * @see BillingViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingViewType
         */
        Builder billingViewType(String billingViewType);

        /**
         * <p>
         * The type of billing group.
         * </p>
         * 
         * @param billingViewType
         *        The type of billing group.
         * @see BillingViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingViewType
         */
        Builder billingViewType(BillingViewType billingViewType);

        /**
         * <p>
         * The account owner of the billing view.
         * </p>
         * 
         * @param ownerAccountId
         *        The account owner of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
         * </p>
         * 
         * @param sourceAccountId
         *        The Amazon Web Services account ID that owns the source billing view, if this is a derived billing
         *        view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
         * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * </p>
         * 
         * @param dataFilterExpression
         *        See <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html"
         *        >Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFilterExpression(Expression dataFilterExpression);

        /**
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
         * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #dataFilterExpression(Expression)}.
         * 
         * @param dataFilterExpression
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataFilterExpression(Expression)
         */
        default Builder dataFilterExpression(Consumer<Expression.Builder> dataFilterExpression) {
            return dataFilterExpression(Expression.builder().applyMutation(dataFilterExpression).build());
        }

        /**
         * <p>
         * The time when the billing view was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the billing view was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the billing view was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time when the billing view was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The number of billing views that use this billing view as a source.
         * </p>
         * 
         * @param derivedViewCount
         *        The number of billing views that use this billing view as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder derivedViewCount(Integer derivedViewCount);

        /**
         * <p>
         * The number of source views associated with this billing view.
         * </p>
         * 
         * @param sourceViewCount
         *        The number of source views associated with this billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceViewCount(Integer sourceViewCount);

        /**
         * <p>
         * The timestamp of when the billing view definition was last updated.
         * </p>
         * 
         * @param viewDefinitionLastUpdatedAt
         *        The timestamp of when the billing view definition was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewDefinitionLastUpdatedAt(Instant viewDefinitionLastUpdatedAt);

        /**
         * <p>
         * The current health status of the billing view.
         * </p>
         * 
         * @param healthStatus
         *        The current health status of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(BillingViewHealthStatus healthStatus);

        /**
         * <p>
         * The current health status of the billing view.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingViewHealthStatus.Builder} avoiding
         * the need to create one manually via {@link BillingViewHealthStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillingViewHealthStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #healthStatus(BillingViewHealthStatus)}.
         * 
         * @param healthStatus
         *        a consumer that will call methods on {@link BillingViewHealthStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthStatus(BillingViewHealthStatus)
         */
        default Builder healthStatus(Consumer<BillingViewHealthStatus.Builder> healthStatus) {
            return healthStatus(BillingViewHealthStatus.builder().applyMutation(healthStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String billingViewType;

        private String ownerAccountId;

        private String sourceAccountId;

        private Expression dataFilterExpression;

        private Instant createdAt;

        private Instant updatedAt;

        private Integer derivedViewCount;

        private Integer sourceViewCount;

        private Instant viewDefinitionLastUpdatedAt;

        private BillingViewHealthStatus healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingViewElement model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            billingViewType(model.billingViewType);
            ownerAccountId(model.ownerAccountId);
            sourceAccountId(model.sourceAccountId);
            dataFilterExpression(model.dataFilterExpression);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            derivedViewCount(model.derivedViewCount);
            sourceViewCount(model.sourceViewCount);
            viewDefinitionLastUpdatedAt(model.viewDefinitionLastUpdatedAt);
            healthStatus(model.healthStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBillingViewType() {
            return billingViewType;
        }

        public final void setBillingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
        }

        @Override
        public final Builder billingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
            return this;
        }

        @Override
        public final Builder billingViewType(BillingViewType billingViewType) {
            this.billingViewType(billingViewType == null ? null : billingViewType.toString());
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final Expression.Builder getDataFilterExpression() {
            return dataFilterExpression != null ? dataFilterExpression.toBuilder() : null;
        }

        public final void setDataFilterExpression(Expression.BuilderImpl dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression != null ? dataFilterExpression.build() : null;
        }

        @Override
        public final Builder dataFilterExpression(Expression dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Integer getDerivedViewCount() {
            return derivedViewCount;
        }

        public final void setDerivedViewCount(Integer derivedViewCount) {
            this.derivedViewCount = derivedViewCount;
        }

        @Override
        public final Builder derivedViewCount(Integer derivedViewCount) {
            this.derivedViewCount = derivedViewCount;
            return this;
        }

        public final Integer getSourceViewCount() {
            return sourceViewCount;
        }

        public final void setSourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
        }

        @Override
        public final Builder sourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return this;
        }

        public final Instant getViewDefinitionLastUpdatedAt() {
            return viewDefinitionLastUpdatedAt;
        }

        public final void setViewDefinitionLastUpdatedAt(Instant viewDefinitionLastUpdatedAt) {
            this.viewDefinitionLastUpdatedAt = viewDefinitionLastUpdatedAt;
        }

        @Override
        public final Builder viewDefinitionLastUpdatedAt(Instant viewDefinitionLastUpdatedAt) {
            this.viewDefinitionLastUpdatedAt = viewDefinitionLastUpdatedAt;
            return this;
        }

        public final BillingViewHealthStatus.Builder getHealthStatus() {
            return healthStatus != null ? healthStatus.toBuilder() : null;
        }

        public final void setHealthStatus(BillingViewHealthStatus.BuilderImpl healthStatus) {
            this.healthStatus = healthStatus != null ? healthStatus.build() : null;
        }

        @Override
        public final Builder healthStatus(BillingViewHealthStatus healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public BillingViewElement build() {
            return new BillingViewElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
