/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a billing view.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingViewListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingViewListElement.Builder, BillingViewListElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(BillingViewListElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BillingViewListElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BillingViewListElement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(BillingViewListElement::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountId").getter(getter(BillingViewListElement::sourceAccountId))
            .setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()).build();

    private static final SdkField<String> BILLING_VIEW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingViewType").getter(getter(BillingViewListElement::billingViewTypeAsString))
            .setter(setter(Builder::billingViewType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViewType").build()).build();

    private static final SdkField<BillingViewHealthStatus> HEALTH_STATUS_FIELD = SdkField
            .<BillingViewHealthStatus> builder(MarshallingType.SDK_POJO).memberName("healthStatus")
            .getter(getter(BillingViewListElement::healthStatus)).setter(setter(Builder::healthStatus))
            .constructor(BillingViewHealthStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, OWNER_ACCOUNT_ID_FIELD, SOURCE_ACCOUNT_ID_FIELD, BILLING_VIEW_TYPE_FIELD, HEALTH_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String description;

    private final String ownerAccountId;

    private final String sourceAccountId;

    private final String billingViewType;

    private final BillingViewHealthStatus healthStatus;

    private BillingViewListElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.ownerAccountId = builder.ownerAccountId;
        this.sourceAccountId = builder.sourceAccountId;
        this.billingViewType = builder.billingViewType;
        this.healthStatus = builder.healthStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A list of names of the Billing view.
     * </p>
     * 
     * @return A list of names of the Billing view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the billing view.
     * </p>
     * 
     * @return The description of the billing view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The list of owners of the Billing view.
     * </p>
     * 
     * @return The list of owners of the Billing view.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * The type of billing view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingViewType}
     * will return {@link BillingViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingViewTypeAsString}.
     * </p>
     * 
     * @return The type of billing view.
     * @see BillingViewType
     */
    public final BillingViewType billingViewType() {
        return BillingViewType.fromValue(billingViewType);
    }

    /**
     * <p>
     * The type of billing view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #billingViewType}
     * will return {@link BillingViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #billingViewTypeAsString}.
     * </p>
     * 
     * @return The type of billing view.
     * @see BillingViewType
     */
    public final String billingViewTypeAsString() {
        return billingViewType;
    }

    /**
     * <p>
     * The current health status of the billing view.
     * </p>
     * 
     * @return The current health status of the billing view.
     */
    public final BillingViewHealthStatus healthStatus() {
        return healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(billingViewTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(healthStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingViewListElement)) {
            return false;
        }
        BillingViewListElement other = (BillingViewListElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(sourceAccountId(), other.sourceAccountId())
                && Objects.equals(billingViewTypeAsString(), other.billingViewTypeAsString())
                && Objects.equals(healthStatus(), other.healthStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingViewListElement").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwnerAccountId", ownerAccountId()).add("SourceAccountId", sourceAccountId())
                .add("BillingViewType", billingViewTypeAsString()).add("HealthStatus", healthStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "sourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "billingViewType":
            return Optional.ofNullable(clazz.cast(billingViewTypeAsString()));
        case "healthStatus":
            return Optional.ofNullable(clazz.cast(healthStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("sourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("billingViewType", BILLING_VIEW_TYPE_FIELD);
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingViewListElement, T> g) {
        return obj -> g.apply((BillingViewListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingViewListElement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of names of the Billing view.
         * </p>
         * 
         * @param name
         *        A list of names of the Billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the billing view.
         * </p>
         * 
         * @param description
         *        The description of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of owners of the Billing view.
         * </p>
         * 
         * @param ownerAccountId
         *        The list of owners of the Billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the source billing view, if this is a derived billing view.
         * </p>
         * 
         * @param sourceAccountId
         *        The Amazon Web Services account ID that owns the source billing view, if this is a derived billing
         *        view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewType
         *        The type of billing view.
         * @see BillingViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingViewType
         */
        Builder billingViewType(String billingViewType);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewType
         *        The type of billing view.
         * @see BillingViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingViewType
         */
        Builder billingViewType(BillingViewType billingViewType);

        /**
         * <p>
         * The current health status of the billing view.
         * </p>
         * 
         * @param healthStatus
         *        The current health status of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(BillingViewHealthStatus healthStatus);

        /**
         * <p>
         * The current health status of the billing view.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingViewHealthStatus.Builder} avoiding
         * the need to create one manually via {@link BillingViewHealthStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillingViewHealthStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #healthStatus(BillingViewHealthStatus)}.
         * 
         * @param healthStatus
         *        a consumer that will call methods on {@link BillingViewHealthStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthStatus(BillingViewHealthStatus)
         */
        default Builder healthStatus(Consumer<BillingViewHealthStatus.Builder> healthStatus) {
            return healthStatus(BillingViewHealthStatus.builder().applyMutation(healthStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String ownerAccountId;

        private String sourceAccountId;

        private String billingViewType;

        private BillingViewHealthStatus healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingViewListElement model) {
            arn(model.arn);
            name(model.name);
            description(model.description);
            ownerAccountId(model.ownerAccountId);
            sourceAccountId(model.sourceAccountId);
            billingViewType(model.billingViewType);
            healthStatus(model.healthStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getBillingViewType() {
            return billingViewType;
        }

        public final void setBillingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
        }

        @Override
        public final Builder billingViewType(String billingViewType) {
            this.billingViewType = billingViewType;
            return this;
        }

        @Override
        public final Builder billingViewType(BillingViewType billingViewType) {
            this.billingViewType(billingViewType == null ? null : billingViewType.toString());
            return this;
        }

        public final BillingViewHealthStatus.Builder getHealthStatus() {
            return healthStatus != null ? healthStatus.toBuilder() : null;
        }

        public final void setHealthStatus(BillingViewHealthStatus.BuilderImpl healthStatus) {
            this.healthStatus = healthStatus != null ? healthStatus.build() : null;
        }

        @Override
        public final Builder healthStatus(BillingViewHealthStatus healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public BillingViewListElement build() {
            return new BillingViewListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
