/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * See <a
 * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">Expression
 * </a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Expression implements SdkPojo, Serializable, ToCopyableBuilder<Expression.Builder, Expression> {
    private static final SdkField<DimensionValues> DIMENSIONS_FIELD = SdkField
            .<DimensionValues> builder(MarshallingType.SDK_POJO).memberName("dimensions").getter(getter(Expression::dimensions))
            .setter(setter(Builder::dimensions)).constructor(DimensionValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()).build();

    private static final SdkField<TagValues> TAGS_FIELD = SdkField.<TagValues> builder(MarshallingType.SDK_POJO)
            .memberName("tags").getter(getter(Expression::tags)).setter(setter(Builder::tags)).constructor(TagValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()).build();

    private static final SdkField<TimeRange> TIME_RANGE_FIELD = SdkField.<TimeRange> builder(MarshallingType.SDK_POJO)
            .memberName("timeRange").getter(getter(Expression::timeRange)).setter(setter(Builder::timeRange))
            .constructor(TimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, TAGS_FIELD,
            TIME_RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DimensionValues dimensions;

    private final TagValues tags;

    private final TimeRange timeRange;

    private Expression(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.tags = builder.tags;
        this.timeRange = builder.timeRange;
    }

    /**
     * <p>
     * The specific <code>Dimension</code> to use for <code>Expression</code>.
     * </p>
     * 
     * @return The specific <code>Dimension</code> to use for <code>Expression</code>.
     */
    public final DimensionValues dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The specific <code>Tag</code> to use for <code>Expression</code>.
     * </p>
     * 
     * @return The specific <code>Tag</code> to use for <code>Expression</code>.
     */
    public final TagValues tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies a time range filter for the billing view data.
     * </p>
     * 
     * @return Specifies a time range filter for the billing view data.
     */
    public final TimeRange timeRange() {
        return timeRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression) obj;
        return Objects.equals(dimensions(), other.dimensions()) && Objects.equals(tags(), other.tags())
                && Objects.equals(timeRange(), other.timeRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Expression").add("Dimensions", dimensions()).add("Tags", tags()).add("TimeRange", timeRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "timeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("timeRange", TIME_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Expression> {
        /**
         * <p>
         * The specific <code>Dimension</code> to use for <code>Expression</code>.
         * </p>
         * 
         * @param dimensions
         *        The specific <code>Dimension</code> to use for <code>Expression</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(DimensionValues dimensions);

        /**
         * <p>
         * The specific <code>Dimension</code> to use for <code>Expression</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DimensionValues.Builder} avoiding the
         * need to create one manually via {@link DimensionValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DimensionValues.Builder#build()} is called immediately and its
         * result is passed to {@link #dimensions(DimensionValues)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on {@link DimensionValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(DimensionValues)
         */
        default Builder dimensions(Consumer<DimensionValues.Builder> dimensions) {
            return dimensions(DimensionValues.builder().applyMutation(dimensions).build());
        }

        /**
         * <p>
         * The specific <code>Tag</code> to use for <code>Expression</code>.
         * </p>
         * 
         * @param tags
         *        The specific <code>Tag</code> to use for <code>Expression</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagValues tags);

        /**
         * <p>
         * The specific <code>Tag</code> to use for <code>Expression</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagValues.Builder} avoiding the need to
         * create one manually via {@link TagValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagValues.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(TagValues)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link TagValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(TagValues)
         */
        default Builder tags(Consumer<TagValues.Builder> tags) {
            return tags(TagValues.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * Specifies a time range filter for the billing view data.
         * </p>
         * 
         * @param timeRange
         *        Specifies a time range filter for the billing view data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(TimeRange timeRange);

        /**
         * <p>
         * Specifies a time range filter for the billing view data.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRange.Builder} avoiding the need to
         * create one manually via {@link TimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRange.Builder#build()} is called immediately and its result
         * is passed to {@link #timeRange(TimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link TimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(TimeRange)
         */
        default Builder timeRange(Consumer<TimeRange.Builder> timeRange) {
            return timeRange(TimeRange.builder().applyMutation(timeRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DimensionValues dimensions;

        private TagValues tags;

        private TimeRange timeRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            dimensions(model.dimensions);
            tags(model.tags);
            timeRange(model.timeRange);
        }

        public final DimensionValues.Builder getDimensions() {
            return dimensions != null ? dimensions.toBuilder() : null;
        }

        public final void setDimensions(DimensionValues.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(DimensionValues dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final TagValues.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(TagValues.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(TagValues tags) {
            this.tags = tags;
            return this;
        }

        public final TimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(TimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(TimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        @Override
        public Expression build() {
            return new Expression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
