/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillingViewsRequest extends BillingRequest implements
        ToCopyableBuilder<ListBillingViewsRequest.Builder, ListBillingViewsRequest> {
    private static final SdkField<ActiveTimeRange> ACTIVE_TIME_RANGE_FIELD = SdkField
            .<ActiveTimeRange> builder(MarshallingType.SDK_POJO).memberName("activeTimeRange")
            .getter(getter(ListBillingViewsRequest::activeTimeRange)).setter(setter(Builder::activeTimeRange))
            .constructor(ActiveTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeTimeRange").build()).build();

    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("arns")
            .getter(getter(ListBillingViewsRequest::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BILLING_VIEW_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("billingViewTypes")
            .getter(getter(ListBillingViewsRequest::billingViewTypesAsStrings))
            .setter(setter(Builder::billingViewTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingViewTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccountId").getter(getter(ListBillingViewsRequest::ownerAccountId))
            .setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccountId").build()).build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountId").getter(getter(ListBillingViewsRequest::sourceAccountId))
            .setter(setter(Builder::sourceAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBillingViewsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBillingViewsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_TIME_RANGE_FIELD,
            ARNS_FIELD, BILLING_VIEW_TYPES_FIELD, OWNER_ACCOUNT_ID_FIELD, SOURCE_ACCOUNT_ID_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ActiveTimeRange activeTimeRange;

    private final List<String> arns;

    private final List<String> billingViewTypes;

    private final String ownerAccountId;

    private final String sourceAccountId;

    private final Integer maxResults;

    private final String nextToken;

    private ListBillingViewsRequest(BuilderImpl builder) {
        super(builder);
        this.activeTimeRange = builder.activeTimeRange;
        this.arns = builder.arns;
        this.billingViewTypes = builder.billingViewTypes;
        this.ownerAccountId = builder.ownerAccountId;
        this.sourceAccountId = builder.sourceAccountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The time range for the billing views listed. <code>PRIMARY</code> billing view is always listed.
     * <code>BILLING_GROUP</code> billing views are listed for time ranges when the associated billing group resource in
     * Billing Conductor is active. The time range must be within one calendar month.
     * </p>
     * 
     * @return The time range for the billing views listed. <code>PRIMARY</code> billing view is always listed.
     *         <code>BILLING_GROUP</code> billing views are listed for time ranges when the associated billing group
     *         resource in Billing Conductor is active. The time range must be within one calendar month.
     */
    public final ActiveTimeRange activeTimeRange() {
        return activeTimeRange;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     */
    public final List<String> arns() {
        return arns;
    }

    /**
     * <p>
     * The type of billing view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingViewTypes} method.
     * </p>
     * 
     * @return The type of billing view.
     */
    public final List<BillingViewType> billingViewTypes() {
        return BillingViewTypeListCopier.copyStringToEnum(billingViewTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the BillingViewTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillingViewTypes() {
        return billingViewTypes != null && !(billingViewTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of billing view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingViewTypes} method.
     * </p>
     * 
     * @return The type of billing view.
     */
    public final List<String> billingViewTypesAsStrings() {
        return billingViewTypes;
    }

    /**
     * <p>
     * The list of owners of the billing view.
     * </p>
     * 
     * @return The list of owners of the billing view.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * Filters the results to include only billing views that use the specified account as a source.
     * </p>
     * 
     * @return Filters the results to include only billing views that use the specified account as a source.
     */
    public final String sourceAccountId() {
        return sourceAccountId;
    }

    /**
     * <p>
     * The maximum number of billing views to retrieve. Default is 100.
     * </p>
     * 
     * @return The maximum number of billing views to retrieve. Default is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that is used on subsequent calls to list billing views.
     * </p>
     * 
     * @return The pagination token that is used on subsequent calls to list billing views.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activeTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasArns() ? arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBillingViewTypes() ? billingViewTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingViewsRequest)) {
            return false;
        }
        ListBillingViewsRequest other = (ListBillingViewsRequest) obj;
        return Objects.equals(activeTimeRange(), other.activeTimeRange()) && hasArns() == other.hasArns()
                && Objects.equals(arns(), other.arns()) && hasBillingViewTypes() == other.hasBillingViewTypes()
                && Objects.equals(billingViewTypesAsStrings(), other.billingViewTypesAsStrings())
                && Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(sourceAccountId(), other.sourceAccountId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillingViewsRequest").add("ActiveTimeRange", activeTimeRange())
                .add("Arns", hasArns() ? arns() : null)
                .add("BillingViewTypes", hasBillingViewTypes() ? billingViewTypesAsStrings() : null)
                .add("OwnerAccountId", ownerAccountId()).add("SourceAccountId", sourceAccountId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "activeTimeRange":
            return Optional.ofNullable(clazz.cast(activeTimeRange()));
        case "arns":
            return Optional.ofNullable(clazz.cast(arns()));
        case "billingViewTypes":
            return Optional.ofNullable(clazz.cast(billingViewTypesAsStrings()));
        case "ownerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "sourceAccountId":
            return Optional.ofNullable(clazz.cast(sourceAccountId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("activeTimeRange", ACTIVE_TIME_RANGE_FIELD);
        map.put("arns", ARNS_FIELD);
        map.put("billingViewTypes", BILLING_VIEW_TYPES_FIELD);
        map.put("ownerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("sourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillingViewsRequest, T> g) {
        return obj -> g.apply((ListBillingViewsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBillingViewsRequest> {
        /**
         * <p>
         * The time range for the billing views listed. <code>PRIMARY</code> billing view is always listed.
         * <code>BILLING_GROUP</code> billing views are listed for time ranges when the associated billing group
         * resource in Billing Conductor is active. The time range must be within one calendar month.
         * </p>
         * 
         * @param activeTimeRange
         *        The time range for the billing views listed. <code>PRIMARY</code> billing view is always listed.
         *        <code>BILLING_GROUP</code> billing views are listed for time ranges when the associated billing group
         *        resource in Billing Conductor is active. The time range must be within one calendar month.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTimeRange(ActiveTimeRange activeTimeRange);

        /**
         * <p>
         * The time range for the billing views listed. <code>PRIMARY</code> billing view is always listed.
         * <code>BILLING_GROUP</code> billing views are listed for time ranges when the associated billing group
         * resource in Billing Conductor is active. The time range must be within one calendar month.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveTimeRange.Builder} avoiding the
         * need to create one manually via {@link ActiveTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #activeTimeRange(ActiveTimeRange)}.
         * 
         * @param activeTimeRange
         *        a consumer that will call methods on {@link ActiveTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeTimeRange(ActiveTimeRange)
         */
        default Builder activeTimeRange(Consumer<ActiveTimeRange.Builder> activeTimeRange) {
            return activeTimeRange(ActiveTimeRange.builder().applyMutation(activeTimeRange).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * </p>
         * 
         * @param arns
         *        The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * </p>
         * 
         * @param arns
         *        The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewTypes
         *        The type of billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewTypesWithStrings(Collection<String> billingViewTypes);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewTypes
         *        The type of billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewTypesWithStrings(String... billingViewTypes);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewTypes
         *        The type of billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewTypes(Collection<BillingViewType> billingViewTypes);

        /**
         * <p>
         * The type of billing view.
         * </p>
         * 
         * @param billingViewTypes
         *        The type of billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingViewTypes(BillingViewType... billingViewTypes);

        /**
         * <p>
         * The list of owners of the billing view.
         * </p>
         * 
         * @param ownerAccountId
         *        The list of owners of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * Filters the results to include only billing views that use the specified account as a source.
         * </p>
         * 
         * @param sourceAccountId
         *        Filters the results to include only billing views that use the specified account as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountId(String sourceAccountId);

        /**
         * <p>
         * The maximum number of billing views to retrieve. Default is 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of billing views to retrieve. Default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that is used on subsequent calls to list billing views.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that is used on subsequent calls to list billing views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingRequest.BuilderImpl implements Builder {
        private ActiveTimeRange activeTimeRange;

        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private List<String> billingViewTypes = DefaultSdkAutoConstructList.getInstance();

        private String ownerAccountId;

        private String sourceAccountId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingViewsRequest model) {
            super(model);
            activeTimeRange(model.activeTimeRange);
            arns(model.arns);
            billingViewTypesWithStrings(model.billingViewTypes);
            ownerAccountId(model.ownerAccountId);
            sourceAccountId(model.sourceAccountId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final ActiveTimeRange.Builder getActiveTimeRange() {
            return activeTimeRange != null ? activeTimeRange.toBuilder() : null;
        }

        public final void setActiveTimeRange(ActiveTimeRange.BuilderImpl activeTimeRange) {
            this.activeTimeRange = activeTimeRange != null ? activeTimeRange.build() : null;
        }

        @Override
        public final Builder activeTimeRange(ActiveTimeRange activeTimeRange) {
            this.activeTimeRange = activeTimeRange;
            return this;
        }

        public final Collection<String> getArns() {
            if (arns instanceof SdkAutoConstructList) {
                return null;
            }
            return arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = BillingViewArnListCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = BillingViewArnListCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        public final Collection<String> getBillingViewTypes() {
            if (billingViewTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return billingViewTypes;
        }

        public final void setBillingViewTypes(Collection<String> billingViewTypes) {
            this.billingViewTypes = BillingViewTypeListCopier.copy(billingViewTypes);
        }

        @Override
        public final Builder billingViewTypesWithStrings(Collection<String> billingViewTypes) {
            this.billingViewTypes = BillingViewTypeListCopier.copy(billingViewTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingViewTypesWithStrings(String... billingViewTypes) {
            billingViewTypesWithStrings(Arrays.asList(billingViewTypes));
            return this;
        }

        @Override
        public final Builder billingViewTypes(Collection<BillingViewType> billingViewTypes) {
            this.billingViewTypes = BillingViewTypeListCopier.copyEnumToString(billingViewTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingViewTypes(BillingViewType... billingViewTypes) {
            billingViewTypes(Arrays.asList(billingViewTypes));
            return this;
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getSourceAccountId() {
            return sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBillingViewsRequest build() {
            return new ListBillingViewsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
