/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSourceViewsForBillingViewResponse extends BillingResponse implements
        ToCopyableBuilder<ListSourceViewsForBillingViewResponse.Builder, ListSourceViewsForBillingViewResponse> {
    private static final SdkField<List<String>> SOURCE_VIEWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceViews")
            .getter(getter(ListSourceViewsForBillingViewResponse::sourceViews))
            .setter(setter(Builder::sourceViews))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceViews").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSourceViewsForBillingViewResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VIEWS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> sourceViews;

    private final String nextToken;

    private ListSourceViewsForBillingViewResponse(BuilderImpl builder) {
        super(builder);
        this.sourceViews = builder.sourceViews;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceViews property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceViews() {
        return sourceViews != null && !(sourceViews instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of billing views used as the data source for the custom billing view.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceViews} method.
     * </p>
     * 
     * @return A list of billing views used as the data source for the custom billing view.
     */
    public final List<String> sourceViews() {
        return sourceViews;
    }

    /**
     * <p>
     * The pagination token that is used on subsequent calls to list billing views.
     * </p>
     * 
     * @return The pagination token that is used on subsequent calls to list billing views.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceViews() ? sourceViews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceViewsForBillingViewResponse)) {
            return false;
        }
        ListSourceViewsForBillingViewResponse other = (ListSourceViewsForBillingViewResponse) obj;
        return hasSourceViews() == other.hasSourceViews() && Objects.equals(sourceViews(), other.sourceViews())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSourceViewsForBillingViewResponse")
                .add("SourceViews", hasSourceViews() ? sourceViews() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceViews":
            return Optional.ofNullable(clazz.cast(sourceViews()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceViews", SOURCE_VIEWS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSourceViewsForBillingViewResponse, T> g) {
        return obj -> g.apply((ListSourceViewsForBillingViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSourceViewsForBillingViewResponse> {
        /**
         * <p>
         * A list of billing views used as the data source for the custom billing view.
         * </p>
         * 
         * @param sourceViews
         *        A list of billing views used as the data source for the custom billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceViews(Collection<String> sourceViews);

        /**
         * <p>
         * A list of billing views used as the data source for the custom billing view.
         * </p>
         * 
         * @param sourceViews
         *        A list of billing views used as the data source for the custom billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceViews(String... sourceViews);

        /**
         * <p>
         * The pagination token that is used on subsequent calls to list billing views.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that is used on subsequent calls to list billing views.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingResponse.BuilderImpl implements Builder {
        private List<String> sourceViews = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceViewsForBillingViewResponse model) {
            super(model);
            sourceViews(model.sourceViews);
            nextToken(model.nextToken);
        }

        public final Collection<String> getSourceViews() {
            if (sourceViews instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceViews;
        }

        public final void setSourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
        }

        @Override
        public final Builder sourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceViews(String... sourceViews) {
            sourceViews(Arrays.asList(sourceViews));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSourceViewsForBillingViewResponse build() {
            return new ListSourceViewsForBillingViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
