/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a time range with inclusive begin and end dates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeRange implements SdkPojo, Serializable, ToCopyableBuilder<TimeRange.Builder, TimeRange> {
    private static final SdkField<Instant> BEGIN_DATE_INCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("beginDateInclusive").getter(getter(TimeRange::beginDateInclusive))
            .setter(setter(Builder::beginDateInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beginDateInclusive").build())
            .build();

    private static final SdkField<Instant> END_DATE_INCLUSIVE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDateInclusive").getter(getter(TimeRange::endDateInclusive)).setter(setter(Builder::endDateInclusive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateInclusive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_DATE_INCLUSIVE_FIELD,
            END_DATE_INCLUSIVE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant beginDateInclusive;

    private final Instant endDateInclusive;

    private TimeRange(BuilderImpl builder) {
        this.beginDateInclusive = builder.beginDateInclusive;
        this.endDateInclusive = builder.endDateInclusive;
    }

    /**
     * <p>
     * The inclusive start date of the time range.
     * </p>
     * 
     * @return The inclusive start date of the time range.
     */
    public final Instant beginDateInclusive() {
        return beginDateInclusive;
    }

    /**
     * <p>
     * The inclusive end date of the time range.
     * </p>
     * 
     * @return The inclusive end date of the time range.
     */
    public final Instant endDateInclusive() {
        return endDateInclusive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginDateInclusive());
        hashCode = 31 * hashCode + Objects.hashCode(endDateInclusive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRange)) {
            return false;
        }
        TimeRange other = (TimeRange) obj;
        return Objects.equals(beginDateInclusive(), other.beginDateInclusive())
                && Objects.equals(endDateInclusive(), other.endDateInclusive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeRange").add("BeginDateInclusive", beginDateInclusive())
                .add("EndDateInclusive", endDateInclusive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "beginDateInclusive":
            return Optional.ofNullable(clazz.cast(beginDateInclusive()));
        case "endDateInclusive":
            return Optional.ofNullable(clazz.cast(endDateInclusive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("beginDateInclusive", BEGIN_DATE_INCLUSIVE_FIELD);
        map.put("endDateInclusive", END_DATE_INCLUSIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeRange, T> g) {
        return obj -> g.apply((TimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeRange> {
        /**
         * <p>
         * The inclusive start date of the time range.
         * </p>
         * 
         * @param beginDateInclusive
         *        The inclusive start date of the time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginDateInclusive(Instant beginDateInclusive);

        /**
         * <p>
         * The inclusive end date of the time range.
         * </p>
         * 
         * @param endDateInclusive
         *        The inclusive end date of the time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateInclusive(Instant endDateInclusive);
    }

    static final class BuilderImpl implements Builder {
        private Instant beginDateInclusive;

        private Instant endDateInclusive;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRange model) {
            beginDateInclusive(model.beginDateInclusive);
            endDateInclusive(model.endDateInclusive);
        }

        public final Instant getBeginDateInclusive() {
            return beginDateInclusive;
        }

        public final void setBeginDateInclusive(Instant beginDateInclusive) {
            this.beginDateInclusive = beginDateInclusive;
        }

        @Override
        public final Builder beginDateInclusive(Instant beginDateInclusive) {
            this.beginDateInclusive = beginDateInclusive;
            return this;
        }

        public final Instant getEndDateInclusive() {
            return endDateInclusive;
        }

        public final void setEndDateInclusive(Instant endDateInclusive) {
            this.endDateInclusive = endDateInclusive;
        }

        @Override
        public final Builder endDateInclusive(Instant endDateInclusive) {
            this.endDateInclusive = endDateInclusive;
            return this;
        }

        @Override
        public TimeRange build() {
            return new TimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
