/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillingViewRequest extends BillingRequest implements
        ToCopyableBuilder<UpdateBillingViewRequest.Builder, UpdateBillingViewRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateBillingViewRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateBillingViewRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBillingViewRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Expression> DATA_FILTER_EXPRESSION_FIELD = SdkField
            .<Expression> builder(MarshallingType.SDK_POJO).memberName("dataFilterExpression")
            .getter(getter(UpdateBillingViewRequest::dataFilterExpression)).setter(setter(Builder::dataFilterExpression))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFilterExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DATA_FILTER_EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String description;

    private final Expression dataFilterExpression;

    private UpdateBillingViewRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.dataFilterExpression = builder.dataFilterExpression;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the billing view.
     * </p>
     * 
     * @return The name of the billing view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the billing view.
     * </p>
     * 
     * @return The description of the billing view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * See <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
     * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
     * </p>
     * 
     * @return See <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html"
     *         >Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
     */
    public final Expression dataFilterExpression() {
        return dataFilterExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataFilterExpression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingViewRequest)) {
            return false;
        }
        UpdateBillingViewRequest other = (UpdateBillingViewRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(dataFilterExpression(), other.dataFilterExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBillingViewRequest").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DataFilterExpression", dataFilterExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dataFilterExpression":
            return Optional.ofNullable(clazz.cast(dataFilterExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dataFilterExpression", DATA_FILTER_EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingViewRequest, T> g) {
        return obj -> g.apply((UpdateBillingViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BillingRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBillingViewRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) that can be used to uniquely identify the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the billing view.
         * </p>
         * 
         * @param name
         *        The name of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the billing view.
         * </p>
         * 
         * @param description
         *        The description of the billing view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
         * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * </p>
         * 
         * @param dataFilterExpression
         *        See <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html"
         *        >Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFilterExpression(Expression dataFilterExpression);

        /**
         * <p>
         * See <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html">
         * Expression</a>. Billing view only supports <code>LINKED_ACCOUNT</code> and <code>Tags</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #dataFilterExpression(Expression)}.
         * 
         * @param dataFilterExpression
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataFilterExpression(Expression)
         */
        default Builder dataFilterExpression(Consumer<Expression.Builder> dataFilterExpression) {
            return dataFilterExpression(Expression.builder().applyMutation(dataFilterExpression).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private Expression dataFilterExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingViewRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            dataFilterExpression(model.dataFilterExpression);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Expression.Builder getDataFilterExpression() {
            return dataFilterExpression != null ? dataFilterExpression.toBuilder() : null;
        }

        public final void setDataFilterExpression(Expression.BuilderImpl dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression != null ? dataFilterExpression.build() : null;
        }

        @Override
        public final Builder dataFilterExpression(Expression dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillingViewRequest build() {
            return new UpdateBillingViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
