/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.billingconductor.model.AccessDeniedException;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.AssociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchAssociateResourcesToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.BatchDisassociateResourcesFromCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorException;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorRequest;
import software.amazon.awssdk.services.billingconductor.model.ConflictException;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.CreateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.CreatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.DeleteCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.DeletePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociateAccountsResponse;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.DisassociatePricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.InternalServerException;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.billingconductor.model.ServiceLimitExceededException;
import software.amazon.awssdk.services.billingconductor.model.TagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.TagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.ThrottlingException;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceRequest;
import software.amazon.awssdk.services.billingconductor.model.UntagResourceResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdateCustomLineItemResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleRequest;
import software.amazon.awssdk.services.billingconductor.model.UpdatePricingRuleResponse;
import software.amazon.awssdk.services.billingconductor.model.ValidationException;
import software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable;
import software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable;
import software.amazon.awssdk.services.billingconductor.transform.AssociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.AssociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchAssociateResourcesToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.BatchDisassociateResourcesFromCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.CreatePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeleteCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DeletePricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociateAccountsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.DisassociatePricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListAccountAssociationsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupCostReportsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListCustomLineItemsRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansAssociatedWithPricingRuleRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingPlansRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesAssociatedToPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListPricingRulesRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListResourcesAssociatedToCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdateCustomLineItemRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.billingconductor.transform.UpdatePricingRuleRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link BillingconductorClient}.
 *
 * @see BillingconductorClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultBillingconductorClient implements BillingconductorClient {
    private static final Logger log = Logger.loggerFor(DefaultBillingconductorClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBillingconductorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Connects an array of account IDs in a consolidated billing family to a predefined billing group. The account IDs
     * must be a part of the consolidated billing family during the current month, and not already associated with
     * another billing group. The maximum number of accounts that can be associated in one call is 30.
     * </p>
     *
     * @param associateAccountsRequest
     * @return Result of the AssociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateAccountsResponse associateAccounts(AssociateAccountsRequest associateAccountsRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateAccountsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateAccountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAccounts");

            return clientHandler.execute(new ClientExecutionParams<AssociateAccountsRequest, AssociateAccountsResponse>()
                    .withOperationName("AssociateAccounts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateAccountsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateAccountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Connects an array of <code>PricingRuleArns</code> to a defined <code>PricingPlan</code>. The maximum number
     * <code>PricingRuleArn</code> that can be associated in one call is 30.
     * </p>
     *
     * @param associatePricingRulesRequest
     * @return Result of the AssociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.AssociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/AssociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociatePricingRulesResponse associatePricingRules(AssociatePricingRulesRequest associatePricingRulesRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociatePricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociatePricingRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePricingRules");

            return clientHandler.execute(new ClientExecutionParams<AssociatePricingRulesRequest, AssociatePricingRulesResponse>()
                    .withOperationName("AssociatePricingRules").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associatePricingRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociatePricingRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a batch of resources to a percentage custom line item.
     * </p>
     *
     * @param batchAssociateResourcesToCustomLineItemRequest
     * @return Result of the BatchAssociateResourcesToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchAssociateResourcesToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchAssociateResourcesToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateResourcesToCustomLineItemResponse batchAssociateResourcesToCustomLineItem(
            BatchAssociateResourcesToCustomLineItemRequest batchAssociateResourcesToCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateResourcesToCustomLineItemResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchAssociateResourcesToCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateResourcesToCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateResourcesToCustomLineItem");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateResourcesToCustomLineItemRequest, BatchAssociateResourcesToCustomLineItemResponse>()
                            .withOperationName("BatchAssociateResourcesToCustomLineItem").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchAssociateResourcesToCustomLineItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchAssociateResourcesToCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a batch of resources from a percentage custom line item.
     * </p>
     *
     * @param batchDisassociateResourcesFromCustomLineItemRequest
     * @return Result of the BatchDisassociateResourcesFromCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.BatchDisassociateResourcesFromCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/BatchDisassociateResourcesFromCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateResourcesFromCustomLineItemResponse batchDisassociateResourcesFromCustomLineItem(
            BatchDisassociateResourcesFromCustomLineItemRequest batchDisassociateResourcesFromCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateResourcesFromCustomLineItemResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDisassociateResourcesFromCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateResourcesFromCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateResourcesFromCustomLineItem");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateResourcesFromCustomLineItemRequest, BatchDisassociateResourcesFromCustomLineItemResponse>()
                            .withOperationName("BatchDisassociateResourcesFromCustomLineItem")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(batchDisassociateResourcesFromCustomLineItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDisassociateResourcesFromCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off
     * of the predefined pricing plan computation.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateBillingGroupRequest, CreateBillingGroupResponse>()
                    .withOperationName("CreateBillingGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom line item that can be used to create a one-time fixed charge that can be applied to a single
     * billing group for the current or previous billing period. The one-time fixed charge is either a fee or discount.
     * </p>
     *
     * @param createCustomLineItemRequest
     * @return Result of the CreateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomLineItemResponse createCustomLineItem(CreateCustomLineItemRequest createCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomLineItem");

            return clientHandler.execute(new ClientExecutionParams<CreateCustomLineItemRequest, CreateCustomLineItemResponse>()
                    .withOperationName("CreateCustomLineItem").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createCustomLineItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pricing plan that is used for computing Amazon Web Services charges for billing groups.
     * </p>
     *
     * @param createPricingPlanRequest
     * @return Result of the CreatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePricingPlanResponse createPricingPlan(CreatePricingPlanRequest createPricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePricingPlan");

            return clientHandler.execute(new ClientExecutionParams<CreatePricingPlanRequest, CreatePricingPlanResponse>()
                    .withOperationName("CreatePricingPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPricingPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pricing rule can be associated to a pricing plan, or a set of pricing plans.
     * </p>
     *
     * @param createPricingRuleRequest
     * @return Result of the CreatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws ServiceLimitExceededException
     *         The request would cause a service limit to exceed.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.CreatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/CreatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePricingRuleResponse createPricingRule(CreatePricingRuleRequest createPricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException,
            ServiceLimitExceededException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePricingRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePricingRule");

            return clientHandler.execute(new ClientExecutionParams<CreatePricingRuleRequest, CreatePricingRuleResponse>()
                    .withOperationName("CreatePricingRule").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPricingRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePricingRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a billing group.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteBillingGroupRequest, DeleteBillingGroupResponse>()
                    .withOperationName("DeleteBillingGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the custom line item identified by the given ARN in the current, or previous billing period.
     * </p>
     *
     * @param deleteCustomLineItemRequest
     * @return Result of the DeleteCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeleteCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeleteCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomLineItemResponse deleteCustomLineItem(DeleteCustomLineItemRequest deleteCustomLineItemRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomLineItem");

            return clientHandler.execute(new ClientExecutionParams<DeleteCustomLineItemRequest, DeleteCustomLineItemResponse>()
                    .withOperationName("DeleteCustomLineItem").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomLineItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a pricing plan. The pricing plan must not be associated with any billing groups to delete successfully.
     * </p>
     *
     * @param deletePricingPlanRequest
     * @return Result of the DeletePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePricingPlanResponse deletePricingPlan(DeletePricingPlanRequest deletePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePricingPlan");

            return clientHandler.execute(new ClientExecutionParams<DeletePricingPlanRequest, DeletePricingPlanResponse>()
                    .withOperationName("DeletePricingPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePricingPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the pricing rule identified by the input Amazon Resource Name (ARN).
     * </p>
     *
     * @param deletePricingRuleRequest
     * @return Result of the DeletePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DeletePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DeletePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePricingRuleResponse deletePricingRule(DeletePricingRuleRequest deletePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePricingRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePricingRule");

            return clientHandler.execute(new ClientExecutionParams<DeletePricingRuleRequest, DeletePricingRuleResponse>()
                    .withOperationName("DeletePricingRule").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePricingRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePricingRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified list of account IDs from the given billing group.
     * </p>
     *
     * @param disassociateAccountsRequest
     * @return Result of the DisassociateAccounts operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociateAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociateAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateAccountsResponse disassociateAccounts(DisassociateAccountsRequest disassociateAccountsRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateAccountsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateAccountsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateAccountsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateAccounts");

            return clientHandler.execute(new ClientExecutionParams<DisassociateAccountsRequest, DisassociateAccountsResponse>()
                    .withOperationName("DisassociateAccounts").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(disassociateAccountsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateAccountsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a list of pricing rules from a pricing plan.
     * </p>
     *
     * @param disassociatePricingRulesRequest
     * @return Result of the DisassociatePricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.DisassociatePricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/DisassociatePricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociatePricingRulesResponse disassociatePricingRules(
            DisassociatePricingRulesRequest disassociatePricingRulesRequest) throws ThrottlingException, ConflictException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociatePricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociatePricingRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociatePricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociatePricingRules");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociatePricingRulesRequest, DisassociatePricingRulesResponse>()
                            .withOperationName("DisassociatePricingRules").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociatePricingRulesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociatePricingRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web
     * Services Billing Conductor is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group associated with the linked account.
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return Result of the ListAccountAssociations operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssociationsResponse listAccountAssociations(ListAccountAssociationsRequest listAccountAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAccountAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAccountAssociationsRequest, ListAccountAssociationsResponse>()
                            .withOperationName("ListAccountAssociations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAccountAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAccountAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <i> <b>Amazon Web Services Billing Conductor is in beta release and is subject to change. Your use of Amazon Web
     * Services Billing Conductor is subject to the Beta Service Participation terms of the <a
     * href="https://aws.amazon.com/service-terms/">Amazon Web Services Service Terms</a> (Section 1.10).</b> </i>
     * </p>
     * <p>
     * This is a paginated call to list linked accounts that are linked to the payer account for the specified time
     * period. If no information is provided, the current billing period is used. The response will optionally include
     * the billing group associated with the linked account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client
     *             .listAccountAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListAccountAssociationsIterable responses = client.listAccountAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAssociations(software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccountAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListAccountAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListAccountAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAccountAssociationsIterable listAccountAssociationsPaginator(
            ListAccountAssociationsRequest listAccountAssociationsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            BillingconductorException {
        return new ListAccountAssociationsIterable(this, applyPaginatorUserAgent(listAccountAssociationsRequest));
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return Result of the ListBillingGroupCostReports operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillingGroupCostReportsResponse listBillingGroupCostReports(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillingGroupCostReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBillingGroupCostReportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillingGroupCostReportsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillingGroupCostReports");

            return clientHandler
                    .execute(new ClientExecutionParams<ListBillingGroupCostReportsRequest, ListBillingGroupCostReportsResponse>()
                            .withOperationName("ListBillingGroupCostReports").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listBillingGroupCostReportsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListBillingGroupCostReportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A paginated call to retrieve a summary report of actual Amazon Web Services charges and the calculated Amazon Web
     * Services charges based on the associated pricing plan of a billing group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client
     *             .listBillingGroupCostReportsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupCostReportsIterable responses = client.listBillingGroupCostReportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroupCostReports(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupCostReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupCostReportsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroupCostReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroupCostReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillingGroupCostReportsIterable listBillingGroupCostReportsPaginator(
            ListBillingGroupCostReportsRequest listBillingGroupCostReportsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListBillingGroupCostReportsIterable(this, applyPaginatorUserAgent(listBillingGroupCostReportsRequest));
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillingGroupsResponse listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBillingGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillingGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillingGroups");

            return clientHandler.execute(new ClientExecutionParams<ListBillingGroupsRequest, ListBillingGroupsResponse>()
                    .withOperationName("ListBillingGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBillingGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBillingGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A paginated call to retrieve a list of billing groups for the given billing period. If you don't provide a
     * billing group, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.billingconductor.model.ListBillingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListBillingGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListBillingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBillingGroupsIterable listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListBillingGroupsIterable(this, applyPaginatorUserAgent(listBillingGroupsRequest));
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return Result of the ListCustomLineItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomLineItemsResponse listCustomLineItems(ListCustomLineItemsRequest listCustomLineItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomLineItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomLineItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomLineItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomLineItems");

            return clientHandler.execute(new ClientExecutionParams<ListCustomLineItemsRequest, ListCustomLineItemsResponse>()
                    .withOperationName("ListCustomLineItems").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listCustomLineItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCustomLineItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A paginated call to get a list of all custom line items (FFLIs) for the given billing period. If you don't
     * provide a billing period, the current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client
     *             .listCustomLineItemsPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListCustomLineItemsIterable responses = client.listCustomLineItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomLineItems(software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCustomLineItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListCustomLineItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListCustomLineItems"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomLineItemsIterable listCustomLineItemsPaginator(ListCustomLineItemsRequest listCustomLineItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListCustomLineItemsIterable(this, applyPaginatorUserAgent(listCustomLineItemsRequest));
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     *
     * @param listPricingPlansRequest
     * @return Result of the ListPricingPlans operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingPlansResponse listPricingPlans(ListPricingPlansRequest listPricingPlansRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPricingPlansResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPricingPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPricingPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingPlans");

            return clientHandler.execute(new ClientExecutionParams<ListPricingPlansRequest, ListPricingPlansResponse>()
                    .withOperationName("ListPricingPlans").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPricingPlansRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPricingPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A paginated call to get pricing plans for the given billing period. If you don't provide a billing period, the
     * current billing period is used.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client
     *             .listPricingPlansPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansIterable responses = client.listPricingPlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlans(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingPlansIterable listPricingPlansPaginator(ListPricingPlansRequest listPricingPlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListPricingPlansIterable(this, applyPaginatorUserAgent(listPricingPlansRequest));
    }

    /**
     * <p>
     * A list of the pricing plans associated with a pricing rule.
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return Result of the ListPricingPlansAssociatedWithPricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingPlansAssociatedWithPricingRuleResponse listPricingPlansAssociatedWithPricingRule(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPricingPlansAssociatedWithPricingRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListPricingPlansAssociatedWithPricingRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPricingPlansAssociatedWithPricingRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingPlansAssociatedWithPricingRule");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPricingPlansAssociatedWithPricingRuleRequest, ListPricingPlansAssociatedWithPricingRuleResponse>()
                            .withOperationName("ListPricingPlansAssociatedWithPricingRule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPricingPlansAssociatedWithPricingRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPricingPlansAssociatedWithPricingRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of the pricing plans associated with a pricing rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client
     *             .listPricingPlansAssociatedWithPricingRulePaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingPlansAssociatedWithPricingRuleIterable responses = client.listPricingPlansAssociatedWithPricingRulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingPlansAssociatedWithPricingRule(software.amazon.awssdk.services.billingconductor.model.ListPricingPlansAssociatedWithPricingRuleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingPlansAssociatedWithPricingRuleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingPlansAssociatedWithPricingRule
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingPlansAssociatedWithPricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingPlansAssociatedWithPricingRuleIterable listPricingPlansAssociatedWithPricingRulePaginator(
            ListPricingPlansAssociatedWithPricingRuleRequest listPricingPlansAssociatedWithPricingRuleRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingPlansAssociatedWithPricingRuleIterable(this,
                applyPaginatorUserAgent(listPricingPlansAssociatedWithPricingRuleRequest));
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     *
     * @param listPricingRulesRequest
     * @return Result of the ListPricingRules operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingRulesResponse listPricingRules(ListPricingRulesRequest listPricingRulesRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPricingRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPricingRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPricingRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingRules");

            return clientHandler.execute(new ClientExecutionParams<ListPricingRulesRequest, ListPricingRulesResponse>()
                    .withOperationName("ListPricingRules").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPricingRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPricingRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a pricing rule that can be associated to a pricing plan, or set of pricing plans.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client
     *             .listPricingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesIterable responses = client.listPricingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRules(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingRulesIterable listPricingRulesPaginator(ListPricingRulesRequest listPricingRulesRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, BillingconductorException {
        return new ListPricingRulesIterable(this, applyPaginatorUserAgent(listPricingRulesRequest));
    }

    /**
     * <p>
     * Lists the pricing rules associated with a pricing plan.
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return Result of the ListPricingRulesAssociatedToPricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingRulesAssociatedToPricingPlanResponse listPricingRulesAssociatedToPricingPlan(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPricingRulesAssociatedToPricingPlanResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListPricingRulesAssociatedToPricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPricingRulesAssociatedToPricingPlanRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPricingRulesAssociatedToPricingPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPricingRulesAssociatedToPricingPlanRequest, ListPricingRulesAssociatedToPricingPlanResponse>()
                            .withOperationName("ListPricingRulesAssociatedToPricingPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listPricingRulesAssociatedToPricingPlanRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPricingRulesAssociatedToPricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the pricing rules associated with a pricing plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client
     *             .listPricingRulesAssociatedToPricingPlanPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListPricingRulesAssociatedToPricingPlanIterable responses = client.listPricingRulesAssociatedToPricingPlanPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPricingRulesAssociatedToPricingPlan(software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPricingRulesAssociatedToPricingPlanRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListPricingRulesAssociatedToPricingPlan
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListPricingRulesAssociatedToPricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPricingRulesAssociatedToPricingPlanIterable listPricingRulesAssociatedToPricingPlanPaginator(
            ListPricingRulesAssociatedToPricingPlanRequest listPricingRulesAssociatedToPricingPlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListPricingRulesAssociatedToPricingPlanIterable(this,
                applyPaginatorUserAgent(listPricingRulesAssociatedToPricingPlanRequest));
    }

    /**
     * <p>
     * List the resources associated to a custom line item.
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return Result of the ListResourcesAssociatedToCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourcesAssociatedToCustomLineItemResponse listResourcesAssociatedToCustomLineItem(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourcesAssociatedToCustomLineItemResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListResourcesAssociatedToCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourcesAssociatedToCustomLineItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourcesAssociatedToCustomLineItem");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourcesAssociatedToCustomLineItemRequest, ListResourcesAssociatedToCustomLineItemResponse>()
                            .withOperationName("ListResourcesAssociatedToCustomLineItem").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourcesAssociatedToCustomLineItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourcesAssociatedToCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the resources associated to a custom line item.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client
     *             .listResourcesAssociatedToCustomLineItemPaginator(request);
     *     for (software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.billingconductor.paginators.ListResourcesAssociatedToCustomLineItemIterable responses = client.listResourcesAssociatedToCustomLineItemPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesAssociatedToCustomLineItem(software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesAssociatedToCustomLineItemRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListResourcesAssociatedToCustomLineItem
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListResourcesAssociatedToCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourcesAssociatedToCustomLineItemIterable listResourcesAssociatedToCustomLineItemPaginator(
            ListResourcesAssociatedToCustomLineItemRequest listResourcesAssociatedToCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        return new ListResourcesAssociatedToCustomLineItemIterable(this,
                applyPaginatorUserAgent(listResourcesAssociatedToCustomLineItemRequest));
    }

    /**
     * <p>
     * A list the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a
     * resource are not specified in the request parameters, they are not changed.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes specified tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This updates an existing billing group.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return Result of the UpdateBillingGroup operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateBillingGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateBillingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBillingGroupResponse updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateBillingGroupRequest, UpdateBillingGroupResponse>()
                    .withOperationName("UpdateBillingGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an existing custom line item in the current or previous billing period.
     * </p>
     *
     * @param updateCustomLineItemRequest
     * @return Result of the UpdateCustomLineItem operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdateCustomLineItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdateCustomLineItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCustomLineItemResponse updateCustomLineItem(UpdateCustomLineItemRequest updateCustomLineItemRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomLineItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCustomLineItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomLineItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomLineItem");

            return clientHandler.execute(new ClientExecutionParams<UpdateCustomLineItemRequest, UpdateCustomLineItemResponse>()
                    .withOperationName("UpdateCustomLineItem").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateCustomLineItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCustomLineItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This updates an existing pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingPlan");

            return clientHandler.execute(new ClientExecutionParams<UpdatePricingPlanRequest, UpdatePricingPlanResponse>()
                    .withOperationName("UpdatePricingPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePricingPlanRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing pricing rule.
     * </p>
     *
     * @param updatePricingRuleRequest
     * @return Result of the UpdatePricingRule operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ConflictException
     *         You can cause an inconsistent state by updating or deleting a resource.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ValidationException
     *         The input doesn't match with the constraints specified by Amazon Web Services services.
     * @throws InternalServerException
     *         An unexpected error occurred while processing a request.
     * @throws ResourceNotFoundException
     *         The request references a resource that doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BillingconductorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BillingconductorClient.UpdatePricingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/billingconductor-2021-07-30/UpdatePricingRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePricingRuleResponse updatePricingRule(UpdatePricingRuleRequest updatePricingRuleRequest)
            throws ThrottlingException, ConflictException, AccessDeniedException, ValidationException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, BillingconductorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePricingRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePricingRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "billingconductor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingRule");

            return clientHandler.execute(new ClientExecutionParams<UpdatePricingRuleRequest, UpdatePricingRuleResponse>()
                    .withOperationName("UpdatePricingRule").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePricingRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePricingRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(BillingconductorException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceLimitExceededException")
                                .exceptionBuilderSupplier(ServiceLimitExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BillingconductorRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
