/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateResourcesToCustomLineItemRequest extends BillingconductorRequest implements
        ToCopyableBuilder<BatchAssociateResourcesToCustomLineItemRequest.Builder, BatchAssociateResourcesToCustomLineItemRequest> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetArn").getter(getter(BatchAssociateResourcesToCustomLineItemRequest::targetArn))
            .setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArns")
            .getter(getter(BatchAssociateResourcesToCustomLineItemRequest::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField
            .<CustomLineItemBillingPeriodRange> builder(MarshallingType.SDK_POJO).memberName("BillingPeriodRange")
            .getter(getter(BatchAssociateResourcesToCustomLineItemRequest::billingPeriodRange))
            .setter(setter(Builder::billingPeriodRange)).constructor(CustomLineItemBillingPeriodRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            RESOURCE_ARNS_FIELD, BILLING_PERIOD_RANGE_FIELD));

    private final String targetArn;

    private final List<String> resourceArns;

    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private BatchAssociateResourcesToCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.resourceArns = builder.resourceArns;
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    /**
     * <p>
     * A percentage custom line item ARN to associate the resources to.
     * </p>
     * 
     * @return A percentage custom line item ARN to associate the resources to.
     */
    public final String targetArn() {
        return targetArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the ARNs of the resources to be associated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return A list containing the ARNs of the resources to be associated.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * Returns the value of the BillingPeriodRange property for this object.
     * 
     * @return The value of the BillingPeriodRange property for this object.
     */
    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriodRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourcesToCustomLineItemRequest)) {
            return false;
        }
        BatchAssociateResourcesToCustomLineItemRequest other = (BatchAssociateResourcesToCustomLineItemRequest) obj;
        return Objects.equals(targetArn(), other.targetArn()) && hasResourceArns() == other.hasResourceArns()
                && Objects.equals(resourceArns(), other.resourceArns())
                && Objects.equals(billingPeriodRange(), other.billingPeriodRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAssociateResourcesToCustomLineItemRequest").add("TargetArn", targetArn())
                .add("ResourceArns", hasResourceArns() ? resourceArns() : null).add("BillingPeriodRange", billingPeriodRange())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "ResourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "BillingPeriodRange":
            return Optional.ofNullable(clazz.cast(billingPeriodRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateResourcesToCustomLineItemRequest, T> g) {
        return obj -> g.apply((BatchAssociateResourcesToCustomLineItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemRequest> {
        /**
         * <p>
         * A percentage custom line item ARN to associate the resources to.
         * </p>
         * 
         * @param targetArn
         *        A percentage custom line item ARN to associate the resources to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * A list containing the ARNs of the resources to be associated.
         * </p>
         * 
         * @param resourceArns
         *        A list containing the ARNs of the resources to be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * A list containing the ARNs of the resources to be associated.
         * </p>
         * 
         * @param resourceArns
         *        A list containing the ARNs of the resources to be associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * Sets the value of the BillingPeriodRange property for this object.
         *
         * @param billingPeriodRange
         *        The new value for the BillingPeriodRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange);

        /**
         * Sets the value of the BillingPeriodRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomLineItemBillingPeriodRange.Builder}
         * avoiding the need to create one manually via {@link CustomLineItemBillingPeriodRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLineItemBillingPeriodRange.Builder#build()} is called
         * immediately and its result is passed to {@link #billingPeriodRange(CustomLineItemBillingPeriodRange)}.
         * 
         * @param billingPeriodRange
         *        a consumer that will call methods on {@link CustomLineItemBillingPeriodRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriodRange(CustomLineItemBillingPeriodRange)
         */
        default Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return billingPeriodRange(CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String targetArn;

        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateResourcesToCustomLineItemRequest model) {
            super(model);
            targetArn(model.targetArn);
            resourceArns(model.resourceArns);
            billingPeriodRange(model.billingPeriodRange);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = CustomLineItemBatchAssociationsListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = CustomLineItemBatchAssociationsListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return billingPeriodRange != null ? billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAssociateResourcesToCustomLineItemRequest build() {
            return new BatchAssociateResourcesToCustomLineItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
