/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a billing group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingGroupListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingGroupListElement.Builder, BillingGroupListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BillingGroupListElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(BillingGroupListElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(BillingGroupListElement::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryAccountId").getter(getter(BillingGroupListElement::primaryAccountId))
            .setter(setter(Builder::primaryAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()).build();

    private static final SdkField<ComputationPreference> COMPUTATION_PREFERENCE_FIELD = SdkField
            .<ComputationPreference> builder(MarshallingType.SDK_POJO).memberName("ComputationPreference")
            .getter(getter(BillingGroupListElement::computationPreference)).setter(setter(Builder::computationPreference))
            .constructor(ComputationPreference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationPreference").build())
            .build();

    private static final SdkField<Long> SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Size")
            .getter(getter(BillingGroupListElement::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTime").getter(getter(BillingGroupListElement::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(BillingGroupListElement::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(BillingGroupListElement::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(BillingGroupListElement::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, PRIMARY_ACCOUNT_ID_FIELD, COMPUTATION_PREFERENCE_FIELD, SIZE_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String description;

    private final String primaryAccountId;

    private final ComputationPreference computationPreference;

    private final Long size;

    private final Long creationTime;

    private final Long lastModifiedTime;

    private final String status;

    private final String statusReason;

    private BillingGroupListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.primaryAccountId = builder.primaryAccountId;
        this.computationPreference = builder.computationPreference;
        this.size = builder.size;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The billing group's name.
     * </p>
     * 
     * @return The billing group's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The billing group description.
     * </p>
     * 
     * @return The billing group description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The account ID that serves as the main account in a billing group.
     * </p>
     * 
     * @return The account ID that serves as the main account in a billing group.
     */
    public final String primaryAccountId() {
        return primaryAccountId;
    }

    /**
     * Returns the value of the ComputationPreference property for this object.
     * 
     * @return The value of the ComputationPreference property for this object.
     */
    public final ComputationPreference computationPreference() {
        return computationPreference;
    }

    /**
     * <p>
     * The number of accounts in the particular billing group.
     * </p>
     * 
     * @return The number of accounts in the particular billing group.
     */
    public final Long size() {
        return size;
    }

    /**
     * <p>
     * The time the billing group was created.
     * </p>
     * 
     * @return The time the billing group was created.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The most recent time the billing group was modified.
     * </p>
     * 
     * @return The most recent time the billing group was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The billing group status. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The billing group status. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The billing group status. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillingGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The billing group status. Only one of the valid values can be used.
     * @see BillingGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason why the billing group is in its current status.
     * </p>
     * 
     * @return The reason why the billing group is in its current status.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(computationPreference());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingGroupListElement)) {
            return false;
        }
        BillingGroupListElement other = (BillingGroupListElement) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description())
                && Objects.equals(primaryAccountId(), other.primaryAccountId())
                && Objects.equals(computationPreference(), other.computationPreference()) && Objects.equals(size(), other.size())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingGroupListElement").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Arn", arn()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrimaryAccountId", primaryAccountId()).add("ComputationPreference", computationPreference())
                .add("Size", size()).add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "PrimaryAccountId":
            return Optional.ofNullable(clazz.cast(primaryAccountId()));
        case "ComputationPreference":
            return Optional.ofNullable(clazz.cast(computationPreference()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillingGroupListElement, T> g) {
        return obj -> g.apply((BillingGroupListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingGroupListElement> {
        /**
         * <p>
         * The billing group's name.
         * </p>
         * 
         * @param name
         *        The billing group's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) that can be used to uniquely identify the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The billing group description.
         * </p>
         * 
         * @param description
         *        The billing group description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The account ID that serves as the main account in a billing group.
         * </p>
         * 
         * @param primaryAccountId
         *        The account ID that serves as the main account in a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAccountId(String primaryAccountId);

        /**
         * Sets the value of the ComputationPreference property for this object.
         *
         * @param computationPreference
         *        The new value for the ComputationPreference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computationPreference(ComputationPreference computationPreference);

        /**
         * Sets the value of the ComputationPreference property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ComputationPreference.Builder} avoiding
         * the need to create one manually via {@link ComputationPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputationPreference.Builder#build()} is called immediately and
         * its result is passed to {@link #computationPreference(ComputationPreference)}.
         * 
         * @param computationPreference
         *        a consumer that will call methods on {@link ComputationPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computationPreference(ComputationPreference)
         */
        default Builder computationPreference(Consumer<ComputationPreference.Builder> computationPreference) {
            return computationPreference(ComputationPreference.builder().applyMutation(computationPreference).build());
        }

        /**
         * <p>
         * The number of accounts in the particular billing group.
         * </p>
         * 
         * @param size
         *        The number of accounts in the particular billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);

        /**
         * <p>
         * The time the billing group was created.
         * </p>
         * 
         * @param creationTime
         *        The time the billing group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The most recent time the billing group was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time the billing group was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The billing group status. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The billing group status. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The billing group status. Only one of the valid values can be used.
         * </p>
         * 
         * @param status
         *        The billing group status. Only one of the valid values can be used.
         * @see BillingGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingGroupStatus
         */
        Builder status(BillingGroupStatus status);

        /**
         * <p>
         * The reason why the billing group is in its current status.
         * </p>
         * 
         * @param statusReason
         *        The reason why the billing group is in its current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String description;

        private String primaryAccountId;

        private ComputationPreference computationPreference;

        private Long size;

        private Long creationTime;

        private Long lastModifiedTime;

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingGroupListElement model) {
            name(model.name);
            arn(model.arn);
            description(model.description);
            primaryAccountId(model.primaryAccountId);
            computationPreference(model.computationPreference);
            size(model.size);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPrimaryAccountId() {
            return primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final ComputationPreference.Builder getComputationPreference() {
            return computationPreference != null ? computationPreference.toBuilder() : null;
        }

        public final void setComputationPreference(ComputationPreference.BuilderImpl computationPreference) {
            this.computationPreference = computationPreference != null ? computationPreference.build() : null;
        }

        @Override
        public final Builder computationPreference(ComputationPreference computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        public final Long getSize() {
            return size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public BillingGroupListElement build() {
            return new BillingGroupListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
