/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of a custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomLineItemListElement implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomLineItemListElement.Builder, CustomLineItemListElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CustomLineItemListElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CustomLineItemListElement::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField
            .<ListCustomLineItemChargeDetails> builder(MarshallingType.SDK_POJO).memberName("ChargeDetails")
            .getter(getter(CustomLineItemListElement::chargeDetails)).setter(setter(Builder::chargeDetails))
            .constructor(ListCustomLineItemChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(CustomLineItemListElement::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CustomLineItemListElement::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductCode").getter(getter(CustomLineItemListElement::productCode))
            .setter(setter(Builder::productCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingGroupArn").getter(getter(CustomLineItemListElement::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()).build();

    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreationTime").getter(getter(CustomLineItemListElement::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastModifiedTime").getter(getter(CustomLineItemListElement::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AssociationSize").getter(getter(CustomLineItemListElement::associationSize))
            .setter(setter(Builder::associationSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CHARGE_DETAILS_FIELD, CURRENCY_CODE_FIELD, DESCRIPTION_FIELD, PRODUCT_CODE_FIELD, BILLING_GROUP_ARN_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ASSOCIATION_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final ListCustomLineItemChargeDetails chargeDetails;

    private final String currencyCode;

    private final String description;

    private final String productCode;

    private final String billingGroupArn;

    private final Long creationTime;

    private final Long lastModifiedTime;

    private final Long associationSize;

    private CustomLineItemListElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.chargeDetails = builder.chargeDetails;
        this.currencyCode = builder.currencyCode;
        this.description = builder.description;
        this.productCode = builder.productCode;
        this.billingGroupArn = builder.billingGroupArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for custom line items.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for custom line items.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The custom line item's name.
     * </p>
     * 
     * @return The custom line item's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item.
     * </p>
     * 
     * @return A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item.
     */
    public final ListCustomLineItemChargeDetails chargeDetails() {
        return chargeDetails;
    }

    /**
     * <p>
     * The custom line item's charge value currency. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The custom line item's charge value currency. Only one of the valid values can be used.
     * @see CurrencyCode
     */
    public final CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(currencyCode);
    }

    /**
     * <p>
     * The custom line item's charge value currency. Only one of the valid values can be used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The custom line item's charge value currency. Only one of the valid values can be used.
     * @see CurrencyCode
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The custom line item's description. This is shown on the Bills page in association with the charge value.
     * </p>
     * 
     * @return The custom line item's description. This is shown on the Bills page in association with the charge value.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The product code associated with the custom line item.
     * </p>
     * 
     * @return The product code associated with the custom line item.
     */
    public final String productCode() {
        return productCode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The time created.
     * </p>
     * 
     * @return The time created.
     */
    public final Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The most recent time the custom line item was modified.
     * </p>
     * 
     * @return The most recent time the custom line item was modified.
     */
    public final Long lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The number of resources that are associated to the custom line item.
     * </p>
     * 
     * @return The number of resources that are associated to the custom line item.
     */
    public final Long associationSize() {
        return associationSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(productCode());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(associationSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemListElement)) {
            return false;
        }
        CustomLineItemListElement other = (CustomLineItemListElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(chargeDetails(), other.chargeDetails())
                && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(productCode(), other.productCode())
                && Objects.equals(billingGroupArn(), other.billingGroupArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(associationSize(), other.associationSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomLineItemListElement").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ChargeDetails", chargeDetails())
                .add("CurrencyCode", currencyCodeAsString())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProductCode", productCode()).add("BillingGroupArn", billingGroupArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("AssociationSize", associationSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ChargeDetails":
            return Optional.ofNullable(clazz.cast(chargeDetails()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProductCode":
            return Optional.ofNullable(clazz.cast(productCode()));
        case "BillingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "AssociationSize":
            return Optional.ofNullable(clazz.cast(associationSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemListElement, T> g) {
        return obj -> g.apply((CustomLineItemListElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomLineItemListElement> {
        /**
         * <p>
         * The Amazon Resource Names (ARNs) for custom line items.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Names (ARNs) for custom line items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The custom line item's name.
         * </p>
         * 
         * @param name
         *        The custom line item's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item.
         * </p>
         * 
         * @param chargeDetails
         *        A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line
         *        item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> that describes the charge details of a custom line item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListCustomLineItemChargeDetails.Builder}
         * avoiding the need to create one manually via {@link ListCustomLineItemChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chargeDetails(ListCustomLineItemChargeDetails)}.
         * 
         * @param chargeDetails
         *        a consumer that will call methods on {@link ListCustomLineItemChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chargeDetails(ListCustomLineItemChargeDetails)
         */
        default Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return chargeDetails(ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails).build());
        }

        /**
         * <p>
         * The custom line item's charge value currency. Only one of the valid values can be used.
         * </p>
         * 
         * @param currencyCode
         *        The custom line item's charge value currency. Only one of the valid values can be used.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The custom line item's charge value currency. Only one of the valid values can be used.
         * </p>
         * 
         * @param currencyCode
         *        The custom line item's charge value currency. Only one of the valid values can be used.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currencyCode(CurrencyCode currencyCode);

        /**
         * <p>
         * The custom line item's description. This is shown on the Bills page in association with the charge value.
         * </p>
         * 
         * @param description
         *        The custom line item's description. This is shown on the Bills page in association with the charge
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The product code associated with the custom line item.
         * </p>
         * 
         * @param productCode
         *        The product code associated with the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCode(String productCode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that references the billing group where the custom line item applies to.
         * </p>
         * 
         * @param billingGroupArn
         *        The Amazon Resource Name (ARN) that references the billing group where the custom line item applies
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The time created.
         * </p>
         * 
         * @param creationTime
         *        The time created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The most recent time the custom line item was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The most recent time the custom line item was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Long lastModifiedTime);

        /**
         * <p>
         * The number of resources that are associated to the custom line item.
         * </p>
         * 
         * @param associationSize
         *        The number of resources that are associated to the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSize(Long associationSize);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private ListCustomLineItemChargeDetails chargeDetails;

        private String currencyCode;

        private String description;

        private String productCode;

        private String billingGroupArn;

        private Long creationTime;

        private Long lastModifiedTime;

        private Long associationSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemListElement model) {
            arn(model.arn);
            name(model.name);
            chargeDetails(model.chargeDetails);
            currencyCode(model.currencyCode);
            description(model.description);
            productCode(model.productCode);
            billingGroupArn(model.billingGroupArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            associationSize(model.associationSize);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return chargeDetails != null ? chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProductCode() {
            return productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        @Override
        public CustomLineItemListElement build() {
            return new CustomLineItemListElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
