/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource disassociation result for a percentage custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateResourceResponseElement implements SdkPojo, Serializable,
        ToCopyableBuilder<DisassociateResourceResponseElement.Builder, DisassociateResourceResponseElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DisassociateResourceResponseElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<AssociateResourceError> ERROR_FIELD = SdkField
            .<AssociateResourceError> builder(MarshallingType.SDK_POJO).memberName("Error")
            .getter(getter(DisassociateResourceResponseElement::error)).setter(setter(Builder::error))
            .constructor(AssociateResourceError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final AssociateResourceError error;

    private DisassociateResourceResponseElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.error = builder.error;
    }

    /**
     * <p>
     * The resource ARN that was disassociated from the custom line item.
     * </p>
     * 
     * @return The resource ARN that was disassociated from the custom line item.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * An <code>AssociateResourceError</code> shown if the resource disassociation fails.
     * </p>
     * 
     * @return An <code>AssociateResourceError</code> shown if the resource disassociation fails.
     */
    public final AssociateResourceError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateResourceResponseElement)) {
            return false;
        }
        DisassociateResourceResponseElement other = (DisassociateResourceResponseElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateResourceResponseElement").add("Arn", arn()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateResourceResponseElement, T> g) {
        return obj -> g.apply((DisassociateResourceResponseElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisassociateResourceResponseElement> {
        /**
         * <p>
         * The resource ARN that was disassociated from the custom line item.
         * </p>
         * 
         * @param arn
         *        The resource ARN that was disassociated from the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * An <code>AssociateResourceError</code> shown if the resource disassociation fails.
         * </p>
         * 
         * @param error
         *        An <code>AssociateResourceError</code> shown if the resource disassociation fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(AssociateResourceError error);

        /**
         * <p>
         * An <code>AssociateResourceError</code> shown if the resource disassociation fails.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociateResourceError.Builder} avoiding
         * the need to create one manually via {@link AssociateResourceError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociateResourceError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(AssociateResourceError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link AssociateResourceError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(AssociateResourceError)
         */
        default Builder error(Consumer<AssociateResourceError.Builder> error) {
            return error(AssociateResourceError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private AssociateResourceError error;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateResourceResponseElement model) {
            arn(model.arn);
            error(model.error);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AssociateResourceError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(AssociateResourceError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(AssociateResourceError error) {
            this.error = error;
            return this;
        }

        @Override
        public DisassociateResourceResponseElement build() {
            return new DisassociateResourceResponseElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
