/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountAssociationsRequest extends BillingconductorRequest implements
        ToCopyableBuilder<ListAccountAssociationsRequest.Builder, ListAccountAssociationsRequest> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingPeriod").getter(getter(ListAccountAssociationsRequest::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<ListAccountAssociationsFilter> FILTERS_FIELD = SdkField
            .<ListAccountAssociationsFilter> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListAccountAssociationsRequest::filters)).setter(setter(Builder::filters))
            .constructor(ListAccountAssociationsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountAssociationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD));

    private final String billingPeriod;

    private final ListAccountAssociationsFilter filters;

    private final String nextToken;

    private ListAccountAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The preferred billing period to get account associations.
     * </p>
     * 
     * @return The preferred billing period to get account associations.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * The filter on the account ID of the linked account, or any of the following:
     * </p>
     * <p>
     * <code>MONITORED</code>: linked accounts that are associated to billing groups.
     * </p>
     * <p>
     * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
     * </p>
     * <p>
     * <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn.
     * </p>
     * 
     * @return The filter on the account ID of the linked account, or any of the following:</p>
     *         <p>
     *         <code>MONITORED</code>: linked accounts that are associated to billing groups.
     *         </p>
     *         <p>
     *         <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
     *         </p>
     *         <p>
     *         <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn.
     */
    public final ListAccountAssociationsFilter filters() {
        return filters;
    }

    /**
     * <p>
     * The pagination token used on subsequent calls to retrieve accounts.
     * </p>
     * 
     * @return The pagination token used on subsequent calls to retrieve accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountAssociationsRequest)) {
            return false;
        }
        ListAccountAssociationsRequest other = (ListAccountAssociationsRequest) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountAssociationsRequest").add("BillingPeriod", billingPeriod()).add("Filters", filters())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccountAssociationsRequest, T> g) {
        return obj -> g.apply((ListAccountAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccountAssociationsRequest> {
        /**
         * <p>
         * The preferred billing period to get account associations.
         * </p>
         * 
         * @param billingPeriod
         *        The preferred billing period to get account associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * The filter on the account ID of the linked account, or any of the following:
         * </p>
         * <p>
         * <code>MONITORED</code>: linked accounts that are associated to billing groups.
         * </p>
         * <p>
         * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
         * </p>
         * <p>
         * <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn.
         * </p>
         * 
         * @param filters
         *        The filter on the account ID of the linked account, or any of the following:</p>
         *        <p>
         *        <code>MONITORED</code>: linked accounts that are associated to billing groups.
         *        </p>
         *        <p>
         *        <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
         *        </p>
         *        <p>
         *        <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListAccountAssociationsFilter filters);

        /**
         * <p>
         * The filter on the account ID of the linked account, or any of the following:
         * </p>
         * <p>
         * <code>MONITORED</code>: linked accounts that are associated to billing groups.
         * </p>
         * <p>
         * <code>UNMONITORED</code>: linked accounts that are not associated to billing groups.
         * </p>
         * <p>
         * <code>Billing Group Arn</code>: linked accounts that are associated to the provided billing group Arn.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListAccountAssociationsFilter.Builder}
         * avoiding the need to create one manually via {@link ListAccountAssociationsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListAccountAssociationsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(ListAccountAssociationsFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ListAccountAssociationsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ListAccountAssociationsFilter)
         */
        default Builder filters(Consumer<ListAccountAssociationsFilter.Builder> filters) {
            return filters(ListAccountAssociationsFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * The pagination token used on subsequent calls to retrieve accounts.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used on subsequent calls to retrieve accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String billingPeriod;

        private ListAccountAssociationsFilter filters;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountAssociationsRequest model) {
            super(model);
            billingPeriod(model.billingPeriod);
            filters(model.filters);
            nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final ListAccountAssociationsFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ListAccountAssociationsFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListAccountAssociationsFilter filters) {
            this.filters = filters;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountAssociationsRequest build() {
            return new ListAccountAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
