/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricingRulesAssociatedToPricingPlanResponse extends BillingconductorResponse
        implements
        ToCopyableBuilder<ListPricingRulesAssociatedToPricingPlanResponse.Builder, ListPricingRulesAssociatedToPricingPlanResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingPeriod").getter(getter(ListPricingRulesAssociatedToPricingPlanResponse::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<String> PRICING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlanArn").getter(getter(ListPricingRulesAssociatedToPricingPlanResponse::pricingPlanArn))
            .setter(setter(Builder::pricingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArn").build()).build();

    private static final SdkField<List<String>> PRICING_RULE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PricingRuleArns")
            .getter(getter(ListPricingRulesAssociatedToPricingPlanResponse::pricingRuleArns))
            .setter(setter(Builder::pricingRuleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRuleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPricingRulesAssociatedToPricingPlanResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            PRICING_PLAN_ARN_FIELD, PRICING_RULE_ARNS_FIELD, NEXT_TOKEN_FIELD));

    private final String billingPeriod;

    private final String pricingPlanArn;

    private final List<String> pricingRuleArns;

    private final String nextToken;

    private ListPricingRulesAssociatedToPricingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingPlanArn = builder.pricingPlanArn;
        this.pricingRuleArns = builder.pricingRuleArns;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The billing period for which the pricing rule associations are listed.
     * </p>
     * 
     * @return The billing period for which the pricing rule associations are listed.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.
     */
    public final String pricingPlanArn() {
        return pricingPlanArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PricingRuleArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPricingRuleArns() {
        return pricingRuleArns != null && !(pricingRuleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing pricing rules associated with the requested pricing plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPricingRuleArns} method.
     * </p>
     * 
     * @return A list containing pricing rules associated with the requested pricing plan.
     */
    public final List<String> pricingRuleArns() {
        return pricingRuleArns;
    }

    /**
     * <p>
     * The pagination token to be used on subsequent calls.
     * </p>
     * 
     * @return The pagination token to be used on subsequent calls.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPricingRuleArns() ? pricingRuleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesAssociatedToPricingPlanResponse)) {
            return false;
        }
        ListPricingRulesAssociatedToPricingPlanResponse other = (ListPricingRulesAssociatedToPricingPlanResponse) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && Objects.equals(pricingPlanArn(), other.pricingPlanArn())
                && hasPricingRuleArns() == other.hasPricingRuleArns()
                && Objects.equals(pricingRuleArns(), other.pricingRuleArns()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricingRulesAssociatedToPricingPlanResponse").add("BillingPeriod", billingPeriod())
                .add("PricingPlanArn", pricingPlanArn()).add("PricingRuleArns", hasPricingRuleArns() ? pricingRuleArns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "PricingPlanArn":
            return Optional.ofNullable(clazz.cast(pricingPlanArn()));
        case "PricingRuleArns":
            return Optional.ofNullable(clazz.cast(pricingRuleArns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPricingRulesAssociatedToPricingPlanResponse, T> g) {
        return obj -> g.apply((ListPricingRulesAssociatedToPricingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPricingRulesAssociatedToPricingPlanResponse> {
        /**
         * <p>
         * The billing period for which the pricing rule associations are listed.
         * </p>
         * 
         * @param billingPeriod
         *        The billing period for which the pricing rule associations are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.
         * </p>
         * 
         * @param pricingPlanArn
         *        The Amazon Resource Name (ARN) of the pricing plan for which associations are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlanArn(String pricingPlanArn);

        /**
         * <p>
         * A list containing pricing rules associated with the requested pricing plan.
         * </p>
         * 
         * @param pricingRuleArns
         *        A list containing pricing rules associated with the requested pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRuleArns(Collection<String> pricingRuleArns);

        /**
         * <p>
         * A list containing pricing rules associated with the requested pricing plan.
         * </p>
         * 
         * @param pricingRuleArns
         *        A list containing pricing rules associated with the requested pricing plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRuleArns(String... pricingRuleArns);

        /**
         * <p>
         * The pagination token to be used on subsequent calls.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to be used on subsequent calls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String billingPeriod;

        private String pricingPlanArn;

        private List<String> pricingRuleArns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingRulesAssociatedToPricingPlanResponse model) {
            super(model);
            billingPeriod(model.billingPeriod);
            pricingPlanArn(model.pricingPlanArn);
            pricingRuleArns(model.pricingRuleArns);
            nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getPricingPlanArn() {
            return pricingPlanArn;
        }

        public final void setPricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
        }

        @Override
        public final Builder pricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        public final Collection<String> getPricingRuleArns() {
            if (pricingRuleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return pricingRuleArns;
        }

        public final void setPricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsCopier.copy(pricingRuleArns);
        }

        @Override
        public final Builder pricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsCopier.copy(pricingRuleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRuleArns(String... pricingRuleArns) {
            pricingRuleArns(Arrays.asList(pricingRuleArns));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingRulesAssociatedToPricingPlanResponse build() {
            return new ListPricingRulesAssociatedToPricingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
