/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the new charge details associated with a flat custom line item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomLineItemFlatChargeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCustomLineItemFlatChargeDetails.Builder, UpdateCustomLineItemFlatChargeDetails> {
    private static final SdkField<Double> CHARGE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ChargeValue").getter(getter(UpdateCustomLineItemFlatChargeDetails::chargeValue))
            .setter(setter(Builder::chargeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARGE_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double chargeValue;

    private UpdateCustomLineItemFlatChargeDetails(BuilderImpl builder) {
        this.chargeValue = builder.chargeValue;
    }

    /**
     * <p>
     * The custom line item's new fixed charge value in USD.
     * </p>
     * 
     * @return The custom line item's new fixed charge value in USD.
     */
    public final Double chargeValue() {
        return chargeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chargeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemFlatChargeDetails)) {
            return false;
        }
        UpdateCustomLineItemFlatChargeDetails other = (UpdateCustomLineItemFlatChargeDetails) obj;
        return Objects.equals(chargeValue(), other.chargeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomLineItemFlatChargeDetails").add("ChargeValue", chargeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChargeValue":
            return Optional.ofNullable(clazz.cast(chargeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemFlatChargeDetails, T> g) {
        return obj -> g.apply((UpdateCustomLineItemFlatChargeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCustomLineItemFlatChargeDetails> {
        /**
         * <p>
         * The custom line item's new fixed charge value in USD.
         * </p>
         * 
         * @param chargeValue
         *        The custom line item's new fixed charge value in USD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeValue(Double chargeValue);
    }

    static final class BuilderImpl implements Builder {
        private Double chargeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemFlatChargeDetails model) {
            chargeValue(model.chargeValue);
        }

        public final Double getChargeValue() {
            return chargeValue;
        }

        public final void setChargeValue(Double chargeValue) {
            this.chargeValue = chargeValue;
        }

        @Override
        public final Builder chargeValue(Double chargeValue) {
            this.chargeValue = chargeValue;
            return this;
        }

        @Override
        public UpdateCustomLineItemFlatChargeDetails build() {
            return new UpdateCustomLineItemFlatChargeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
