/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCustomLineItemRequest extends BillingconductorRequest implements
        ToCopyableBuilder<UpdateCustomLineItemRequest.Builder, UpdateCustomLineItemRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateCustomLineItemRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateCustomLineItemRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateCustomLineItemRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<UpdateCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField
            .<UpdateCustomLineItemChargeDetails> builder(MarshallingType.SDK_POJO).memberName("ChargeDetails")
            .getter(getter(UpdateCustomLineItemRequest::chargeDetails)).setter(setter(Builder::chargeDetails))
            .constructor(UpdateCustomLineItemChargeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()).build();

    private static final SdkField<CustomLineItemBillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField
            .<CustomLineItemBillingPeriodRange> builder(MarshallingType.SDK_POJO).memberName("BillingPeriodRange")
            .getter(getter(UpdateCustomLineItemRequest::billingPeriodRange)).setter(setter(Builder::billingPeriodRange))
            .constructor(CustomLineItemBillingPeriodRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CHARGE_DETAILS_FIELD, BILLING_PERIOD_RANGE_FIELD));

    private final String arn;

    private final String name;

    private final String description;

    private final UpdateCustomLineItemChargeDetails chargeDetails;

    private final CustomLineItemBillingPeriodRange billingPeriodRange;

    private UpdateCustomLineItemRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.chargeDetails = builder.chargeDetails;
        this.billingPeriodRange = builder.billingPeriodRange;
    }

    /**
     * <p>
     * The ARN of the custom line item to be updated.
     * </p>
     * 
     * @return The ARN of the custom line item to be updated.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The new name for the custom line item.
     * </p>
     * 
     * @return The new name for the custom line item.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The new line item description of the custom line item.
     * </p>
     * 
     * @return The new line item description of the custom line item.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item.
     * </p>
     * 
     * @return A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line
     *         item.
     */
    public final UpdateCustomLineItemChargeDetails chargeDetails() {
        return chargeDetails;
    }

    /**
     * Returns the value of the BillingPeriodRange property for this object.
     * 
     * @return The value of the BillingPeriodRange property for this object.
     */
    public final CustomLineItemBillingPeriodRange billingPeriodRange() {
        return billingPeriodRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriodRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomLineItemRequest)) {
            return false;
        }
        UpdateCustomLineItemRequest other = (UpdateCustomLineItemRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(chargeDetails(), other.chargeDetails())
                && Objects.equals(billingPeriodRange(), other.billingPeriodRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCustomLineItemRequest").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ChargeDetails", chargeDetails()).add("BillingPeriodRange", billingPeriodRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ChargeDetails":
            return Optional.ofNullable(clazz.cast(chargeDetails()));
        case "BillingPeriodRange":
            return Optional.ofNullable(clazz.cast(billingPeriodRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomLineItemRequest, T> g) {
        return obj -> g.apply((UpdateCustomLineItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCustomLineItemRequest> {
        /**
         * <p>
         * The ARN of the custom line item to be updated.
         * </p>
         * 
         * @param arn
         *        The ARN of the custom line item to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The new name for the custom line item.
         * </p>
         * 
         * @param name
         *        The new name for the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The new line item description of the custom line item.
         * </p>
         * 
         * @param description
         *        The new line item description of the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item.
         * </p>
         * 
         * @param chargeDetails
         *        A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line
         *        item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chargeDetails(UpdateCustomLineItemChargeDetails chargeDetails);

        /**
         * <p>
         * A <code>ListCustomLineItemChargeDetails</code> containing the new charge details for the custom line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateCustomLineItemChargeDetails.Builder} avoiding the need to create one manually via
         * {@link UpdateCustomLineItemChargeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCustomLineItemChargeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #chargeDetails(UpdateCustomLineItemChargeDetails)}.
         * 
         * @param chargeDetails
         *        a consumer that will call methods on {@link UpdateCustomLineItemChargeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chargeDetails(UpdateCustomLineItemChargeDetails)
         */
        default Builder chargeDetails(Consumer<UpdateCustomLineItemChargeDetails.Builder> chargeDetails) {
            return chargeDetails(UpdateCustomLineItemChargeDetails.builder().applyMutation(chargeDetails).build());
        }

        /**
         * Sets the value of the BillingPeriodRange property for this object.
         *
         * @param billingPeriodRange
         *        The new value for the BillingPeriodRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange);

        /**
         * Sets the value of the BillingPeriodRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CustomLineItemBillingPeriodRange.Builder}
         * avoiding the need to create one manually via {@link CustomLineItemBillingPeriodRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomLineItemBillingPeriodRange.Builder#build()} is called
         * immediately and its result is passed to {@link #billingPeriodRange(CustomLineItemBillingPeriodRange)}.
         * 
         * @param billingPeriodRange
         *        a consumer that will call methods on {@link CustomLineItemBillingPeriodRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriodRange(CustomLineItemBillingPeriodRange)
         */
        default Builder billingPeriodRange(Consumer<CustomLineItemBillingPeriodRange.Builder> billingPeriodRange) {
            return billingPeriodRange(CustomLineItemBillingPeriodRange.builder().applyMutation(billingPeriodRange).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private UpdateCustomLineItemChargeDetails chargeDetails;

        private CustomLineItemBillingPeriodRange billingPeriodRange;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomLineItemRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            chargeDetails(model.chargeDetails);
            billingPeriodRange(model.billingPeriodRange);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final UpdateCustomLineItemChargeDetails.Builder getChargeDetails() {
            return chargeDetails != null ? chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(UpdateCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(UpdateCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final CustomLineItemBillingPeriodRange.Builder getBillingPeriodRange() {
            return billingPeriodRange != null ? billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(CustomLineItemBillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(CustomLineItemBillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomLineItemRequest build() {
            return new UpdateCustomLineItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
