/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBillingGroupCostReportRequest extends BillingconductorRequest implements
        ToCopyableBuilder<GetBillingGroupCostReportRequest.Builder, GetBillingGroupCostReportRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetBillingGroupCostReportRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<BillingPeriodRange> BILLING_PERIOD_RANGE_FIELD = SdkField
            .<BillingPeriodRange> builder(MarshallingType.SDK_POJO).memberName("BillingPeriodRange")
            .getter(getter(GetBillingGroupCostReportRequest::billingPeriodRange)).setter(setter(Builder::billingPeriodRange))
            .constructor(BillingPeriodRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriodRange").build())
            .build();

    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetBillingGroupCostReportRequest::groupByAsStrings))
            .setter(setter(Builder::groupByWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetBillingGroupCostReportRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetBillingGroupCostReportRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            BILLING_PERIOD_RANGE_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String arn;

    private final BillingPeriodRange billingPeriodRange;

    private final List<String> groupBy;

    private final Integer maxResults;

    private final String nextToken;

    private GetBillingGroupCostReportRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.billingPeriodRange = builder.billingPeriodRange;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) that uniquely identifies the billing group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A time range for which the margin summary is effective. You can specify up to 12 months.
     * </p>
     * 
     * @return A time range for which the margin summary is effective. You can specify up to 12 months.
     */
    public final BillingPeriodRange billingPeriodRange() {
        return billingPeriodRange;
    }

    /**
     * <p>
     * A list of strings that specify the attributes that are used to break down costs in the margin summary reports for
     * the billing group. For example, you can view your costs by the Amazon Web Service name or the billing period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return A list of strings that specify the attributes that are used to break down costs in the margin summary
     *         reports for the billing group. For example, you can view your costs by the Amazon Web Service name or the
     *         billing period.
     */
    public final List<GroupByAttributeName> groupBy() {
        return GroupByAttributesListCopier.copyStringToEnum(groupBy);
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings that specify the attributes that are used to break down costs in the margin summary reports for
     * the billing group. For example, you can view your costs by the Amazon Web Service name or the billing period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return A list of strings that specify the attributes that are used to break down costs in the margin summary
     *         reports for the billing group. For example, you can view your costs by the Amazon Web Service name or the
     *         billing period.
     */
    public final List<String> groupByAsStrings() {
        return groupBy;
    }

    /**
     * <p>
     * The maximum number of margin summary reports to retrieve.
     * </p>
     * 
     * @return The maximum number of margin summary reports to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token used on subsequent calls to get reports.
     * </p>
     * 
     * @return The pagination token used on subsequent calls to get reports.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriodRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillingGroupCostReportRequest)) {
            return false;
        }
        GetBillingGroupCostReportRequest other = (GetBillingGroupCostReportRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(billingPeriodRange(), other.billingPeriodRange())
                && hasGroupBy() == other.hasGroupBy() && Objects.equals(groupByAsStrings(), other.groupByAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBillingGroupCostReportRequest").add("Arn", arn())
                .add("BillingPeriodRange", billingPeriodRange()).add("GroupBy", hasGroupBy() ? groupByAsStrings() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "BillingPeriodRange":
            return Optional.ofNullable(clazz.cast(billingPeriodRange()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupByAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBillingGroupCostReportRequest, T> g) {
        return obj -> g.apply((GetBillingGroupCostReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBillingGroupCostReportRequest> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) that uniquely identifies the billing group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) that uniquely identifies the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A time range for which the margin summary is effective. You can specify up to 12 months.
         * </p>
         * 
         * @param billingPeriodRange
         *        A time range for which the margin summary is effective. You can specify up to 12 months.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriodRange(BillingPeriodRange billingPeriodRange);

        /**
         * <p>
         * A time range for which the margin summary is effective. You can specify up to 12 months.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillingPeriodRange.Builder} avoiding the
         * need to create one manually via {@link BillingPeriodRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillingPeriodRange.Builder#build()} is called immediately and its
         * result is passed to {@link #billingPeriodRange(BillingPeriodRange)}.
         * 
         * @param billingPeriodRange
         *        a consumer that will call methods on {@link BillingPeriodRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingPeriodRange(BillingPeriodRange)
         */
        default Builder billingPeriodRange(Consumer<BillingPeriodRange.Builder> billingPeriodRange) {
            return billingPeriodRange(BillingPeriodRange.builder().applyMutation(billingPeriodRange).build());
        }

        /**
         * <p>
         * A list of strings that specify the attributes that are used to break down costs in the margin summary reports
         * for the billing group. For example, you can view your costs by the Amazon Web Service name or the billing
         * period.
         * </p>
         * 
         * @param groupBy
         *        A list of strings that specify the attributes that are used to break down costs in the margin summary
         *        reports for the billing group. For example, you can view your costs by the Amazon Web Service name or
         *        the billing period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(Collection<String> groupBy);

        /**
         * <p>
         * A list of strings that specify the attributes that are used to break down costs in the margin summary reports
         * for the billing group. For example, you can view your costs by the Amazon Web Service name or the billing
         * period.
         * </p>
         * 
         * @param groupBy
         *        A list of strings that specify the attributes that are used to break down costs in the margin summary
         *        reports for the billing group. For example, you can view your costs by the Amazon Web Service name or
         *        the billing period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(String... groupBy);

        /**
         * <p>
         * A list of strings that specify the attributes that are used to break down costs in the margin summary reports
         * for the billing group. For example, you can view your costs by the Amazon Web Service name or the billing
         * period.
         * </p>
         * 
         * @param groupBy
         *        A list of strings that specify the attributes that are used to break down costs in the margin summary
         *        reports for the billing group. For example, you can view your costs by the Amazon Web Service name or
         *        the billing period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupByAttributeName> groupBy);

        /**
         * <p>
         * A list of strings that specify the attributes that are used to break down costs in the margin summary reports
         * for the billing group. For example, you can view your costs by the Amazon Web Service name or the billing
         * period.
         * </p>
         * 
         * @param groupBy
         *        A list of strings that specify the attributes that are used to break down costs in the margin summary
         *        reports for the billing group. For example, you can view your costs by the Amazon Web Service name or
         *        the billing period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupByAttributeName... groupBy);

        /**
         * <p>
         * The maximum number of margin summary reports to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of margin summary reports to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token used on subsequent calls to get reports.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used on subsequent calls to get reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private BillingPeriodRange billingPeriodRange;

        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillingGroupCostReportRequest model) {
            super(model);
            arn(model.arn);
            billingPeriodRange(model.billingPeriodRange);
            groupByWithStrings(model.groupBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final BillingPeriodRange.Builder getBillingPeriodRange() {
            return billingPeriodRange != null ? billingPeriodRange.toBuilder() : null;
        }

        public final void setBillingPeriodRange(BillingPeriodRange.BuilderImpl billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange != null ? billingPeriodRange.build() : null;
        }

        @Override
        public final Builder billingPeriodRange(BillingPeriodRange billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String... groupBy) {
            groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupByAttributeName> groupBy) {
            this.groupBy = GroupByAttributesListCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupByAttributeName... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBillingGroupCostReportRequest build() {
            return new GetBillingGroupCostReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
