/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LineItemFiltersListCopier {
    static List<LineItemFilter> copy(Collection<? extends LineItemFilter> lineItemFiltersListParam) {
        List<LineItemFilter> list;
        if (lineItemFiltersListParam == null || lineItemFiltersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineItemFilter> modifiableList = new ArrayList<>(lineItemFiltersListParam.size());
            lineItemFiltersListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LineItemFilter> copyFromBuilder(Collection<? extends LineItemFilter.Builder> lineItemFiltersListParam) {
        List<LineItemFilter> list;
        if (lineItemFiltersListParam == null || lineItemFiltersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineItemFilter> modifiableList = new ArrayList<>(lineItemFiltersListParam.size());
            lineItemFiltersListParam.forEach(entry -> {
                LineItemFilter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LineItemFilter.Builder> copyToBuilder(Collection<? extends LineItemFilter> lineItemFiltersListParam) {
        List<LineItemFilter.Builder> list;
        if (lineItemFiltersListParam == null || lineItemFiltersListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LineItemFilter.Builder> modifiableList = new ArrayList<>(lineItemFiltersListParam.size());
            lineItemFiltersListParam.forEach(entry -> {
                LineItemFilter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
