/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBillingGroupCostReportResponse extends BillingconductorResponse implements
        ToCopyableBuilder<GetBillingGroupCostReportResponse.Builder, GetBillingGroupCostReportResponse> {
    private static final SdkField<List<BillingGroupCostReportResultElement>> BILLING_GROUP_COST_REPORT_RESULTS_FIELD = SdkField
            .<List<BillingGroupCostReportResultElement>> builder(MarshallingType.LIST)
            .memberName("BillingGroupCostReportResults")
            .getter(getter(GetBillingGroupCostReportResponse::billingGroupCostReportResults))
            .setter(setter(Builder::billingGroupCostReportResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupCostReportResults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BillingGroupCostReportResultElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(BillingGroupCostReportResultElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetBillingGroupCostReportResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BILLING_GROUP_COST_REPORT_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<BillingGroupCostReportResultElement> billingGroupCostReportResults;

    private final String nextToken;

    private GetBillingGroupCostReportResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroupCostReportResults = builder.billingGroupCostReportResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillingGroupCostReportResults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBillingGroupCostReportResults() {
        return billingGroupCostReportResults != null && !(billingGroupCostReportResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of margin summary reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingGroupCostReportResults} method.
     * </p>
     * 
     * @return The list of margin summary reports.
     */
    public final List<BillingGroupCostReportResultElement> billingGroupCostReportResults() {
        return billingGroupCostReportResults;
    }

    /**
     * <p>
     * The pagination token used on subsequent calls to get reports.
     * </p>
     * 
     * @return The pagination token used on subsequent calls to get reports.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBillingGroupCostReportResults() ? billingGroupCostReportResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillingGroupCostReportResponse)) {
            return false;
        }
        GetBillingGroupCostReportResponse other = (GetBillingGroupCostReportResponse) obj;
        return hasBillingGroupCostReportResults() == other.hasBillingGroupCostReportResults()
                && Objects.equals(billingGroupCostReportResults(), other.billingGroupCostReportResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetBillingGroupCostReportResponse")
                .add("BillingGroupCostReportResults", hasBillingGroupCostReportResults() ? billingGroupCostReportResults() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingGroupCostReportResults":
            return Optional.ofNullable(clazz.cast(billingGroupCostReportResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBillingGroupCostReportResponse, T> g) {
        return obj -> g.apply((GetBillingGroupCostReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBillingGroupCostReportResponse> {
        /**
         * <p>
         * The list of margin summary reports.
         * </p>
         * 
         * @param billingGroupCostReportResults
         *        The list of margin summary reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupCostReportResults(Collection<BillingGroupCostReportResultElement> billingGroupCostReportResults);

        /**
         * <p>
         * The list of margin summary reports.
         * </p>
         * 
         * @param billingGroupCostReportResults
         *        The list of margin summary reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupCostReportResults(BillingGroupCostReportResultElement... billingGroupCostReportResults);

        /**
         * <p>
         * The list of margin summary reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportResultElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportResultElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportResultElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #billingGroupCostReportResults(List<BillingGroupCostReportResultElement>)}.
         * 
         * @param billingGroupCostReportResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupCostReportResultElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroupCostReportResults(java.util.Collection<BillingGroupCostReportResultElement>)
         */
        Builder billingGroupCostReportResults(
                Consumer<BillingGroupCostReportResultElement.Builder>... billingGroupCostReportResults);

        /**
         * <p>
         * The pagination token used on subsequent calls to get reports.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used on subsequent calls to get reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private List<BillingGroupCostReportResultElement> billingGroupCostReportResults = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillingGroupCostReportResponse model) {
            super(model);
            billingGroupCostReportResults(model.billingGroupCostReportResults);
            nextToken(model.nextToken);
        }

        public final List<BillingGroupCostReportResultElement.Builder> getBillingGroupCostReportResults() {
            List<BillingGroupCostReportResultElement.Builder> result = BillingGroupCostReportResultsListCopier
                    .copyToBuilder(this.billingGroupCostReportResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBillingGroupCostReportResults(
                Collection<BillingGroupCostReportResultElement.BuilderImpl> billingGroupCostReportResults) {
            this.billingGroupCostReportResults = BillingGroupCostReportResultsListCopier
                    .copyFromBuilder(billingGroupCostReportResults);
        }

        @Override
        public final Builder billingGroupCostReportResults(
                Collection<BillingGroupCostReportResultElement> billingGroupCostReportResults) {
            this.billingGroupCostReportResults = BillingGroupCostReportResultsListCopier.copy(billingGroupCostReportResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupCostReportResults(BillingGroupCostReportResultElement... billingGroupCostReportResults) {
            billingGroupCostReportResults(Arrays.asList(billingGroupCostReportResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupCostReportResults(
                Consumer<BillingGroupCostReportResultElement.Builder>... billingGroupCostReportResults) {
            billingGroupCostReportResults(Stream.of(billingGroupCostReportResults)
                    .map(c -> BillingGroupCostReportResultElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBillingGroupCostReportResponse build() {
            return new GetBillingGroupCostReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
