/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A representation of the line item filter for your custom line item. You can use line item filters to include or
 * exclude specific resource values from the billing group's total cost. For example, if you create a custom line item
 * and you want to filter out a value, such as Savings Plan discounts, you can update <code>LineItemFilter</code> to
 * exclude it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItemFilter implements SdkPojo, Serializable, ToCopyableBuilder<LineItemFilter.Builder, LineItemFilter> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(LineItemFilter::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<String> MATCH_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchOption").getter(getter(LineItemFilter::matchOptionAsString)).setter(setter(Builder::matchOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOption").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(LineItemFilter::valuesAsStrings))
            .setter(setter(Builder::valuesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            MATCH_OPTION_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String matchOption;

    private final List<String> values;

    private LineItemFilter(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.matchOption = builder.matchOption;
        this.values = builder.values;
    }

    /**
     * <p>
     * The attribute of the line item filter. This specifies what attribute that you can filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link LineItemFilterAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the line item filter. This specifies what attribute that you can filter on.
     * @see LineItemFilterAttributeName
     */
    public final LineItemFilterAttributeName attribute() {
        return LineItemFilterAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute of the line item filter. This specifies what attribute that you can filter on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link LineItemFilterAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute of the line item filter. This specifies what attribute that you can filter on.
     * @see LineItemFilterAttributeName
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The match criteria of the line item filter. This parameter specifies whether not to include the resource value
     * from the billing group total cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOption} will
     * return {@link MatchOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchOptionAsString}.
     * </p>
     * 
     * @return The match criteria of the line item filter. This parameter specifies whether not to include the resource
     *         value from the billing group total cost.
     * @see MatchOption
     */
    public final MatchOption matchOption() {
        return MatchOption.fromValue(matchOption);
    }

    /**
     * <p>
     * The match criteria of the line item filter. This parameter specifies whether not to include the resource value
     * from the billing group total cost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOption} will
     * return {@link MatchOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchOptionAsString}.
     * </p>
     * 
     * @return The match criteria of the line item filter. This parameter specifies whether not to include the resource
     *         value from the billing group total cost.
     * @see MatchOption
     */
    public final String matchOptionAsString() {
        return matchOption;
    }

    /**
     * <p>
     * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
     * Savings Plan discounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values of the line item filter. This specifies the values to filter on. Currently, you can only
     *         exclude Savings Plan discounts.
     */
    public final List<LineItemFilterValue> values() {
        return LineItemFilterValuesListCopier.copyStringToEnum(values);
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
     * Savings Plan discounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values of the line item filter. This specifies the values to filter on. Currently, you can only
     *         exclude Savings Plan discounts.
     */
    public final List<String> valuesAsStrings() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(matchOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? valuesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemFilter)) {
            return false;
        }
        LineItemFilter other = (LineItemFilter) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(matchOptionAsString(), other.matchOptionAsString()) && hasValues() == other.hasValues()
                && Objects.equals(valuesAsStrings(), other.valuesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItemFilter").add("Attribute", attributeAsString()).add("MatchOption", matchOptionAsString())
                .add("Values", hasValues() ? valuesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "MatchOption":
            return Optional.ofNullable(clazz.cast(matchOptionAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(valuesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LineItemFilter, T> g) {
        return obj -> g.apply((LineItemFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItemFilter> {
        /**
         * <p>
         * The attribute of the line item filter. This specifies what attribute that you can filter on.
         * </p>
         * 
         * @param attribute
         *        The attribute of the line item filter. This specifies what attribute that you can filter on.
         * @see LineItemFilterAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineItemFilterAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute of the line item filter. This specifies what attribute that you can filter on.
         * </p>
         * 
         * @param attribute
         *        The attribute of the line item filter. This specifies what attribute that you can filter on.
         * @see LineItemFilterAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineItemFilterAttributeName
         */
        Builder attribute(LineItemFilterAttributeName attribute);

        /**
         * <p>
         * The match criteria of the line item filter. This parameter specifies whether not to include the resource
         * value from the billing group total cost.
         * </p>
         * 
         * @param matchOption
         *        The match criteria of the line item filter. This parameter specifies whether not to include the
         *        resource value from the billing group total cost.
         * @see MatchOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchOption
         */
        Builder matchOption(String matchOption);

        /**
         * <p>
         * The match criteria of the line item filter. This parameter specifies whether not to include the resource
         * value from the billing group total cost.
         * </p>
         * 
         * @param matchOption
         *        The match criteria of the line item filter. This parameter specifies whether not to include the
         *        resource value from the billing group total cost.
         * @see MatchOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchOption
         */
        Builder matchOption(MatchOption matchOption);

        /**
         * <p>
         * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
         * Savings Plan discounts.
         * </p>
         * 
         * @param values
         *        The values of the line item filter. This specifies the values to filter on. Currently, you can only
         *        exclude Savings Plan discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesWithStrings(Collection<String> values);

        /**
         * <p>
         * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
         * Savings Plan discounts.
         * </p>
         * 
         * @param values
         *        The values of the line item filter. This specifies the values to filter on. Currently, you can only
         *        exclude Savings Plan discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valuesWithStrings(String... values);

        /**
         * <p>
         * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
         * Savings Plan discounts.
         * </p>
         * 
         * @param values
         *        The values of the line item filter. This specifies the values to filter on. Currently, you can only
         *        exclude Savings Plan discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<LineItemFilterValue> values);

        /**
         * <p>
         * The values of the line item filter. This specifies the values to filter on. Currently, you can only exclude
         * Savings Plan discounts.
         * </p>
         * 
         * @param values
         *        The values of the line item filter. This specifies the values to filter on. Currently, you can only
         *        exclude Savings Plan discounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(LineItemFilterValue... values);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String matchOption;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemFilter model) {
            attribute(model.attribute);
            matchOption(model.matchOption);
            valuesWithStrings(model.values);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(LineItemFilterAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getMatchOption() {
            return matchOption;
        }

        public final void setMatchOption(String matchOption) {
            this.matchOption = matchOption;
        }

        @Override
        public final Builder matchOption(String matchOption) {
            this.matchOption = matchOption;
            return this;
        }

        @Override
        public final Builder matchOption(MatchOption matchOption) {
            this.matchOption(matchOption == null ? null : matchOption.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = LineItemFilterValuesListCopier.copy(values);
        }

        @Override
        public final Builder valuesWithStrings(Collection<String> values) {
            this.values = LineItemFilterValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesWithStrings(String... values) {
            valuesWithStrings(Arrays.asList(values));
            return this;
        }

        @Override
        public final Builder values(Collection<LineItemFilterValue> values) {
            this.values = LineItemFilterValuesListCopier.copyEnumToString(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(LineItemFilterValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public LineItemFilter build() {
            return new LineItemFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
