/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomLineItemVersionsResponse extends BillingconductorResponse implements
        ToCopyableBuilder<ListCustomLineItemVersionsResponse.Builder, ListCustomLineItemVersionsResponse> {
    private static final SdkField<List<CustomLineItemVersionListElement>> CUSTOM_LINE_ITEM_VERSIONS_FIELD = SdkField
            .<List<CustomLineItemVersionListElement>> builder(MarshallingType.LIST)
            .memberName("CustomLineItemVersions")
            .getter(getter(ListCustomLineItemVersionsResponse::customLineItemVersions))
            .setter(setter(Builder::customLineItemVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLineItemVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomLineItemVersionListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomLineItemVersionListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomLineItemVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_LINE_ITEM_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<CustomLineItemVersionListElement> customLineItemVersions;

    private final String nextToken;

    private ListCustomLineItemVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.customLineItemVersions = builder.customLineItemVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomLineItemVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomLineItemVersions() {
        return customLineItemVersions != null && !(customLineItemVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>CustomLineItemVersionListElements</code> that are received.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomLineItemVersions} method.
     * </p>
     * 
     * @return A list of <code>CustomLineItemVersionListElements</code> that are received.
     */
    public final List<CustomLineItemVersionListElement> customLineItemVersions() {
        return customLineItemVersions;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent calls to retrieve custom line item versions.
     * </p>
     * 
     * @return The pagination token that's used on subsequent calls to retrieve custom line item versions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomLineItemVersions() ? customLineItemVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemVersionsResponse)) {
            return false;
        }
        ListCustomLineItemVersionsResponse other = (ListCustomLineItemVersionsResponse) obj;
        return hasCustomLineItemVersions() == other.hasCustomLineItemVersions()
                && Objects.equals(customLineItemVersions(), other.customLineItemVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomLineItemVersionsResponse")
                .add("CustomLineItemVersions", hasCustomLineItemVersions() ? customLineItemVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLineItemVersions":
            return Optional.ofNullable(clazz.cast(customLineItemVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemVersionsResponse, T> g) {
        return obj -> g.apply((ListCustomLineItemVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomLineItemVersionsResponse> {
        /**
         * <p>
         * A list of <code>CustomLineItemVersionListElements</code> that are received.
         * </p>
         * 
         * @param customLineItemVersions
         *        A list of <code>CustomLineItemVersionListElements</code> that are received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLineItemVersions(Collection<CustomLineItemVersionListElement> customLineItemVersions);

        /**
         * <p>
         * A list of <code>CustomLineItemVersionListElements</code> that are received.
         * </p>
         * 
         * @param customLineItemVersions
         *        A list of <code>CustomLineItemVersionListElements</code> that are received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLineItemVersions(CustomLineItemVersionListElement... customLineItemVersions);

        /**
         * <p>
         * A list of <code>CustomLineItemVersionListElements</code> that are received.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #customLineItemVersions(List<CustomLineItemVersionListElement>)}.
         * 
         * @param customLineItemVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.CustomLineItemVersionListElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLineItemVersions(java.util.Collection<CustomLineItemVersionListElement>)
         */
        Builder customLineItemVersions(Consumer<CustomLineItemVersionListElement.Builder>... customLineItemVersions);

        /**
         * <p>
         * The pagination token that's used on subsequent calls to retrieve custom line item versions.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent calls to retrieve custom line item versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private List<CustomLineItemVersionListElement> customLineItemVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemVersionsResponse model) {
            super(model);
            customLineItemVersions(model.customLineItemVersions);
            nextToken(model.nextToken);
        }

        public final List<CustomLineItemVersionListElement.Builder> getCustomLineItemVersions() {
            List<CustomLineItemVersionListElement.Builder> result = CustomLineItemVersionListCopier
                    .copyToBuilder(this.customLineItemVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomLineItemVersions(
                Collection<CustomLineItemVersionListElement.BuilderImpl> customLineItemVersions) {
            this.customLineItemVersions = CustomLineItemVersionListCopier.copyFromBuilder(customLineItemVersions);
        }

        @Override
        public final Builder customLineItemVersions(Collection<CustomLineItemVersionListElement> customLineItemVersions) {
            this.customLineItemVersions = CustomLineItemVersionListCopier.copy(customLineItemVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLineItemVersions(CustomLineItemVersionListElement... customLineItemVersions) {
            customLineItemVersions(Arrays.asList(customLineItemVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLineItemVersions(Consumer<CustomLineItemVersionListElement.Builder>... customLineItemVersions) {
            customLineItemVersions(Stream.of(customLineItemVersions)
                    .map(c -> CustomLineItemVersionListElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomLineItemVersionsResponse build() {
            return new ListCustomLineItemVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
