/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePricingRulesRequest extends BillingconductorRequest implements
        ToCopyableBuilder<AssociatePricingRulesRequest.Builder, AssociatePricingRulesRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AssociatePricingRulesRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> PRICING_RULE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PricingRuleArns")
            .getter(getter(AssociatePricingRulesRequest::pricingRuleArns))
            .setter(setter(Builder::pricingRuleArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingRuleArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            PRICING_RULE_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final List<String> pricingRuleArns;

    private AssociatePricingRulesRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.pricingRuleArns = builder.pricingRuleArns;
    }

    /**
     * <p>
     * The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with.
     * </p>
     * 
     * @return The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PricingRuleArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPricingRuleArns() {
        return pricingRuleArns != null && !(pricingRuleArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPricingRuleArns} method.
     * </p>
     * 
     * @return The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
     */
    public final List<String> pricingRuleArns() {
        return pricingRuleArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPricingRuleArns() ? pricingRuleArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePricingRulesRequest)) {
            return false;
        }
        AssociatePricingRulesRequest other = (AssociatePricingRulesRequest) obj;
        return Objects.equals(arn(), other.arn()) && hasPricingRuleArns() == other.hasPricingRuleArns()
                && Objects.equals(pricingRuleArns(), other.pricingRuleArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePricingRulesRequest").add("Arn", arn())
                .add("PricingRuleArns", hasPricingRuleArns() ? pricingRuleArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PricingRuleArns":
            return Optional.ofNullable(clazz.cast(pricingRuleArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("PricingRuleArns", PRICING_RULE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatePricingRulesRequest, T> g) {
        return obj -> g.apply((AssociatePricingRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociatePricingRulesRequest> {
        /**
         * <p>
         * The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with.
         * </p>
         * 
         * @param arn
         *        The <code>PricingPlanArn</code> that the <code>PricingRuleArns</code> are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
         * </p>
         * 
         * @param pricingRuleArns
         *        The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRuleArns(Collection<String> pricingRuleArns);

        /**
         * <p>
         * The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
         * </p>
         * 
         * @param pricingRuleArns
         *        The <code>PricingRuleArns</code> that are associated with the Pricing Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingRuleArns(String... pricingRuleArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private List<String> pricingRuleArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePricingRulesRequest model) {
            super(model);
            arn(model.arn);
            pricingRuleArns(model.pricingRuleArns);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getPricingRuleArns() {
            if (pricingRuleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return pricingRuleArns;
        }

        public final void setPricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsNonEmptyInputCopier.copy(pricingRuleArns);
        }

        @Override
        public final Builder pricingRuleArns(Collection<String> pricingRuleArns) {
            this.pricingRuleArns = PricingRuleArnsNonEmptyInputCopier.copy(pricingRuleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingRuleArns(String... pricingRuleArns) {
            pricingRuleArns(Arrays.asList(pricingRuleArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePricingRulesRequest build() {
            return new AssociatePricingRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
