/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateResourcesToCustomLineItemResponse extends BillingconductorResponse
        implements
        ToCopyableBuilder<BatchAssociateResourcesToCustomLineItemResponse.Builder, BatchAssociateResourcesToCustomLineItemResponse> {
    private static final SdkField<List<AssociateResourceResponseElement>> SUCCESSFULLY_ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<AssociateResourceResponseElement>> builder(MarshallingType.LIST)
            .memberName("SuccessfullyAssociatedResources")
            .getter(getter(BatchAssociateResourcesToCustomLineItemResponse::successfullyAssociatedResources))
            .setter(setter(Builder::successfullyAssociatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfullyAssociatedResources")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociateResourceResponseElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociateResourceResponseElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssociateResourceResponseElement>> FAILED_ASSOCIATED_RESOURCES_FIELD = SdkField
            .<List<AssociateResourceResponseElement>> builder(MarshallingType.LIST)
            .memberName("FailedAssociatedResources")
            .getter(getter(BatchAssociateResourcesToCustomLineItemResponse::failedAssociatedResources))
            .setter(setter(Builder::failedAssociatedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedAssociatedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociateResourceResponseElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociateResourceResponseElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFULLY_ASSOCIATED_RESOURCES_FIELD, FAILED_ASSOCIATED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssociateResourceResponseElement> successfullyAssociatedResources;

    private final List<AssociateResourceResponseElement> failedAssociatedResources;

    private BatchAssociateResourcesToCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyAssociatedResources = builder.successfullyAssociatedResources;
        this.failedAssociatedResources = builder.failedAssociatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuccessfullyAssociatedResources
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasSuccessfullyAssociatedResources() {
        return successfullyAssociatedResources != null && !(successfullyAssociatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a percentage
     * custom line item successfully.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessfullyAssociatedResources}
     * method.
     * </p>
     * 
     * @return A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
     *         percentage custom line item successfully.
     */
    public final List<AssociateResourceResponseElement> successfullyAssociatedResources() {
        return successfullyAssociatedResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedAssociatedResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedAssociatedResources() {
        return failedAssociatedResources != null && !(failedAssociatedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a percentage
     * custom line item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedAssociatedResources} method.
     * </p>
     * 
     * @return A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
     *         percentage custom line item.
     */
    public final List<AssociateResourceResponseElement> failedAssociatedResources() {
        return failedAssociatedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSuccessfullyAssociatedResources() ? successfullyAssociatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedAssociatedResources() ? failedAssociatedResources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateResourcesToCustomLineItemResponse)) {
            return false;
        }
        BatchAssociateResourcesToCustomLineItemResponse other = (BatchAssociateResourcesToCustomLineItemResponse) obj;
        return hasSuccessfullyAssociatedResources() == other.hasSuccessfullyAssociatedResources()
                && Objects.equals(successfullyAssociatedResources(), other.successfullyAssociatedResources())
                && hasFailedAssociatedResources() == other.hasFailedAssociatedResources()
                && Objects.equals(failedAssociatedResources(), other.failedAssociatedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchAssociateResourcesToCustomLineItemResponse")
                .add("SuccessfullyAssociatedResources",
                        hasSuccessfullyAssociatedResources() ? successfullyAssociatedResources() : null)
                .add("FailedAssociatedResources", hasFailedAssociatedResources() ? failedAssociatedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfullyAssociatedResources":
            return Optional.ofNullable(clazz.cast(successfullyAssociatedResources()));
        case "FailedAssociatedResources":
            return Optional.ofNullable(clazz.cast(failedAssociatedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SuccessfullyAssociatedResources", SUCCESSFULLY_ASSOCIATED_RESOURCES_FIELD);
        map.put("FailedAssociatedResources", FAILED_ASSOCIATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateResourcesToCustomLineItemResponse, T> g) {
        return obj -> g.apply((BatchAssociateResourcesToCustomLineItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateResourcesToCustomLineItemResponse> {
        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
         * percentage custom line item successfully.
         * </p>
         * 
         * @param successfullyAssociatedResources
         *        A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
         *        percentage custom line item successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyAssociatedResources(Collection<AssociateResourceResponseElement> successfullyAssociatedResources);

        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
         * percentage custom line item successfully.
         * </p>
         * 
         * @param successfullyAssociatedResources
         *        A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
         *        percentage custom line item successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyAssociatedResources(AssociateResourceResponseElement... successfullyAssociatedResources);

        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that's been associated to a
         * percentage custom line item successfully.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #successfullyAssociatedResources(List<AssociateResourceResponseElement>)}.
         * 
         * @param successfullyAssociatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfullyAssociatedResources(java.util.Collection<AssociateResourceResponseElement>)
         */
        Builder successfullyAssociatedResources(
                Consumer<AssociateResourceResponseElement.Builder>... successfullyAssociatedResources);

        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
         * percentage custom line item.
         * </p>
         * 
         * @param failedAssociatedResources
         *        A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
         *        percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAssociatedResources(Collection<AssociateResourceResponseElement> failedAssociatedResources);

        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
         * percentage custom line item.
         * </p>
         * 
         * @param failedAssociatedResources
         *        A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
         *        percentage custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedAssociatedResources(AssociateResourceResponseElement... failedAssociatedResources);

        /**
         * <p>
         * A list of <code>AssociateResourceResponseElement</code> for each resource that failed association to a
         * percentage custom line item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #failedAssociatedResources(List<AssociateResourceResponseElement>)}.
         * 
         * @param failedAssociatedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.AssociateResourceResponseElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedAssociatedResources(java.util.Collection<AssociateResourceResponseElement>)
         */
        Builder failedAssociatedResources(Consumer<AssociateResourceResponseElement.Builder>... failedAssociatedResources);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private List<AssociateResourceResponseElement> successfullyAssociatedResources = DefaultSdkAutoConstructList
                .getInstance();

        private List<AssociateResourceResponseElement> failedAssociatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateResourcesToCustomLineItemResponse model) {
            super(model);
            successfullyAssociatedResources(model.successfullyAssociatedResources);
            failedAssociatedResources(model.failedAssociatedResources);
        }

        public final List<AssociateResourceResponseElement.Builder> getSuccessfullyAssociatedResources() {
            List<AssociateResourceResponseElement.Builder> result = AssociateResourcesResponseListCopier
                    .copyToBuilder(this.successfullyAssociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfullyAssociatedResources(
                Collection<AssociateResourceResponseElement.BuilderImpl> successfullyAssociatedResources) {
            this.successfullyAssociatedResources = AssociateResourcesResponseListCopier
                    .copyFromBuilder(successfullyAssociatedResources);
        }

        @Override
        public final Builder successfullyAssociatedResources(
                Collection<AssociateResourceResponseElement> successfullyAssociatedResources) {
            this.successfullyAssociatedResources = AssociateResourcesResponseListCopier.copy(successfullyAssociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyAssociatedResources(AssociateResourceResponseElement... successfullyAssociatedResources) {
            successfullyAssociatedResources(Arrays.asList(successfullyAssociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyAssociatedResources(
                Consumer<AssociateResourceResponseElement.Builder>... successfullyAssociatedResources) {
            successfullyAssociatedResources(Stream.of(successfullyAssociatedResources)
                    .map(c -> AssociateResourceResponseElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssociateResourceResponseElement.Builder> getFailedAssociatedResources() {
            List<AssociateResourceResponseElement.Builder> result = AssociateResourcesResponseListCopier
                    .copyToBuilder(this.failedAssociatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedAssociatedResources(
                Collection<AssociateResourceResponseElement.BuilderImpl> failedAssociatedResources) {
            this.failedAssociatedResources = AssociateResourcesResponseListCopier.copyFromBuilder(failedAssociatedResources);
        }

        @Override
        public final Builder failedAssociatedResources(Collection<AssociateResourceResponseElement> failedAssociatedResources) {
            this.failedAssociatedResources = AssociateResourcesResponseListCopier.copy(failedAssociatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociatedResources(AssociateResourceResponseElement... failedAssociatedResources) {
            failedAssociatedResources(Arrays.asList(failedAssociatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedAssociatedResources(
                Consumer<AssociateResourceResponseElement.Builder>... failedAssociatedResources) {
            failedAssociatedResources(Stream.of(failedAssociatedResources)
                    .map(c -> AssociateResourceResponseElement.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAssociateResourcesToCustomLineItemResponse build() {
            return new BatchAssociateResourcesToCustomLineItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
