/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary report of actual Amazon Web Services charges and calculated Amazon Web Services charges, based on the
 * associated pricing plan of a billing group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillingGroupCostReportElement implements SdkPojo, Serializable,
        ToCopyableBuilder<BillingGroupCostReportElement.Builder, BillingGroupCostReportElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(BillingGroupCostReportElement::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> AWS_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSCost").getter(getter(BillingGroupCostReportElement::awsCost)).setter(setter(Builder::awsCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSCost").build()).build();

    private static final SdkField<String> PROFORMA_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProformaCost").getter(getter(BillingGroupCostReportElement::proformaCost))
            .setter(setter(Builder::proformaCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProformaCost").build()).build();

    private static final SdkField<String> MARGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Margin")
            .getter(getter(BillingGroupCostReportElement::margin)).setter(setter(Builder::margin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Margin").build()).build();

    private static final SdkField<String> MARGIN_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MarginPercentage").getter(getter(BillingGroupCostReportElement::marginPercentage))
            .setter(setter(Builder::marginPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarginPercentage").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Currency").getter(getter(BillingGroupCostReportElement::currency)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_COST_FIELD,
            PROFORMA_COST_FIELD, MARGIN_FIELD, MARGIN_PERCENTAGE_FIELD, CURRENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String awsCost;

    private final String proformaCost;

    private final String margin;

    private final String marginPercentage;

    private final String currency;

    private BillingGroupCostReportElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsCost = builder.awsCost;
        this.proformaCost = builder.proformaCost;
        this.margin = builder.margin;
        this.marginPercentage = builder.marginPercentage;
        this.currency = builder.currency;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a billing group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a billing group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The actual Amazon Web Services charges for the billing group.
     * </p>
     * 
     * @return The actual Amazon Web Services charges for the billing group.
     */
    public final String awsCost() {
        return awsCost;
    }

    /**
     * <p>
     * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
     * </p>
     * 
     * @return The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
     */
    public final String proformaCost() {
        return proformaCost;
    }

    /**
     * <p>
     * The billing group margin.
     * </p>
     * 
     * @return The billing group margin.
     */
    public final String margin() {
        return margin;
    }

    /**
     * <p>
     * The percentage of billing group margin.
     * </p>
     * 
     * @return The percentage of billing group margin.
     */
    public final String marginPercentage() {
        return marginPercentage;
    }

    /**
     * <p>
     * The displayed currency.
     * </p>
     * 
     * @return The displayed currency.
     */
    public final String currency() {
        return currency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(awsCost());
        hashCode = 31 * hashCode + Objects.hashCode(proformaCost());
        hashCode = 31 * hashCode + Objects.hashCode(margin());
        hashCode = 31 * hashCode + Objects.hashCode(marginPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(currency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingGroupCostReportElement)) {
            return false;
        }
        BillingGroupCostReportElement other = (BillingGroupCostReportElement) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(awsCost(), other.awsCost())
                && Objects.equals(proformaCost(), other.proformaCost()) && Objects.equals(margin(), other.margin())
                && Objects.equals(marginPercentage(), other.marginPercentage()) && Objects.equals(currency(), other.currency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillingGroupCostReportElement").add("Arn", arn()).add("AWSCost", awsCost())
                .add("ProformaCost", proformaCost()).add("Margin", margin()).add("MarginPercentage", marginPercentage())
                .add("Currency", currency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AWSCost":
            return Optional.ofNullable(clazz.cast(awsCost()));
        case "ProformaCost":
            return Optional.ofNullable(clazz.cast(proformaCost()));
        case "Margin":
            return Optional.ofNullable(clazz.cast(margin()));
        case "MarginPercentage":
            return Optional.ofNullable(clazz.cast(marginPercentage()));
        case "Currency":
            return Optional.ofNullable(clazz.cast(currency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("AWSCost", AWS_COST_FIELD);
        map.put("ProformaCost", PROFORMA_COST_FIELD);
        map.put("Margin", MARGIN_FIELD);
        map.put("MarginPercentage", MARGIN_PERCENTAGE_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingGroupCostReportElement, T> g) {
        return obj -> g.apply((BillingGroupCostReportElement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillingGroupCostReportElement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a billing group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The actual Amazon Web Services charges for the billing group.
         * </p>
         * 
         * @param awsCost
         *        The actual Amazon Web Services charges for the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsCost(String awsCost);

        /**
         * <p>
         * The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
         * </p>
         * 
         * @param proformaCost
         *        The hypothetical Amazon Web Services charges based on the associated pricing plan of a billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proformaCost(String proformaCost);

        /**
         * <p>
         * The billing group margin.
         * </p>
         * 
         * @param margin
         *        The billing group margin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder margin(String margin);

        /**
         * <p>
         * The percentage of billing group margin.
         * </p>
         * 
         * @param marginPercentage
         *        The percentage of billing group margin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marginPercentage(String marginPercentage);

        /**
         * <p>
         * The displayed currency.
         * </p>
         * 
         * @param currency
         *        The displayed currency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currency(String currency);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String awsCost;

        private String proformaCost;

        private String margin;

        private String marginPercentage;

        private String currency;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingGroupCostReportElement model) {
            arn(model.arn);
            awsCost(model.awsCost);
            proformaCost(model.proformaCost);
            margin(model.margin);
            marginPercentage(model.marginPercentage);
            currency(model.currency);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsCost() {
            return awsCost;
        }

        public final void setAwsCost(String awsCost) {
            this.awsCost = awsCost;
        }

        @Override
        public final Builder awsCost(String awsCost) {
            this.awsCost = awsCost;
            return this;
        }

        public final String getProformaCost() {
            return proformaCost;
        }

        public final void setProformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
        }

        @Override
        public final Builder proformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
            return this;
        }

        public final String getMargin() {
            return margin;
        }

        public final void setMargin(String margin) {
            this.margin = margin;
        }

        @Override
        public final Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public final String getMarginPercentage() {
            return marginPercentage;
        }

        public final void setMarginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
        }

        @Override
        public final Builder marginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public BillingGroupCostReportElement build() {
            return new BillingGroupCostReportElement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
