/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The possible Amazon Web Services Free Tier configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFreeTierConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateFreeTierConfig.Builder, CreateFreeTierConfig> {
    private static final SdkField<Boolean> ACTIVATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Activated").getter(getter(CreateFreeTierConfig::activated)).setter(setter(Builder::activated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Activated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean activated;

    private CreateFreeTierConfig(BuilderImpl builder) {
        this.activated = builder.activated;
    }

    /**
     * <p>
     * Activate or deactivate Amazon Web Services Free Tier.
     * </p>
     * 
     * @return Activate or deactivate Amazon Web Services Free Tier.
     */
    public final Boolean activated() {
        return activated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFreeTierConfig)) {
            return false;
        }
        CreateFreeTierConfig other = (CreateFreeTierConfig) obj;
        return Objects.equals(activated(), other.activated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFreeTierConfig").add("Activated", activated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activated":
            return Optional.ofNullable(clazz.cast(activated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Activated", ACTIVATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFreeTierConfig, T> g) {
        return obj -> g.apply((CreateFreeTierConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateFreeTierConfig> {
        /**
         * <p>
         * Activate or deactivate Amazon Web Services Free Tier.
         * </p>
         * 
         * @param activated
         *        Activate or deactivate Amazon Web Services Free Tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activated(Boolean activated);
    }

    static final class BuilderImpl implements Builder {
        private Boolean activated;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFreeTierConfig model) {
            activated(model.activated);
        }

        public final Boolean getActivated() {
            return activated;
        }

        public final void setActivated(Boolean activated) {
            this.activated = activated;
        }

        @Override
        public final Builder activated(Boolean activated) {
            this.activated = activated;
            return this;
        }

        @Override
        public CreateFreeTierConfig build() {
            return new CreateFreeTierConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
