/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePricingRuleRequest extends BillingconductorRequest implements
        ToCopyableBuilder<CreatePricingRuleRequest.Builder, CreatePricingRuleRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreatePricingRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePricingRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreatePricingRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(CreatePricingRuleRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreatePricingRuleRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Double> MODIFIER_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ModifierPercentage").getter(getter(CreatePricingRuleRequest::modifierPercentage))
            .setter(setter(Builder::modifierPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifierPercentage").build())
            .build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(CreatePricingRuleRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreatePricingRuleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BILLING_ENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingEntity").getter(getter(CreatePricingRuleRequest::billingEntity))
            .setter(setter(Builder::billingEntity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingEntity").build()).build();

    private static final SdkField<CreateTieringInput> TIERING_FIELD = SdkField
            .<CreateTieringInput> builder(MarshallingType.SDK_POJO).memberName("Tiering")
            .getter(getter(CreatePricingRuleRequest::tiering)).setter(setter(Builder::tiering))
            .constructor(CreateTieringInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tiering").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageType").getter(getter(CreatePricingRuleRequest::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(CreatePricingRuleRequest::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, SCOPE_FIELD, TYPE_FIELD, MODIFIER_PERCENTAGE_FIELD, SERVICE_FIELD, TAGS_FIELD,
            BILLING_ENTITY_FIELD, TIERING_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String name;

    private final String description;

    private final String scope;

    private final String type;

    private final Double modifierPercentage;

    private final String service;

    private final Map<String, String> tags;

    private final String billingEntity;

    private final CreateTieringInput tiering;

    private final String usageType;

    private final String operation;

    private CreatePricingRuleRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.scope = builder.scope;
        this.type = builder.type;
        this.modifierPercentage = builder.modifierPercentage;
        this.service = builder.service;
        this.tags = builder.tags;
        this.billingEntity = builder.billingEntity;
        this.tiering = builder.tiering;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
    }

    /**
     * <p>
     * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be implemented in
     * a future update.
     * </p>
     * 
     * @return The token that's needed to support idempotency. Idempotency isn't currently supported, but will be
     *         implemented in a future update.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The pricing rule name. The names must be unique to each pricing rule.
     * </p>
     * 
     * @return The pricing rule name. The names must be unique to each pricing rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The pricing rule description.
     * </p>
     * 
     * @return The pricing rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * @see PricingRuleScope
     */
    public final PricingRuleScope scope() {
        return PricingRuleScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link PricingRuleScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
     * @see PricingRuleScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The type of pricing rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of pricing rule.
     * @see PricingRuleType
     */
    public final PricingRuleType type() {
        return PricingRuleType.fromValue(type);
    }

    /**
     * <p>
     * The type of pricing rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PricingRuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of pricing rule.
     * @see PricingRuleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A percentage modifier that's applied on the public pricing rates.
     * </p>
     * 
     * @return A percentage modifier that's applied on the public pricing rates.
     */
    public final Double modifierPercentage() {
        return modifierPercentage;
    }

    /**
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SERVICE</code> or <code>SKU</code>, the attribute indicates
     * which service the <code>PricingRule</code> is applicable for.
     * </p>
     * 
     * @return If the <code>Scope</code> attribute is set to <code>SERVICE</code> or <code>SKU</code>, the attribute
     *         indicates which service the <code>PricingRule</code> is applicable for.
     */
    public final String service() {
        return service;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to a pricing rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to a pricing rule.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling
     * services via Amazon Web Services Marketplace.
     * </p>
     * 
     * @return The seller of services provided by Amazon Web Services, their affiliates, or third-party providers
     *         selling services via Amazon Web Services Marketplace.
     */
    public final String billingEntity() {
        return billingEntity;
    }

    /**
     * <p>
     * The set of tiering configurations for the pricing rule.
     * </p>
     * 
     * @return The set of tiering configurations for the pricing rule.
     */
    public final CreateTieringInput tiering() {
        return tiering;
    }

    /**
     * <p>
     * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
     * </p>
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type the
     * <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes an
     * <code> M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
     * 
     * <pre>
     * <code>&lt;/p&gt; </code>
     * </pre>
     * 
     * @return Usage type is the unit that each service uses to measure the usage of a specific type of resource.
     *         </p>
     *         <p>
     *         If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type
     *         the <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes
     *         an<code> M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
     * 
     * <pre><code>&lt;/p&gt; </code>
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific usage
     * of the line item.
     * </p>
     * <p>
     * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation the
     * <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code> indicates the
     * operation of running an Amazon EC2 instance.
     * </p>
     * 
     * @return Operation is the specific Amazon Web Services action covered by this line item. This describes the
     *         specific usage of the line item.</p>
     *         <p>
     *         If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation
     *         the <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code>
     *         indicates the operation of running an Amazon EC2 instance.
     */
    public final String operation() {
        return operation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modifierPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingEntity());
        hashCode = 31 * hashCode + Objects.hashCode(tiering());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePricingRuleRequest)) {
            return false;
        }
        CreatePricingRuleRequest other = (CreatePricingRuleRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(scopeAsString(), other.scopeAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(modifierPercentage(), other.modifierPercentage()) && Objects.equals(service(), other.service())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(billingEntity(), other.billingEntity()) && Objects.equals(tiering(), other.tiering())
                && Objects.equals(usageType(), other.usageType()) && Objects.equals(operation(), other.operation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePricingRuleRequest").add("ClientToken", clientToken())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Scope", scopeAsString()).add("Type", typeAsString()).add("ModifierPercentage", modifierPercentage())
                .add("Service", service()).add("Tags", hasTags() ? tags() : null).add("BillingEntity", billingEntity())
                .add("Tiering", tiering()).add("UsageType", usageType()).add("Operation", operation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ModifierPercentage":
            return Optional.ofNullable(clazz.cast(modifierPercentage()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "BillingEntity":
            return Optional.ofNullable(clazz.cast(billingEntity()));
        case "Tiering":
            return Optional.ofNullable(clazz.cast(tiering()));
        case "UsageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amzn-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ModifierPercentage", MODIFIER_PERCENTAGE_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("BillingEntity", BILLING_ENTITY_FIELD);
        map.put("Tiering", TIERING_FIELD);
        map.put("UsageType", USAGE_TYPE_FIELD);
        map.put("Operation", OPERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePricingRuleRequest, T> g) {
        return obj -> g.apply((CreatePricingRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePricingRuleRequest> {
        /**
         * <p>
         * The token that's needed to support idempotency. Idempotency isn't currently supported, but will be
         * implemented in a future update.
         * </p>
         * 
         * @param clientToken
         *        The token that's needed to support idempotency. Idempotency isn't currently supported, but will be
         *        implemented in a future update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The pricing rule name. The names must be unique to each pricing rule.
         * </p>
         * 
         * @param name
         *        The pricing rule name. The names must be unique to each pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The pricing rule description.
         * </p>
         * 
         * @param description
         *        The pricing rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * </p>
         * 
         * @param scope
         *        The scope of pricing rule that indicates if it's globally applicable, or it's service-specific.
         * @see PricingRuleScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleScope
         */
        Builder scope(PricingRuleScope scope);

        /**
         * <p>
         * The type of pricing rule.
         * </p>
         * 
         * @param type
         *        The type of pricing rule.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of pricing rule.
         * </p>
         * 
         * @param type
         *        The type of pricing rule.
         * @see PricingRuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingRuleType
         */
        Builder type(PricingRuleType type);

        /**
         * <p>
         * A percentage modifier that's applied on the public pricing rates.
         * </p>
         * 
         * @param modifierPercentage
         *        A percentage modifier that's applied on the public pricing rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifierPercentage(Double modifierPercentage);

        /**
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SERVICE</code> or <code>SKU</code>, the attribute
         * indicates which service the <code>PricingRule</code> is applicable for.
         * </p>
         * 
         * @param service
         *        If the <code>Scope</code> attribute is set to <code>SERVICE</code> or <code>SKU</code>, the attribute
         *        indicates which service the <code>PricingRule</code> is applicable for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to a pricing rule.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to a pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The seller of services provided by Amazon Web Services, their affiliates, or third-party providers selling
         * services via Amazon Web Services Marketplace.
         * </p>
         * 
         * @param billingEntity
         *        The seller of services provided by Amazon Web Services, their affiliates, or third-party providers
         *        selling services via Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingEntity(String billingEntity);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * 
         * @param tiering
         *        The set of tiering configurations for the pricing rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tiering(CreateTieringInput tiering);

        /**
         * <p>
         * The set of tiering configurations for the pricing rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateTieringInput.Builder} avoiding the
         * need to create one manually via {@link CreateTieringInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateTieringInput.Builder#build()} is called immediately and its
         * result is passed to {@link #tiering(CreateTieringInput)}.
         * 
         * @param tiering
         *        a consumer that will call methods on {@link CreateTieringInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tiering(CreateTieringInput)
         */
        default Builder tiering(Consumer<CreateTieringInput.Builder> tiering) {
            return tiering(CreateTieringInput.builder().applyMutation(tiering).build());
        }

        /**
         * <p>
         * Usage type is the unit that each service uses to measure the usage of a specific type of resource.
         * </p>
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage type the
         * <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code> describes an
         * <code> M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
         * 
         * <pre>
         * <code>&lt;/p&gt; </code>
         * </pre>
         * 
         * @param usageType
         *        Usage type is the unit that each service uses to measure the usage of a specific type of resource.
         *        </p>
         *        <p>
         *        If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which usage
         *        type the <code>PricingRule</code> is modifying. For example, <code>USW2-BoxUsage:m2.2xlarge</code>
         *        describes an<code> M2 High Memory Double Extra Large</code> instance in the US West (Oregon) Region.
         * 
         *        <pre>
         * <code>&lt;/p&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * Operation is the specific Amazon Web Services action covered by this line item. This describes the specific
         * usage of the line item.
         * </p>
         * <p>
         * If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which operation the
         * <code>PricingRule</code> is modifying. For example, a value of <code>RunInstances:0202</code> indicates the
         * operation of running an Amazon EC2 instance.
         * </p>
         * 
         * @param operation
         *        Operation is the specific Amazon Web Services action covered by this line item. This describes the
         *        specific usage of the line item.</p>
         *        <p>
         *        If the <code>Scope</code> attribute is set to <code>SKU</code>, this attribute indicates which
         *        operation the <code>PricingRule</code> is modifying. For example, a value of
         *        <code>RunInstances:0202</code> indicates the operation of running an Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private String description;

        private String scope;

        private String type;

        private Double modifierPercentage;

        private String service;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String billingEntity;

        private CreateTieringInput tiering;

        private String usageType;

        private String operation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePricingRuleRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            description(model.description);
            scope(model.scope);
            type(model.type);
            modifierPercentage(model.modifierPercentage);
            service(model.service);
            tags(model.tags);
            billingEntity(model.billingEntity);
            tiering(model.tiering);
            usageType(model.usageType);
            operation(model.operation);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PricingRuleScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PricingRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getModifierPercentage() {
            return modifierPercentage;
        }

        public final void setModifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
        }

        @Override
        public final Builder modifierPercentage(Double modifierPercentage) {
            this.modifierPercentage = modifierPercentage;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBillingEntity() {
            return billingEntity;
        }

        public final void setBillingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
        }

        @Override
        public final Builder billingEntity(String billingEntity) {
            this.billingEntity = billingEntity;
            return this;
        }

        public final CreateTieringInput.Builder getTiering() {
            return tiering != null ? tiering.toBuilder() : null;
        }

        public final void setTiering(CreateTieringInput.BuilderImpl tiering) {
            this.tiering = tiering != null ? tiering.build() : null;
        }

        @Override
        public final Builder tiering(CreateTieringInput tiering) {
            this.tiering = tiering;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePricingRuleRequest build() {
            return new CreatePricingRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
