/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter used to retrieve specific <code>BillingGroupCostReportElements</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillingGroupCostReportsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListBillingGroupCostReportsFilter.Builder, ListBillingGroupCostReportsFilter> {
    private static final SdkField<List<String>> BILLING_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BillingGroupArns")
            .getter(getter(ListBillingGroupCostReportsFilter::billingGroupArns))
            .setter(setter(Builder::billingGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> billingGroupArns;

    private ListBillingGroupCostReportsFilter(BuilderImpl builder) {
        this.billingGroupArns = builder.billingGroupArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillingGroupArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillingGroupArns() {
        return billingGroupArns != null && !(billingGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingGroupArns} method.
     * </p>
     * 
     * @return The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
     */
    public final List<String> billingGroupArns() {
        return billingGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBillingGroupArns() ? billingGroupArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupCostReportsFilter)) {
            return false;
        }
        ListBillingGroupCostReportsFilter other = (ListBillingGroupCostReportsFilter) obj;
        return hasBillingGroupArns() == other.hasBillingGroupArns()
                && Objects.equals(billingGroupArns(), other.billingGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillingGroupCostReportsFilter")
                .add("BillingGroupArns", hasBillingGroupArns() ? billingGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingGroupArns":
            return Optional.ofNullable(clazz.cast(billingGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingGroupArns", BILLING_GROUP_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupCostReportsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupCostReportsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListBillingGroupCostReportsFilter> {
        /**
         * <p>
         * The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
         * </p>
         * 
         * @param billingGroupArns
         *        The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArns(Collection<String> billingGroupArns);

        /**
         * <p>
         * The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
         * </p>
         * 
         * @param billingGroupArns
         *        The list of Amazon Resource Names (ARNs) used to filter billing groups to retrieve reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArns(String... billingGroupArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> billingGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupCostReportsFilter model) {
            billingGroupArns(model.billingGroupArns);
        }

        public final Collection<String> getBillingGroupArns() {
            if (billingGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return billingGroupArns;
        }

        public final void setBillingGroupArns(Collection<String> billingGroupArns) {
            this.billingGroupArns = BillingGroupArnListCopier.copy(billingGroupArns);
        }

        @Override
        public final Builder billingGroupArns(Collection<String> billingGroupArns) {
            this.billingGroupArns = BillingGroupArnListCopier.copy(billingGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroupArns(String... billingGroupArns) {
            billingGroupArns(Arrays.asList(billingGroupArns));
            return this;
        }

        @Override
        public ListBillingGroupCostReportsFilter build() {
            return new ListBillingGroupCostReportsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
