/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBillingGroupsResponse extends BillingconductorResponse implements
        ToCopyableBuilder<ListBillingGroupsResponse.Builder, ListBillingGroupsResponse> {
    private static final SdkField<List<BillingGroupListElement>> BILLING_GROUPS_FIELD = SdkField
            .<List<BillingGroupListElement>> builder(MarshallingType.LIST)
            .memberName("BillingGroups")
            .getter(getter(ListBillingGroupsResponse::billingGroups))
            .setter(setter(Builder::billingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BillingGroupListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(BillingGroupListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBillingGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BillingGroupListElement> billingGroups;

    private final String nextToken;

    private ListBillingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroups = builder.billingGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BillingGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBillingGroups() {
        return billingGroups != null && !(billingGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>BillingGroupListElement</code> retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBillingGroups} method.
     * </p>
     * 
     * @return A list of <code>BillingGroupListElement</code> retrieved.
     */
    public final List<BillingGroupListElement> billingGroups() {
        return billingGroups;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent calls to get billing groups.
     * </p>
     * 
     * @return The pagination token that's used on subsequent calls to get billing groups.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBillingGroups() ? billingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsResponse)) {
            return false;
        }
        ListBillingGroupsResponse other = (ListBillingGroupsResponse) obj;
        return hasBillingGroups() == other.hasBillingGroups() && Objects.equals(billingGroups(), other.billingGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBillingGroupsResponse").add("BillingGroups", hasBillingGroups() ? billingGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingGroups":
            return Optional.ofNullable(clazz.cast(billingGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingGroups", BILLING_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsResponse, T> g) {
        return obj -> g.apply((ListBillingGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBillingGroupsResponse> {
        /**
         * <p>
         * A list of <code>BillingGroupListElement</code> retrieved.
         * </p>
         * 
         * @param billingGroups
         *        A list of <code>BillingGroupListElement</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroups(Collection<BillingGroupListElement> billingGroups);

        /**
         * <p>
         * A list of <code>BillingGroupListElement</code> retrieved.
         * </p>
         * 
         * @param billingGroups
         *        A list of <code>BillingGroupListElement</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroups(BillingGroupListElement... billingGroups);

        /**
         * <p>
         * A list of <code>BillingGroupListElement</code> retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupListElement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupListElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupListElement.Builder#build()} is
         * called immediately and its result is passed to {@link #billingGroups(List<BillingGroupListElement>)}.
         * 
         * @param billingGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.BillingGroupListElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroups(java.util.Collection<BillingGroupListElement>)
         */
        Builder billingGroups(Consumer<BillingGroupListElement.Builder>... billingGroups);

        /**
         * <p>
         * The pagination token that's used on subsequent calls to get billing groups.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent calls to get billing groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private List<BillingGroupListElement> billingGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsResponse model) {
            super(model);
            billingGroups(model.billingGroups);
            nextToken(model.nextToken);
        }

        public final List<BillingGroupListElement.Builder> getBillingGroups() {
            List<BillingGroupListElement.Builder> result = BillingGroupListCopier.copyToBuilder(this.billingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBillingGroups(Collection<BillingGroupListElement.BuilderImpl> billingGroups) {
            this.billingGroups = BillingGroupListCopier.copyFromBuilder(billingGroups);
        }

        @Override
        public final Builder billingGroups(Collection<BillingGroupListElement> billingGroups) {
            this.billingGroups = BillingGroupListCopier.copy(billingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroups(BillingGroupListElement... billingGroups) {
            billingGroups(Arrays.asList(billingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingGroups(Consumer<BillingGroupListElement.Builder>... billingGroups) {
            billingGroups(Stream.of(billingGroups).map(c -> BillingGroupListElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBillingGroupsResponse build() {
            return new ListBillingGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
