/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomLineItemVersionsRequest extends BillingconductorRequest implements
        ToCopyableBuilder<ListCustomLineItemVersionsRequest.Builder, ListCustomLineItemVersionsRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListCustomLineItemVersionsRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCustomLineItemVersionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCustomLineItemVersionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<ListCustomLineItemVersionsFilter> FILTERS_FIELD = SdkField
            .<ListCustomLineItemVersionsFilter> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListCustomLineItemVersionsRequest::filters)).setter(setter(Builder::filters))
            .constructor(ListCustomLineItemVersionsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Integer maxResults;

    private final String nextToken;

    private final ListCustomLineItemVersionsFilter filters;

    private ListCustomLineItemVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the custom line item.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the custom line item.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The maximum number of custom line item versions to retrieve.
     * </p>
     * 
     * @return The maximum number of custom line item versions to retrieve.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent calls to retrieve custom line item versions.
     * </p>
     * 
     * @return The pagination token that's used on subsequent calls to retrieve custom line item versions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A <code>ListCustomLineItemVersionsFilter</code> that specifies the billing period range in which the custom line
     * item versions are applied.
     * </p>
     * 
     * @return A <code>ListCustomLineItemVersionsFilter</code> that specifies the billing period range in which the
     *         custom line item versions are applied.
     */
    public final ListCustomLineItemVersionsFilter filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemVersionsRequest)) {
            return false;
        }
        ListCustomLineItemVersionsRequest other = (ListCustomLineItemVersionsRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomLineItemVersionsRequest").add("Arn", arn()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemVersionsRequest, T> g) {
        return obj -> g.apply((ListCustomLineItemVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomLineItemVersionsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the custom line item.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the custom line item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The maximum number of custom line item versions to retrieve.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of custom line item versions to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that's used on subsequent calls to retrieve custom line item versions.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent calls to retrieve custom line item versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A <code>ListCustomLineItemVersionsFilter</code> that specifies the billing period range in which the custom
         * line item versions are applied.
         * </p>
         * 
         * @param filters
         *        A <code>ListCustomLineItemVersionsFilter</code> that specifies the billing period range in which the
         *        custom line item versions are applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListCustomLineItemVersionsFilter filters);

        /**
         * <p>
         * A <code>ListCustomLineItemVersionsFilter</code> that specifies the billing period range in which the custom
         * line item versions are applied.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListCustomLineItemVersionsFilter.Builder}
         * avoiding the need to create one manually via {@link ListCustomLineItemVersionsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListCustomLineItemVersionsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(ListCustomLineItemVersionsFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ListCustomLineItemVersionsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ListCustomLineItemVersionsFilter)
         */
        default Builder filters(Consumer<ListCustomLineItemVersionsFilter.Builder> filters) {
            return filters(ListCustomLineItemVersionsFilter.builder().applyMutation(filters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BillingconductorRequest.BuilderImpl implements Builder {
        private String arn;

        private Integer maxResults;

        private String nextToken;

        private ListCustomLineItemVersionsFilter filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemVersionsRequest model) {
            super(model);
            arn(model.arn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ListCustomLineItemVersionsFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ListCustomLineItemVersionsFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListCustomLineItemVersionsFilter filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomLineItemVersionsRequest build() {
            return new ListCustomLineItemVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
