/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricingPlansResponse extends BillingconductorResponse implements
        ToCopyableBuilder<ListPricingPlansResponse.Builder, ListPricingPlansResponse> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingPeriod").getter(getter(ListPricingPlansResponse::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingPeriod").build()).build();

    private static final SdkField<List<PricingPlanListElement>> PRICING_PLANS_FIELD = SdkField
            .<List<PricingPlanListElement>> builder(MarshallingType.LIST)
            .memberName("PricingPlans")
            .getter(getter(ListPricingPlansResponse::pricingPlans))
            .setter(setter(Builder::pricingPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PricingPlanListElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(PricingPlanListElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPricingPlansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            PRICING_PLANS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String billingPeriod;

    private final List<PricingPlanListElement> pricingPlans;

    private final String nextToken;

    private ListPricingPlansResponse(BuilderImpl builder) {
        super(builder);
        this.billingPeriod = builder.billingPeriod;
        this.pricingPlans = builder.pricingPlans;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The billing period for which the described pricing plans are applicable.
     * </p>
     * 
     * @return The billing period for which the described pricing plans are applicable.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the PricingPlans property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPricingPlans() {
        return pricingPlans != null && !(pricingPlans instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PricingPlanListElement</code> retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPricingPlans} method.
     * </p>
     * 
     * @return A list of <code>PricingPlanListElement</code> retrieved.
     */
    public final List<PricingPlanListElement> pricingPlans() {
        return pricingPlans;
    }

    /**
     * <p>
     * The pagination token that's used on subsequent calls to get pricing plans.
     * </p>
     * 
     * @return The pagination token that's used on subsequent calls to get pricing plans.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasPricingPlans() ? pricingPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingPlansResponse)) {
            return false;
        }
        ListPricingPlansResponse other = (ListPricingPlansResponse) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && hasPricingPlans() == other.hasPricingPlans()
                && Objects.equals(pricingPlans(), other.pricingPlans()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricingPlansResponse").add("BillingPeriod", billingPeriod())
                .add("PricingPlans", hasPricingPlans() ? pricingPlans() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BillingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "PricingPlans":
            return Optional.ofNullable(clazz.cast(pricingPlans()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BillingPeriod", BILLING_PERIOD_FIELD);
        map.put("PricingPlans", PRICING_PLANS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingPlansResponse, T> g) {
        return obj -> g.apply((ListPricingPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BillingconductorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPricingPlansResponse> {
        /**
         * <p>
         * The billing period for which the described pricing plans are applicable.
         * </p>
         * 
         * @param billingPeriod
         *        The billing period for which the described pricing plans are applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * A list of <code>PricingPlanListElement</code> retrieved.
         * </p>
         * 
         * @param pricingPlans
         *        A list of <code>PricingPlanListElement</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlans(Collection<PricingPlanListElement> pricingPlans);

        /**
         * <p>
         * A list of <code>PricingPlanListElement</code> retrieved.
         * </p>
         * 
         * @param pricingPlans
         *        A list of <code>PricingPlanListElement</code> retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingPlans(PricingPlanListElement... pricingPlans);

        /**
         * <p>
         * A list of <code>PricingPlanListElement</code> retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement.Builder#build()} is
         * called immediately and its result is passed to {@link #pricingPlans(List<PricingPlanListElement>)}.
         * 
         * @param pricingPlans
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pricingPlans(java.util.Collection<PricingPlanListElement>)
         */
        Builder pricingPlans(Consumer<PricingPlanListElement.Builder>... pricingPlans);

        /**
         * <p>
         * The pagination token that's used on subsequent calls to get pricing plans.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used on subsequent calls to get pricing plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BillingconductorResponse.BuilderImpl implements Builder {
        private String billingPeriod;

        private List<PricingPlanListElement> pricingPlans = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingPlansResponse model) {
            super(model);
            billingPeriod(model.billingPeriod);
            pricingPlans(model.pricingPlans);
            nextToken(model.nextToken);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final List<PricingPlanListElement.Builder> getPricingPlans() {
            List<PricingPlanListElement.Builder> result = PricingPlanListCopier.copyToBuilder(this.pricingPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPricingPlans(Collection<PricingPlanListElement.BuilderImpl> pricingPlans) {
            this.pricingPlans = PricingPlanListCopier.copyFromBuilder(pricingPlans);
        }

        @Override
        public final Builder pricingPlans(Collection<PricingPlanListElement> pricingPlans) {
            this.pricingPlans = PricingPlanListCopier.copy(pricingPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingPlans(PricingPlanListElement... pricingPlans) {
            pricingPlans(Arrays.asList(pricingPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pricingPlans(Consumer<PricingPlanListElement.Builder>... pricingPlans) {
            pricingPlans(Stream.of(pricingPlans).map(c -> PricingPlanListElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPricingPlansResponse build() {
            return new ListPricingPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
