/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter that specifies criteria that the pricing rules returned by the <code>ListPricingRules</code> API will
 * adhere to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPricingRulesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListPricingRulesFilter.Builder, ListPricingRulesFilter> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Arns")
            .getter(getter(ListPricingRulesFilter::arns))
            .setter(setter(Builder::arns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> arns;

    private ListPricingRulesFilter(BuilderImpl builder) {
        this.arns = builder.arns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Arns property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasArns() {
        return arns != null && !(arns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArns} method.
     * </p>
     * 
     * @return A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
     */
    public final List<String> arns() {
        return arns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasArns() ? arns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPricingRulesFilter)) {
            return false;
        }
        ListPricingRulesFilter other = (ListPricingRulesFilter) obj;
        return hasArns() == other.hasArns() && Objects.equals(arns(), other.arns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPricingRulesFilter").add("Arns", hasArns() ? arns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arns":
            return Optional.ofNullable(clazz.cast(arns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arns", ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPricingRulesFilter, T> g) {
        return obj -> g.apply((ListPricingRulesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListPricingRulesFilter> {
        /**
         * <p>
         * A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
         * </p>
         * 
         * @param arns
         *        A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(Collection<String> arns);

        /**
         * <p>
         * A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
         * </p>
         * 
         * @param arns
         *        A list containing the pricing rule Amazon Resource Names (ARNs) to include in the API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arns(String... arns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPricingRulesFilter model) {
            arns(model.arns);
        }

        public final Collection<String> getArns() {
            if (arns instanceof SdkAutoConstructList) {
                return null;
            }
            return arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = PricingRuleArnsCopier.copy(arns);
        }

        @Override
        public final Builder arns(Collection<String> arns) {
            this.arns = PricingRuleArnsCopier.copy(arns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arns(String... arns) {
            arns(Arrays.asList(arns));
            return this;
        }

        @Override
        public ListPricingRulesFilter build() {
            return new ListPricingRulesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
